/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.table.header;

import java.util.Locale;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.table.header.HeaderTemplate;
import org.bardframework.table.header.StringHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;

public abstract class I18nBasedHeaderTemplate<M, T>
extends HeaderTemplate<M, StringHeader, T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(I18nBasedHeaderTemplate.class);
    private String i18nKeyPrefix;

    @Override
    protected Object format(T value, MessageSource messageSource, Locale locale) {
        Object i18nKey = this.getI18nKey(value);
        if (null == i18nKey) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)this.i18nKeyPrefix)) {
            i18nKey = this.i18nKeyPrefix + "." + (String)i18nKey;
        }
        return messageSource.getMessage((String)i18nKey, new Object[0], (String)i18nKey, locale);
    }

    @Override
    protected Object formatForExport(T value, MessageSource messageSource, Locale locale) {
        Object i18nKey = this.getI18nKey(value);
        if (null == i18nKey) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)this.i18nKeyPrefix)) {
            i18nKey = this.i18nKeyPrefix + "." + (String)i18nKey;
        }
        return messageSource.getMessage((String)i18nKey, new Object[0], (String)i18nKey, locale);
    }

    @Override
    public StringHeader getEmptyHeader() {
        return new StringHeader();
    }

    protected abstract String getI18nKey(T var1);

    @Generated
    public String getI18nKeyPrefix() {
        return this.i18nKeyPrefix;
    }

    @Generated
    public void setI18nKeyPrefix(String i18nKeyPrefix) {
        this.i18nKeyPrefix = i18nKeyPrefix;
    }

    @Override
    @Generated
    public String toString() {
        return "I18nBasedHeaderTemplate(i18nKeyPrefix=" + this.getI18nKeyPrefix() + ")";
    }
}

