/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.table.header;

import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.HijrahDate;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.function.Supplier;
import lombok.Generated;
import org.bardframework.commons.web.Calendar;
import org.bardframework.table.header.DateHeader;
import org.bardframework.table.header.HeaderTemplate;
import org.bardframework.time.LocalDateJalali;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;

public class LocalDateHeaderTemplate<M>
extends HeaderTemplate<M, DateHeader, LocalDate> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalDateHeaderTemplate.class);
    private final DateTimeFormatter formatter;
    private DateTimeFormatter exportFormatter;
    private Supplier<Calendar> calendarProvider = () -> Calendar.GREGORIAN;

    public LocalDateHeaderTemplate(String formatterPattern) {
        this.formatter = DateTimeFormatter.ofPattern(formatterPattern);
        this.exportFormatter = DateTimeFormatter.ofPattern(formatterPattern);
    }

    @Override
    public DateHeader getEmptyHeader() {
        return new DateHeader();
    }

    @Override
    public Object format(LocalDate value, MessageSource messageSource, Locale locale) {
        return this.getFormatter().withLocale(locale).format(value);
    }

    @Override
    public Object formatForExport(LocalDate value, MessageSource messageSource, Locale locale) {
        ChronoLocalDate accessor;
        Calendar calendar = this.calendarProvider.get();
        if (calendar == Calendar.GREGORIAN) {
            accessor = value;
        } else if (calendar == Calendar.JALALI) {
            accessor = LocalDateJalali.of((LocalDate)value);
        } else if (calendar == Calendar.ISLAMIC) {
            accessor = HijrahDate.from(value);
        } else {
            throw new IllegalStateException("unhandled calendar: " + String.valueOf(calendar));
        }
        return this.getFormatter().withLocale(locale).format(accessor);
    }

    @Generated
    public DateTimeFormatter getFormatter() {
        return this.formatter;
    }

    @Generated
    public DateTimeFormatter getExportFormatter() {
        return this.exportFormatter;
    }

    @Generated
    public Supplier<Calendar> getCalendarProvider() {
        return this.calendarProvider;
    }

    @Generated
    public void setExportFormatter(DateTimeFormatter exportFormatter) {
        this.exportFormatter = exportFormatter;
    }

    @Generated
    public void setCalendarProvider(Supplier<Calendar> calendarProvider) {
        this.calendarProvider = calendarProvider;
    }

    @Override
    @Generated
    public String toString() {
        return "LocalDateHeaderTemplate(formatter=" + String.valueOf(this.getFormatter()) + ", exportFormatter=" + String.valueOf(this.getExportFormatter()) + ", calendarProvider=" + String.valueOf(this.getCalendarProvider()) + ")";
    }
}

