/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.table.header;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.HijrahDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.function.Supplier;
import lombok.Generated;
import org.bardframework.commons.utils.DateTimeUtils;
import org.bardframework.commons.web.Calendar;
import org.bardframework.table.header.DateTimeHeader;
import org.bardframework.table.header.HeaderTemplate;
import org.bardframework.time.LocalDateTimeJalali;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;

public class EpochMillsDateTimeHeaderTemplate<M>
extends HeaderTemplate<M, DateTimeHeader, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EpochMillsDateTimeHeaderTemplate.class);
    private DateTimeFormatter exportFormatter;
    private Supplier<ZoneId> timeZoneProvider = ZoneId::systemDefault;
    private Supplier<Calendar> calendarProvider = () -> Calendar.GREGORIAN;

    public EpochMillsDateTimeHeaderTemplate(String exportFormatterPattern) {
        this(() -> exportFormatterPattern);
    }

    public EpochMillsDateTimeHeaderTemplate(Supplier<String> exportFormatterPatternSupplier) {
        this.exportFormatter = DateTimeFormatter.ofPattern(exportFormatterPatternSupplier.get());
    }

    public EpochMillsDateTimeHeaderTemplate(DateTimeFormatter exportFormatter) {
        this.exportFormatter = exportFormatter;
    }

    @Override
    public DateTimeHeader getEmptyHeader() {
        return new DateTimeHeader();
    }

    @Override
    public Object formatForExport(Long value, MessageSource messageSource, Locale locale) {
        Comparable<ChronoLocalDateTime<?>> accessor;
        LocalDateTime dateTime = DateTimeUtils.fromEpochMills((long)value, (ZoneId)this.timeZoneProvider.get());
        Calendar calendar = this.calendarProvider.get();
        if (calendar == Calendar.GREGORIAN) {
            accessor = dateTime;
        } else if (calendar == Calendar.JALALI) {
            accessor = LocalDateTimeJalali.of((LocalDateTime)dateTime);
        } else if (calendar == Calendar.ISLAMIC) {
            accessor = HijrahDate.from(dateTime);
        } else {
            throw new IllegalStateException("unhandled calendar: " + String.valueOf(calendar));
        }
        return this.getExportFormatter().withLocale(locale).format((TemporalAccessor)((Object)accessor));
    }

    @Generated
    public DateTimeFormatter getExportFormatter() {
        return this.exportFormatter;
    }

    @Generated
    public Supplier<ZoneId> getTimeZoneProvider() {
        return this.timeZoneProvider;
    }

    @Generated
    public Supplier<Calendar> getCalendarProvider() {
        return this.calendarProvider;
    }

    @Generated
    public void setExportFormatter(DateTimeFormatter exportFormatter) {
        this.exportFormatter = exportFormatter;
    }

    @Generated
    public void setTimeZoneProvider(Supplier<ZoneId> timeZoneProvider) {
        this.timeZoneProvider = timeZoneProvider;
    }

    @Generated
    public void setCalendarProvider(Supplier<Calendar> calendarProvider) {
        this.calendarProvider = calendarProvider;
    }

    @Override
    @Generated
    public String toString() {
        return "EpochMillsDateTimeHeaderTemplate(exportFormatter=" + String.valueOf(this.getExportFormatter()) + ", timeZoneProvider=" + String.valueOf(this.getTimeZoneProvider()) + ", calendarProvider=" + String.valueOf(this.getCalendarProvider()) + ")";
    }
}

