/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.table.header;

import java.time.LocalDateTime;
import java.time.chrono.HijrahDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.Locale;
import java.util.function.Supplier;
import lombok.Generated;
import org.bardframework.commons.web.Calendar;
import org.bardframework.table.header.DateTimeHeader;
import org.bardframework.table.header.HeaderTemplate;
import org.bardframework.time.LocalDateTimeJalali;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;

public class LocalDateTimeHeaderTemplate<M>
extends HeaderTemplate<M, DateTimeHeader, LocalDateTime> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalDateTimeHeaderTemplate.class);
    private final DateTimeFormatter formatter;
    private DateTimeFormatter exportFormatter;
    private Supplier<Calendar> calendarProvider = () -> Calendar.GREGORIAN;

    public LocalDateTimeHeaderTemplate(String formatterPattern) {
        this.formatter = DateTimeFormatter.ofPattern(formatterPattern);
        this.exportFormatter = DateTimeFormatter.ofPattern(formatterPattern);
    }

    @Override
    public DateTimeHeader getEmptyHeader() {
        return new DateTimeHeader();
    }

    @Override
    public Object format(LocalDateTime value, MessageSource messageSource, Locale locale) {
        return this.getFormatter().withLocale(locale).format(value);
    }

    @Override
    public Object formatForExport(LocalDateTime value, MessageSource messageSource, Locale locale) {
        LocalDateTime accessor;
        Calendar calendar = this.calendarProvider.get();
        if (calendar == Calendar.GREGORIAN) {
            accessor = value;
        } else if (calendar == Calendar.JALALI) {
            accessor = LocalDateTimeJalali.of((LocalDateTime)value);
        } else if (calendar == Calendar.ISLAMIC) {
            HijrahDate hijrahDate = HijrahDate.from(value);
            accessor = LocalDateTime.of(hijrahDate.get(ChronoField.YEAR), hijrahDate.get(ChronoField.MONTH_OF_YEAR), hijrahDate.get(ChronoField.DAY_OF_MONTH), value.getHour(), value.getMinute(), value.getSecond());
        } else {
            throw new IllegalStateException("unhandled calendar: " + String.valueOf(calendar));
        }
        return this.getFormatter().withLocale(locale).format(accessor);
    }

    @Generated
    public DateTimeFormatter getFormatter() {
        return this.formatter;
    }

    @Generated
    public DateTimeFormatter getExportFormatter() {
        return this.exportFormatter;
    }

    @Generated
    public Supplier<Calendar> getCalendarProvider() {
        return this.calendarProvider;
    }

    @Generated
    public void setExportFormatter(DateTimeFormatter exportFormatter) {
        this.exportFormatter = exportFormatter;
    }

    @Generated
    public void setCalendarProvider(Supplier<Calendar> calendarProvider) {
        this.calendarProvider = calendarProvider;
    }

    @Override
    @Generated
    public String toString() {
        return "LocalDateTimeHeaderTemplate(formatter=" + String.valueOf(this.getFormatter()) + ", exportFormatter=" + String.valueOf(this.getExportFormatter()) + ", calendarProvider=" + String.valueOf(this.getCalendarProvider()) + ")";
    }
}

