/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.table.header;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.function.Supplier;
import lombok.Generated;
import org.bardframework.table.header.HeaderTemplate;
import org.bardframework.table.header.TimeHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;

public class LocalTimeHeaderTemplate<M>
extends HeaderTemplate<M, TimeHeader, LocalTime> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalTimeHeaderTemplate.class);
    private final DateTimeFormatter formatter;

    public LocalTimeHeaderTemplate(String exportFormatterPattern) {
        this(() -> exportFormatterPattern);
    }

    public LocalTimeHeaderTemplate(Supplier<String> exportFormatterPatternSupplier) {
        this.formatter = DateTimeFormatter.ofPattern(exportFormatterPatternSupplier.get());
    }

    public LocalTimeHeaderTemplate(DateTimeFormatter exportFormatter) {
        this.formatter = exportFormatter;
    }

    @Override
    public TimeHeader getEmptyHeader() {
        return new TimeHeader();
    }

    @Override
    public Object format(LocalTime value, MessageSource messageSource, Locale locale) {
        return this.getFormatter().withLocale(locale).format(value);
    }

    @Generated
    public DateTimeFormatter getFormatter() {
        return this.formatter;
    }

    @Override
    @Generated
    public String toString() {
        return "LocalTimeHeaderTemplate(formatter=" + String.valueOf(this.getFormatter()) + ")";
    }
}

