/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.time;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class JalaliCalendar
extends Calendar {
    private static final int FARVARDIN = 0;
    private static final int ORDIBEHESHT = 1;
    private static final int KHORDAD = 2;
    private static final int TIR = 3;
    private static final int MORDAD = 4;
    private static final int SHAHRIVAR = 5;
    private static final int MEHR = 6;
    private static final int ABAN = 7;
    private static final int AZAR = 8;
    private static final int DEY = 9;
    private static final int BAHMAN = 10;
    private static final int ESFAND = 11;
    private static final int AD = 1;
    private static final int BCE = 0;
    private static final int CE = 1;
    private static final int ONE_SECOND = 1000;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final int[] MIN_VALUES = new int[]{0, 1, 0, 1, 0, 1, 1, 7, 1, 0, 0, 0, 0, 0, 0, -46800000, 0};
    private static final int[] LEAST_MAX_VALUES = new int[]{1, 292269054, 11, 52, 4, 28, 365, 6, 4, 1, 11, 23, 59, 59, 999, 50400000, 1200000};
    private static final int[] MAX_VALUES = new int[]{1, 292278994, 11, 53, 6, 31, 366, 6, 6, 1, 11, 23, 59, 59, 999, 50400000, 0x6DDD00};
    private static final int[] gregorianDaysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] jalaliDaysInMonth = new int[]{31, 31, 31, 31, 31, 31, 30, 30, 30, 30, 30, 29};
    private static TimeZone timeZone = TimeZone.getDefault();
    private static boolean isTimeSeted = false;
    private GregorianCalendar cal;

    public JalaliCalendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public JalaliCalendar(TimeZone zone) {
        this(zone, Locale.getDefault());
    }

    public JalaliCalendar(Locale aLocale) {
        this(TimeZone.getDefault(), aLocale);
    }

    public JalaliCalendar(TimeZone zone, Locale aLocale) {
        super(zone, aLocale);
        timeZone = zone;
        Calendar calendar = Calendar.getInstance(zone, aLocale);
        YearMonthDate yearMonthDate = new YearMonthDate(calendar.get(1), calendar.get(2), calendar.get(5));
        yearMonthDate = JalaliCalendar.gregorianToJalali(yearMonthDate);
        this.set(yearMonthDate.getYear(), yearMonthDate.getMonth(), yearMonthDate.getDate());
        this.complete();
    }

    public JalaliCalendar(int year, int month, int dayOfMonth) {
        this(year, month, dayOfMonth, 0, 0, 0, 0);
    }

    public JalaliCalendar(int year, int month, int dayOfMonth, int hourOfDay, int minute) {
        this(year, month, dayOfMonth, hourOfDay, minute, 0, 0);
    }

    public JalaliCalendar(int year, int month, int dayOfMonth, int hourOfDay, int minute, int second) {
        this(year, month, dayOfMonth, hourOfDay, minute, second, 0);
    }

    JalaliCalendar(int year, int month, int dayOfMonth, int hourOfDay, int minute, int second, int millis) {
        this.set(1, year);
        this.set(2, month);
        this.set(5, dayOfMonth);
        if (hourOfDay >= 12 && hourOfDay <= 23) {
            this.set(9, 1);
            this.set(10, hourOfDay - 12);
        } else {
            this.set(10, hourOfDay);
            this.set(9, 0);
        }
        this.set(11, hourOfDay);
        this.set(12, minute);
        this.set(13, second);
        this.set(14, millis);
        YearMonthDate yearMonthDate = JalaliCalendar.jalaliToGregorian(new YearMonthDate(this.fields[1], this.fields[2], this.fields[5]));
        this.cal = new GregorianCalendar(yearMonthDate.getYear(), yearMonthDate.getMonth(), yearMonthDate.getDate(), hourOfDay, minute, second);
        this.time = this.cal.getTimeInMillis();
        isTimeSeted = true;
    }

    public static YearMonthDate gregorianToJalali(YearMonthDate gregorian) {
        int i;
        if (gregorian.getMonth() > 11 || gregorian.getMonth() < -11) {
            throw new IllegalArgumentException();
        }
        gregorian.setYear(gregorian.getYear() - 1600);
        gregorian.setDate(gregorian.getDate() - 1);
        int gregorianDayNo = 365 * gregorian.getYear() + (int)Math.floor((gregorian.getYear() + 3) / 4) - (int)Math.floor((gregorian.getYear() + 99) / 100) + (int)Math.floor((gregorian.getYear() + 399) / 400);
        for (i = 0; i < gregorian.getMonth(); ++i) {
            gregorianDayNo += gregorianDaysInMonth[i];
        }
        if (gregorian.getMonth() > 1 && (gregorian.getYear() % 4 == 0 && gregorian.getYear() % 100 != 0 || gregorian.getYear() % 400 == 0)) {
            ++gregorianDayNo;
        }
        int jalaliDayNo = (gregorianDayNo += gregorian.getDate()) - 79;
        int jalaliNP = (int)Math.floor(jalaliDayNo / 12053);
        int jalaliYear = 979 + 33 * jalaliNP + 4 * (jalaliDayNo %= 12053) / 1461;
        if ((jalaliDayNo %= 1461) >= 366) {
            jalaliYear += (int)Math.floor((jalaliDayNo - 1) / 365);
            jalaliDayNo = (jalaliDayNo - 1) % 365;
        }
        for (i = 0; i < 11 && jalaliDayNo >= jalaliDaysInMonth[i]; jalaliDayNo -= jalaliDaysInMonth[i], ++i) {
        }
        int jalaliMonth = i;
        int jalaliDay = jalaliDayNo + 1;
        return new YearMonthDate(jalaliYear, jalaliMonth, jalaliDay);
    }

    public static YearMonthDate jalaliToGregorian(YearMonthDate jalali) {
        int i;
        if (jalali.getMonth() > 11 || jalali.getMonth() < -11) {
            throw new IllegalArgumentException();
        }
        jalali.setYear(jalali.getYear() - 979);
        jalali.setDate(jalali.getDate() - 1);
        int jalaliDayNo = 365 * jalali.getYear() + jalali.getYear() / 33 * 8 + (int)Math.floor((jalali.getYear() % 33 + 3) / 4);
        for (i = 0; i < jalali.getMonth(); ++i) {
            jalaliDayNo += jalaliDaysInMonth[i];
        }
        int gregorianDayNo = (jalaliDayNo += jalali.getDate()) + 79;
        int gregorianYear = 1600 + 400 * (int)Math.floor(gregorianDayNo / 146097);
        boolean leap = true;
        if ((gregorianDayNo %= 146097) >= 36525) {
            gregorianYear += 100 * (int)Math.floor(--gregorianDayNo / 36524);
            if ((gregorianDayNo %= 36524) >= 365) {
                ++gregorianDayNo;
            } else {
                leap = false;
            }
        }
        gregorianYear += 4 * (int)Math.floor(gregorianDayNo / 1461);
        if ((gregorianDayNo %= 1461) >= 366) {
            leap = false;
            gregorianYear = (int)((double)gregorianYear + Math.floor(--gregorianDayNo / 365));
            gregorianDayNo %= 365;
        }
        i = 0;
        while (gregorianDayNo >= gregorianDaysInMonth[i] + (i == 1 && leap ? i : 0)) {
            gregorianDayNo -= gregorianDaysInMonth[i] + (i == 1 && leap ? i : 0);
            ++i;
        }
        int gregorianMonth = i;
        int gregorianDay = gregorianDayNo + 1;
        return new YearMonthDate(gregorianYear, gregorianMonth, gregorianDay);
    }

    public static int weekOfYear(int dayOfYear, int year) {
        switch (JalaliCalendar.dayOfWeek(JalaliCalendar.jalaliToGregorian(new YearMonthDate(year, 0, 1)))) {
            case 2: {
                ++dayOfYear;
                break;
            }
            case 3: {
                dayOfYear += 2;
                break;
            }
            case 4: {
                dayOfYear += 3;
                break;
            }
            case 5: {
                dayOfYear += 4;
                break;
            }
            case 6: {
                dayOfYear += 5;
                break;
            }
            case 7: {
                --dayOfYear;
            }
        }
        dayOfYear = (int)Math.floor(dayOfYear / 7);
        return dayOfYear + 1;
    }

    public static int dayOfWeek(YearMonthDate yearMonthDate) {
        GregorianCalendar cal = new GregorianCalendar(yearMonthDate.getYear(), yearMonthDate.getMonth(), yearMonthDate.getDate());
        return cal.get(7);
    }

    public static boolean isLeepYear(int year) {
        return year % 33 == 1 || year % 33 == 5 || year % 33 == 9 || year % 33 == 13 || year % 33 == 17 || year % 33 == 22 || year % 33 == 26 || year % 33 == 30;
    }

    @Override
    protected void computeTime() {
        if (!this.isTimeSet && !isTimeSeted) {
            Calendar cal = GregorianCalendar.getInstance(timeZone);
            if (!this.isSet(11)) {
                super.set(11, cal.get(11));
            }
            if (!this.isSet(10)) {
                super.set(10, cal.get(10));
            }
            if (!this.isSet(12)) {
                super.set(12, cal.get(12));
            }
            if (!this.isSet(13)) {
                super.set(13, cal.get(13));
            }
            if (!this.isSet(14)) {
                super.set(14, cal.get(14));
            }
            if (!this.isSet(15)) {
                super.set(15, cal.get(15));
            }
            if (!this.isSet(16)) {
                super.set(16, cal.get(16));
            }
            if (!this.isSet(9)) {
                super.set(9, cal.get(9));
            }
            if (this.internalGet(11) >= 12 && this.internalGet(11) <= 23) {
                super.set(9, 1);
                super.set(10, this.internalGet(11) - 12);
            } else {
                super.set(10, this.internalGet(11));
                super.set(9, 0);
            }
            YearMonthDate yearMonthDate = JalaliCalendar.jalaliToGregorian(new YearMonthDate(this.internalGet(1), this.internalGet(2), this.internalGet(5)));
            cal.set(yearMonthDate.getYear(), yearMonthDate.getMonth(), yearMonthDate.getDate(), this.internalGet(11), this.internalGet(12), this.internalGet(13));
            this.time = cal.getTimeInMillis();
        } else if (!this.isTimeSet && isTimeSeted) {
            if (this.internalGet(11) >= 12 && this.internalGet(11) <= 23) {
                super.set(9, 1);
                super.set(10, this.internalGet(11) - 12);
            } else {
                super.set(10, this.internalGet(11));
                super.set(9, 0);
            }
            this.cal = new GregorianCalendar();
            super.set(15, timeZone.getRawOffset());
            super.set(16, timeZone.getDSTSavings());
            YearMonthDate yearMonthDate = JalaliCalendar.jalaliToGregorian(new YearMonthDate(this.internalGet(1), this.internalGet(2), this.internalGet(5)));
            this.cal.set(yearMonthDate.getYear(), yearMonthDate.getMonth(), yearMonthDate.getDate(), this.internalGet(11), this.internalGet(12), this.internalGet(13));
            this.time = this.cal.getTimeInMillis();
        }
    }

    @Override
    public void set(int field, int value) {
        switch (field) {
            case 5: {
                super.set(field, 0);
                this.add(field, value);
                break;
            }
            case 2: {
                if (value > 11) {
                    super.set(field, 11);
                    this.add(field, value - 11);
                    break;
                }
                if (value < 0) {
                    super.set(field, 0);
                    this.add(field, value);
                    break;
                }
                super.set(field, value);
                break;
            }
            case 6: {
                if (this.isSet(1) && this.isSet(2) && this.isSet(5)) {
                    super.set(1, this.internalGet(1));
                    super.set(2, 0);
                    super.set(5, 0);
                    this.add(field, value);
                    break;
                }
                super.set(field, value);
                break;
            }
            case 3: {
                if (this.isSet(1) && this.isSet(2) && this.isSet(5)) {
                    this.add(field, value - this.get(3));
                    break;
                }
                super.set(field, value);
                break;
            }
            case 4: {
                if (this.isSet(1) && this.isSet(2) && this.isSet(5)) {
                    this.add(field, value - this.get(4));
                    break;
                }
                super.set(field, value);
                break;
            }
            case 7: {
                if (this.isSet(1) && this.isSet(2) && this.isSet(5)) {
                    this.add(7, value % 7 - this.get(7));
                    break;
                }
                super.set(field, value);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                if (this.isSet(1) && this.isSet(2) && this.isSet(5) && this.isSet(10) && this.isSet(11) && this.isSet(12) && this.isSet(13) && this.isSet(14)) {
                    this.cal = new GregorianCalendar();
                    YearMonthDate yearMonthDate = JalaliCalendar.jalaliToGregorian(new YearMonthDate(this.internalGet(1), this.internalGet(2), this.internalGet(5)));
                    this.cal.set(yearMonthDate.getYear(), yearMonthDate.getMonth(), yearMonthDate.getDate(), this.internalGet(11), this.internalGet(12), this.internalGet(13));
                    this.cal.set(field, value);
                    yearMonthDate = JalaliCalendar.gregorianToJalali(new YearMonthDate(this.cal.get(1), this.cal.get(2), this.cal.get(5)));
                    super.set(1, yearMonthDate.getYear());
                    super.set(2, yearMonthDate.getMonth());
                    super.set(5, yearMonthDate.getDate());
                    super.set(11, this.cal.get(11));
                    super.set(12, this.cal.get(12));
                    super.set(13, this.cal.get(13));
                    break;
                }
                super.set(field, value);
                break;
            }
            default: {
                super.set(field, value);
            }
        }
    }

    @Override
    protected void computeFields() {
        boolean temp = this.isTimeSet;
        if (!this.areFieldsSet) {
            this.setMinimalDaysInFirstWeek(1);
            this.setFirstDayOfWeek(7);
            int dayOfYear = 0;
            int index = 0;
            while (index < this.fields[2]) {
                dayOfYear += jalaliDaysInMonth[index++];
            }
            super.set(6, dayOfYear += this.fields[5]);
            super.set(7, JalaliCalendar.dayOfWeek(JalaliCalendar.jalaliToGregorian(new YearMonthDate(this.fields[1], this.fields[2], this.fields[5]))));
            if (0 < this.fields[5] && this.fields[5] < 8) {
                super.set(8, 1);
            }
            if (7 < this.fields[5] && this.fields[5] < 15) {
                super.set(8, 2);
            }
            if (14 < this.fields[5] && this.fields[5] < 22) {
                super.set(8, 3);
            }
            if (21 < this.fields[5] && this.fields[5] < 29) {
                super.set(8, 4);
            }
            if (28 < this.fields[5] && this.fields[5] < 32) {
                super.set(8, 5);
            }
            super.set(3, JalaliCalendar.weekOfYear(this.fields[6], this.fields[1]));
            super.set(4, JalaliCalendar.weekOfYear(this.fields[6], this.fields[1]) - JalaliCalendar.weekOfYear(this.fields[6] - this.fields[5], this.fields[1]) + 1);
            this.isTimeSet = temp;
        }
    }

    @Override
    public void add(int field, int amount) {
        if (field == 2) {
            this.add(1, (amount += this.get(2)) / 12);
            super.set(2, amount % 12);
            if (this.get(5) > jalaliDaysInMonth[amount % 12]) {
                super.set(5, jalaliDaysInMonth[amount % 12]);
                if (this.get(2) == 11 && JalaliCalendar.isLeepYear(this.get(1))) {
                    super.set(5, 30);
                }
            }
            this.complete();
        } else if (field == 1) {
            super.set(1, this.get(1) + amount);
            if (this.get(5) == 30 && this.get(2) == 11 && !JalaliCalendar.isLeepYear(this.get(1))) {
                super.set(5, 29);
            }
            this.complete();
        } else {
            YearMonthDate yearMonthDate = JalaliCalendar.jalaliToGregorian(new YearMonthDate(this.get(1), this.get(2), this.get(5)));
            GregorianCalendar gc = new GregorianCalendar(yearMonthDate.getYear(), yearMonthDate.getMonth(), yearMonthDate.getDate(), this.get(11), this.get(12), this.get(13));
            ((Calendar)gc).add(field, amount);
            yearMonthDate = JalaliCalendar.gregorianToJalali(new YearMonthDate(gc.get(1), gc.get(2), gc.get(5)));
            super.set(1, yearMonthDate.getYear());
            super.set(2, yearMonthDate.getMonth());
            super.set(5, yearMonthDate.getDate());
            super.set(11, gc.get(11));
            super.set(12, gc.get(12));
            super.set(13, gc.get(13));
            this.complete();
        }
    }

    @Override
    public void roll(int field, boolean up) {
        this.roll(field, up ? 1 : -1);
    }

    @Override
    public void roll(int field, int amount) {
        if (amount == 0) {
            return;
        }
        if (field < 0 || field >= 15) {
            throw new IllegalArgumentException();
        }
        this.complete();
        switch (field) {
            case 9: {
                if (amount % 2 == 0) break;
                this.fields[9] = this.internalGet(9) == 0 ? 1 : 0;
                if (this.get(9) == 0) {
                    super.set(11, this.get(10));
                    break;
                }
                super.set(11, this.get(10) + 12);
                break;
            }
            case 1: {
                super.set(1, this.internalGet(1) + amount);
                if (this.internalGet(2) != 11 || this.internalGet(5) != 30 || JalaliCalendar.isLeepYear(this.internalGet(1))) break;
                super.set(5, 29);
                break;
            }
            case 12: {
                int unit = 60;
                int m = (this.internalGet(12) + amount) % unit;
                if (m < 0) {
                    m += unit;
                }
                super.set(12, m);
                break;
            }
            case 13: {
                int unit = 60;
                int s = (this.internalGet(13) + amount) % unit;
                if (s < 0) {
                    s += unit;
                }
                super.set(13, s);
                break;
            }
            case 14: {
                int unit = 1000;
                int ms = (this.internalGet(14) + amount) % unit;
                if (ms < 0) {
                    ms += unit;
                }
                super.set(14, ms);
                break;
            }
            case 10: {
                super.set(10, (this.internalGet(10) + amount) % 12);
                if (this.internalGet(10) < 0) {
                    this.fields[10] = this.fields[10] + 12;
                }
                if (this.internalGet(9) == 0) {
                    super.set(11, this.internalGet(10));
                    break;
                }
                super.set(11, this.internalGet(10) + 12);
                break;
            }
            case 11: {
                this.fields[11] = (this.internalGet(11) + amount) % 24;
                if (this.internalGet(11) < 0) {
                    this.fields[11] = this.fields[11] + 24;
                }
                if (this.internalGet(11) < 12) {
                    this.fields[9] = 0;
                    this.fields[10] = this.internalGet(11);
                } else {
                    this.fields[9] = 1;
                    this.fields[10] = this.internalGet(11) - 12;
                }
            }
            case 2: {
                int mon = (this.internalGet(2) + amount) % 12;
                if (mon < 0) {
                    mon += 12;
                }
                super.set(2, mon);
                int monthLen = jalaliDaysInMonth[mon];
                if (this.internalGet(2) == 11 && JalaliCalendar.isLeepYear(this.internalGet(1))) {
                    monthLen = 30;
                }
                if (this.internalGet(5) <= monthLen) break;
                super.set(5, monthLen);
                break;
            }
            case 5: {
                int d;
                int unit = 0;
                if (0 <= this.get(2) && this.get(2) <= 5) {
                    unit = 31;
                }
                if (6 <= this.get(2) && this.get(2) <= 10) {
                    unit = 30;
                }
                if (this.get(2) == 11) {
                    unit = JalaliCalendar.isLeepYear(this.get(1)) ? 30 : 29;
                }
                if ((d = (this.get(5) + amount) % unit) < 0) {
                    d += unit;
                }
                super.set(5, d);
                break;
            }
            case 3: {
                break;
            }
            case 6: {
                int temp;
                int unit = JalaliCalendar.isLeepYear(this.internalGet(1)) ? 366 : 365;
                int dayOfYear = (this.internalGet(6) + amount) % unit;
                dayOfYear = dayOfYear > 0 ? dayOfYear : dayOfYear + unit;
                int month = 0;
                for (temp = 0; dayOfYear > temp; temp += jalaliDaysInMonth[month++]) {
                }
                super.set(2, --month);
                super.set(5, jalaliDaysInMonth[this.internalGet(2)] - (temp - dayOfYear));
                break;
            }
            case 7: {
                int index = amount % 7;
                if (index < 0) {
                    index += 7;
                }
                for (int i = 0; i != index; ++i) {
                    if (this.internalGet(7) == 6) {
                        this.add(5, -6);
                        continue;
                    }
                    this.add(5, 1);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public int getMinimum(int field) {
        return MIN_VALUES[field];
    }

    @Override
    public int getMaximum(int field) {
        return MAX_VALUES[field];
    }

    @Override
    public int getGreatestMinimum(int field) {
        return MIN_VALUES[field];
    }

    @Override
    public int getLeastMaximum(int field) {
        return LEAST_MAX_VALUES[field];
    }

    public static class YearMonthDate {
        private int year;
        private int month;
        private int date;

        public YearMonthDate(int year, int month, int date) {
            this.year = year;
            this.month = month;
            this.date = date;
        }

        public int getYear() {
            return this.year;
        }

        public void setYear(int year) {
            this.year = year;
        }

        public int getMonth() {
            return this.month;
        }

        public void setMonth(int month) {
            this.month = month;
        }

        public int getDate() {
            return this.date;
        }

        public void setDate(int date) {
            this.date = date;
        }

        public String toString() {
            return this.getYear() + "/" + this.getMonth() + "/" + this.getDate();
        }
    }
}

