/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.AbstractChronology;
import java.time.chrono.Era;
import java.time.chrono.IsoEra;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.ValueRange;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bardframework.time.JalaliDate;
import org.bardframework.time.JalaliDateTime;
import org.bardframework.time.JalaliYear;

public final class JalaliChronology
extends AbstractChronology
implements Serializable {
    public static final JalaliChronology INSTANCE = new JalaliChronology();
    private static final long serialVersionUID = -1440403870442975015L;

    private JalaliChronology() {
    }

    @Override
    public String getId() {
        return "JALALI";
    }

    @Override
    public String getCalendarType() {
        return "jalali";
    }

    @Override
    public JalaliDate date(Era era, int yearOfEra, int month, int dayOfMonth) throws DateTimeException {
        return this.date(this.prolepticYear(era, yearOfEra), month, dayOfMonth);
    }

    @Override
    public JalaliDate date(int prolepticYear, int month, int dayOfMonth) {
        return JalaliDate.of(prolepticYear, month, dayOfMonth);
    }

    @Override
    public JalaliDate dateYearDay(Era era, int yearOfEra, int dayOfYear) {
        return this.dateYearDay(this.prolepticYear(era, yearOfEra), dayOfYear);
    }

    @Override
    public JalaliDate dateYearDay(int prolepticYear, int dayOfYear) {
        return JalaliDate.ofYearDay(prolepticYear, dayOfYear);
    }

    @Override
    public JalaliDate dateEpochDay(long epochDay) {
        return JalaliDate.ofEpochDay(epochDay);
    }

    @Override
    public JalaliDate date(TemporalAccessor temporal) {
        return JalaliDate.from(temporal);
    }

    public JalaliDateTime localDateTime(TemporalAccessor temporal) {
        return JalaliDateTime.from(temporal);
    }

    public ZonedDateTime zonedDateTime(TemporalAccessor temporal) throws DateTimeException {
        return ZonedDateTime.from(temporal);
    }

    public ZonedDateTime zonedDateTime(Instant instant, ZoneId zone) {
        return ZonedDateTime.ofInstant(instant, zone);
    }

    @Override
    public JalaliDate dateNow() {
        return this.dateNow(Clock.systemDefaultZone());
    }

    @Override
    public JalaliDate dateNow(ZoneId zone) {
        return this.dateNow(Clock.system(zone));
    }

    @Override
    public JalaliDate dateNow(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        return this.date(JalaliDate.now(clock));
    }

    @Override
    public boolean isLeapYear(long prolepticYear) {
        return JalaliYear.isLeap(prolepticYear);
    }

    @Override
    public int prolepticYear(Era era, int yearOfEra) {
        if (!(era instanceof IsoEra)) {
            throw new ClassCastException("Era must be IsoEra");
        }
        return era == IsoEra.CE ? yearOfEra : 1 - yearOfEra;
    }

    @Override
    public IsoEra eraOf(int eraValue) {
        return IsoEra.of(eraValue);
    }

    @Override
    public List<Era> eras() {
        return Arrays.asList(IsoEra.values());
    }

    @Override
    public JalaliDate resolveDate(Map<TemporalField, Long> fieldValues, ResolverStyle resolverStyle) {
        return (JalaliDate)super.resolveDate(fieldValues, resolverStyle);
    }

    @Override
    public ValueRange range(ChronoField field) {
        return field.range();
    }

    @Override
    public Period period(int years, int months, int days) {
        return Period.of(years, months, days);
    }
}

