/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Era;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.bardframework.time.JalaliChronology;
import org.bardframework.time.JalaliDateTime;
import org.bardframework.time.JalaliMonth;
import org.bardframework.time.JalaliYear;

public final class JalaliDate
implements ChronoLocalDate,
Serializable {
    public static final JalaliDate MIN = JalaliDate.of(-999999999, 1, 1);
    public static final JalaliDate MAX = JalaliDate.of(999999999, 12, 30);
    public static final JalaliDate LOCAL_1970_01_01 = JalaliDate.of(1348, 10, 11);
    public static final int DAYS_LEFT_IN_1970_01_01 = 492634;
    public static final LocalDate JALALI_0001_01_01 = LocalDate.of(622, Month.MARCH, 22);
    static final int HOURS_PER_DAY = 24;
    static final int MINUTES_PER_HOUR = 60;
    static final int MINUTES_PER_DAY = 1440;
    static final int SECONDS_PER_MINUTE = 60;
    static final int SECONDS_PER_HOUR = 3600;
    static final long SECONDS_PER_DAY = 86400L;
    static final long MILLIS_PER_DAY = 86400000L;
    static final long MICROS_PER_DAY = 86400000000L;
    static final long NANOS_PER_SECOND = 1000000000L;
    static final long NANOS_PER_MINUTE = 60000000000L;
    static final long NANOS_PER_HOUR = 3600000000000L;
    static final long NANOS_PER_DAY = 86400000000000L;
    static final TemporalQuery<JalaliDate> LOCAL_DATE = temporal -> {
        if (temporal.isSupported(ChronoField.EPOCH_DAY)) {
            return JalaliDate.ofEpochDay(temporal.getLong(ChronoField.EPOCH_DAY));
        }
        return null;
    };
    private static final int DAYS_PER_CYCLE = 146097;
    static final long DAYS_0000_TO_1970 = 719528L;
    private static final long serialVersionUID = 2942565459149668126L;
    private static final List<Integer> _10 = Arrays.asList(1804, 1808, 1812, 1816, 1820, 1824, 1828, 1903, 1904, 1907, 1908, 1911, 1912, 1915, 1916, 1919, 1920, 1923, 1924, 1927, 1928, 1932, 1936, 1940, 1944, 1948, 1952, 1956, 1960);
    private static final List<Integer> _12 = Arrays.asList(1733, 1737, 1741, 1745, 1749, 1753, 1757, 1761, 1765, 1766, 1769, 1770, 1773, 1774, 1777, 1778, 1781, 1782, 1785, 1786, 1789, 1790, 1793, 1794, 1797, 1798, 1865, 1869, 1873, 1877, 1881, 1885, 1889, 1893, 1897, 1898, 1997, 2001, 2005, 2009, 2013, 2017, 2021, 2025, 2029, 2030, 2033, 2034, 2037, 2038, 2041, 2042, 2045, 2046, 2049, 2050, 2053, 2054, 2057, 2058, 2061, 2062, 2063, 2065, 2066, 2067, 2069, 2070, 2071, 2073, 2074, 2075, 2077, 2078, 2079, 2081, 2082, 2083, 2085, 2086, 2087, 2089, 2090, 2091, 2093, 2094, 2095, 2096, 2097, 2098, 2099, 2100);
    private static final int[] jalaliDaysInMonth = new int[]{31, 31, 31, 31, 31, 31, 30, 30, 30, 30, 30, 29};
    private static final int[] gregorianDaysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private final int year;
    private final short month;
    private final short day;

    private JalaliDate(int year, int month, int dayOfMonth) {
        this.year = year;
        this.month = (short)month;
        this.day = (short)dayOfMonth;
    }

    public static JalaliDate now() {
        return JalaliDate.now(Clock.systemDefaultZone());
    }

    public static JalaliDate now(ZoneId zone) {
        return JalaliDate.now(Clock.system(zone));
    }

    public static JalaliDate now(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        Instant now = clock.instant();
        ZoneOffset offset = clock.getZone().getRules().getOffset(now);
        long epochSec = now.getEpochSecond() + (long)offset.getTotalSeconds();
        long epochDay = Math.floorDiv(epochSec, 86400L);
        return JalaliDate.ofEpochDay(epochDay);
    }

    public static JalaliDate of(int year, JalaliMonth month, int dayOfMonth) {
        ChronoField.YEAR.checkValidValue(year);
        Objects.requireNonNull(month, "month");
        ChronoField.DAY_OF_MONTH.checkValidValue(dayOfMonth);
        return JalaliDate.create(year, month.getValue(), dayOfMonth);
    }

    public static JalaliDate of(int year, int month, int dayOfMonth) {
        ChronoField.YEAR.checkValidValue(year);
        ChronoField.MONTH_OF_YEAR.checkValidValue(month);
        ChronoField.DAY_OF_MONTH.checkValidValue(dayOfMonth);
        return JalaliDate.create(year, month, dayOfMonth);
    }

    public static JalaliDate of(String jalaliDate) {
        if (null == jalaliDate) {
            throw new IllegalArgumentException("invalid date: " + jalaliDate);
        }
        String digit = jalaliDate.replaceAll("[^\\d]", "");
        if (8 != digit.length()) {
            throw new IllegalArgumentException("cant obtain date value from: " + jalaliDate);
        }
        return JalaliDate.of(Integer.parseInt(digit.substring(0, 4)), Integer.parseInt(digit.substring(4, 6)), Integer.parseInt(digit.substring(6, 8)));
    }

    public static JalaliDate ofYearDay(int year, int dayOfYear) {
        ChronoField.YEAR.checkValidValue(year);
        ChronoField.DAY_OF_YEAR.checkValidValue(dayOfYear);
        boolean leap = JalaliChronology.INSTANCE.isLeapYear(year);
        if (dayOfYear == 366 && !leap) {
            throw new DateTimeException("Invalid date 'DayOfYear 366' as '" + year + "' is not a leap year");
        }
        JalaliMonth moy = JalaliMonth.of((dayOfYear - 1) / 31 + 1);
        int monthEnd = moy.firstDayOfYear(leap) + moy.length(leap) - 1;
        if (dayOfYear > monthEnd) {
            moy = moy.plus(1L);
        }
        int dom = dayOfYear - moy.firstDayOfYear(leap) + 1;
        return new JalaliDate(year, moy.getValue(), dom);
    }

    public static JalaliDate of(LocalDate localDate) {
        return JalaliDate.getFirstDayOfGregorianYearInJalaliDate(localDate.getYear()).plusDays(localDate.getDayOfYear() - 1);
    }

    static JalaliDate ofEpochDay(long epochDay) {
        JalaliYear year = JalaliYear.of(LOCAL_1970_01_01.getYear());
        JalaliMonth month = LOCAL_1970_01_01.getMonth();
        short day = JalaliDate.LOCAL_1970_01_01.day;
        if (epochDay < 0L) {
            LOCAL_1970_01_01.minusDays(10L);
            JalaliYear previousYear = year.minusYears(1L);
            for (epochDay = Math.abs(epochDay); epochDay >= (long)previousYear.length(); epochDay -= (long)previousYear.length()) {
                year = previousYear;
                previousYear = year.minusYears(1L);
            }
            JalaliMonth previousMonth = month.minus(1L);
            while (epochDay >= (long)previousMonth.length(year.isLeap())) {
                epochDay -= (long)previousMonth.length(year.isLeap());
                month = previousMonth;
                if (JalaliMonth.ESFAND == month) {
                    year = year.minusYears(1L);
                }
                previousMonth = month.minus(1L);
            }
            if ((day = (short)((long)day - epochDay)) < 0) {
                month = month.minus(1L);
                day = (short)(day + month.length(year.isLeap()));
                if (JalaliMonth.ESFAND == month) {
                    year = year.minusYears(1L);
                }
            }
        } else {
            while (epochDay >= (long)year.length()) {
                epochDay -= (long)year.length();
                year = year.plusYears(1L);
            }
            while (epochDay >= (long)month.length(year.isLeap())) {
                epochDay -= (long)month.length(year.isLeap());
                if (JalaliMonth.FARVARDIN != (month = month.plus(1L))) continue;
                year = year.plusYears(1L);
            }
            if ((day = (short)((long)day + epochDay)) > month.length(year.isLeap())) {
                day = (short)(day - month.length(year.isLeap()));
                if (JalaliMonth.FARVARDIN == (month = month.plus(1L))) {
                    year = year.plusYears(1L);
                }
            }
        }
        return JalaliDate.of(year.getValue(), month, (int)day);
    }

    private static JalaliDate getFirstDayOfGregorianYearInJalaliDate(int gregorianYear) {
        int day = _10.contains(gregorianYear) ? 10 : (_12.contains(gregorianYear) ? 12 : 11);
        return JalaliDate.of(gregorianYear - 622, 10, day);
    }

    public static JalaliDate from(TemporalAccessor temporal) {
        Objects.requireNonNull(temporal, "temporal");
        JalaliDate date = temporal.query(LOCAL_DATE);
        if (date == null) {
            throw new DateTimeException("Unable to obtain JalaliDate from TemporalAccessor: " + temporal + " of type " + temporal.getClass().getName());
        }
        return date;
    }

    public static JalaliDate parse(CharSequence text) {
        return JalaliDate.parse(text, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static JalaliDate parse(CharSequence text, DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.parse(text, JalaliDate::from);
    }

    private static JalaliDate create(int year, int month, int dayOfMonth) {
        if (dayOfMonth > 29) {
            int dom = 31;
            switch (month) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    dom = 30;
                    break;
                }
                case 12: {
                    int n = dom = JalaliYear.isLeap(year) ? 30 : 29;
                }
            }
            if (dayOfMonth > dom) {
                if (12 == month) {
                    throw new DateTimeException("Invalid date '30 Esfand' as '" + year + "' is not a leap year");
                }
                throw new DateTimeException("Invalid date '" + JalaliMonth.of(month).name() + " " + dayOfMonth + "'");
            }
        }
        return new JalaliDate(year, month, dayOfMonth);
    }

    private static JalaliDate resolvePreviousValid(int year, int month, int day) {
        switch (month) {
            case 12: {
                day = Math.min(day, JalaliChronology.INSTANCE.isLeapYear(year) ? 30 : 29);
            }
        }
        return new JalaliDate(year, month, day);
    }

    public LocalDate toLocalDate() {
        int gregorianYear = this.getYear() + 622;
        LocalDate firstDayOfGregorianYearInGregorian = LocalDate.of(gregorianYear, 1, 1);
        JalaliDate firstDayOfGregorianYearInJalali = JalaliDate.getFirstDayOfGregorianYearInJalaliDate(gregorianYear);
        int dif = this.getPositiveDistance(firstDayOfGregorianYearInJalali);
        return this.isBefore(firstDayOfGregorianYearInJalali) ? firstDayOfGregorianYearInGregorian.minusDays(dif) : firstDayOfGregorianYearInGregorian.plusDays(dif);
    }

    public int getPositiveDistance(JalaliDate other) {
        if (other == null) {
            return 0;
        }
        if (this.isAfter(other)) {
            return other.getPositiveDistance(this);
        }
        if (this.getYear() == other.getYear()) {
            return other.getDayOfYear() - this.getDayOfYear();
        }
        if (this.getYear() + 1 == other.getYear()) {
            return this.getRemainDayOfYear() + other.getDayOfYear();
        }
        int current = this.getYear();
        int diff = this.getRemainDayOfYear() + other.getDayOfYear();
        while (current + 1 != other.getYear()) {
            diff += JalaliYear.of(current).length();
            ++current;
        }
        return diff;
    }

    public int getRemainDayOfYear() {
        return (this.isLeapYear() ? 366 : 365) - this.getDayOfYear();
    }

    @Override
    public boolean isSupported(TemporalField field) {
        return ChronoLocalDate.super.isSupported(field);
    }

    @Override
    public boolean isSupported(TemporalUnit unit) {
        return ChronoLocalDate.super.isSupported(unit);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            if (f.isDateBased()) {
                switch (f) {
                    case DAY_OF_MONTH: {
                        return ValueRange.of(1L, this.lengthOfMonth());
                    }
                    case DAY_OF_YEAR: {
                        return ValueRange.of(1L, this.lengthOfYear());
                    }
                    case ALIGNED_WEEK_OF_MONTH: {
                        return ValueRange.of(1L, this.getMonth() == JalaliMonth.ESFAND && !this.isLeapYear() ? 4L : 5L);
                    }
                    case YEAR_OF_ERA: {
                        return this.getYear() <= 0 ? ValueRange.of(1L, 1000000000L) : ValueRange.of(1L, 999999999L);
                    }
                }
                return field.range();
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField field) {
        if (field instanceof ChronoField) {
            return this.get0(field);
        }
        return ChronoLocalDate.super.get(field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            if (field == ChronoField.EPOCH_DAY) {
                return this.toEpochDay();
            }
            if (field == ChronoField.PROLEPTIC_MONTH) {
                return this.getProlepticMonth();
            }
            return this.get0(field);
        }
        return field.getFrom(this);
    }

    private int get0(TemporalField field) {
        switch ((ChronoField)field) {
            case DAY_OF_WEEK: {
                return this.getDayOfWeek().getValue();
            }
            case ALIGNED_DAY_OF_WEEK_IN_MONTH: {
                return (this.day - 1) % 7 + 1;
            }
            case ALIGNED_DAY_OF_WEEK_IN_YEAR: {
                return (this.getDayOfYear() - 1) % 7 + 1;
            }
            case DAY_OF_MONTH: {
                return this.day;
            }
            case DAY_OF_YEAR: {
                return this.getDayOfYear();
            }
            case EPOCH_DAY: {
                throw new UnsupportedTemporalTypeException("Invalid field 'EpochDay' for get() method, use getLong() instead");
            }
            case ALIGNED_WEEK_OF_MONTH: {
                return (this.day - 1) / 7 + 1;
            }
            case ALIGNED_WEEK_OF_YEAR: {
                return (this.getDayOfYear() - 1) / 7 + 1;
            }
            case MONTH_OF_YEAR: {
                return this.month;
            }
            case PROLEPTIC_MONTH: {
                throw new UnsupportedTemporalTypeException("Invalid field 'ProlepticMonth' for get() method, use getLong() instead");
            }
            case YEAR_OF_ERA: {
                return this.year >= 1 ? this.year : 1 - this.year;
            }
            case YEAR: {
                return this.year;
            }
            case ERA: {
                return this.year >= 1 ? 1 : 0;
            }
        }
        throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
    }

    private long getProlepticMonth() {
        return (long)this.year * 12L + (long)this.month - 1L;
    }

    @Override
    public JalaliChronology getChronology() {
        return JalaliChronology.INSTANCE;
    }

    @Override
    public Era getEra() {
        return ChronoLocalDate.super.getEra();
    }

    public int getYear() {
        return this.year;
    }

    public int getMonthValue() {
        return this.month;
    }

    public JalaliMonth getMonth() {
        return JalaliMonth.of(this.month);
    }

    public int getDayOfMonth() {
        return this.day;
    }

    public int getDayOfYear() {
        return this.getMonth().firstDayOfYear(this.isLeapYear()) + this.day - 1;
    }

    public DayOfWeek getDayOfWeek() {
        int dow0 = (int)Math.floorMod(this.toEpochDay() + 3L, 7L);
        return DayOfWeek.of(dow0 + 1);
    }

    @Override
    public boolean isLeapYear() {
        return JalaliChronology.INSTANCE.isLeapYear(this.year);
    }

    @Override
    public int lengthOfMonth() {
        switch (this.month) {
            case 2: {
                return this.isLeapYear() ? 29 : 28;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        return 31;
    }

    @Override
    public int lengthOfYear() {
        return this.isLeapYear() ? 366 : 365;
    }

    @Override
    public JalaliDate with(TemporalAdjuster adjuster) {
        if (adjuster instanceof JalaliDate) {
            return (JalaliDate)adjuster;
        }
        return (JalaliDate)adjuster.adjustInto(this);
    }

    @Override
    public JalaliDate with(TemporalField field, long newValue) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            f.checkValidValue(newValue);
            switch (f) {
                case DAY_OF_WEEK: {
                    return this.plusDays(newValue - (long)this.getDayOfWeek().getValue());
                }
                case ALIGNED_DAY_OF_WEEK_IN_MONTH: {
                    return this.plusDays(newValue - this.getLong(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH));
                }
                case ALIGNED_DAY_OF_WEEK_IN_YEAR: {
                    return this.plusDays(newValue - this.getLong(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR));
                }
                case DAY_OF_MONTH: {
                    return this.withDayOfMonth((int)newValue);
                }
                case DAY_OF_YEAR: {
                    return this.withDayOfYear((int)newValue);
                }
                case EPOCH_DAY: {
                    return JalaliDate.ofEpochDay(newValue);
                }
                case ALIGNED_WEEK_OF_MONTH: {
                    return this.plusWeeks(newValue - this.getLong(ChronoField.ALIGNED_WEEK_OF_MONTH));
                }
                case ALIGNED_WEEK_OF_YEAR: {
                    return this.plusWeeks(newValue - this.getLong(ChronoField.ALIGNED_WEEK_OF_YEAR));
                }
                case MONTH_OF_YEAR: {
                    return this.withMonth((int)newValue);
                }
                case PROLEPTIC_MONTH: {
                    return this.plusMonths(newValue - this.getProlepticMonth());
                }
                case YEAR_OF_ERA: {
                    return this.withYear((int)(this.year >= 1 ? newValue : 1L - newValue));
                }
                case YEAR: {
                    return this.withYear((int)newValue);
                }
                case ERA: {
                    return this.getLong(ChronoField.ERA) == newValue ? this : this.withYear(1 - this.year);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return field.adjustInto(this, newValue);
    }

    public JalaliDate withYear(int year) {
        if (this.year == year) {
            return this;
        }
        ChronoField.YEAR.checkValidValue(year);
        return JalaliDate.resolvePreviousValid(year, this.month, this.day);
    }

    public JalaliDate withMonth(int month) {
        if (this.month == month) {
            return this;
        }
        ChronoField.MONTH_OF_YEAR.checkValidValue(month);
        return JalaliDate.resolvePreviousValid(this.year, month, this.day);
    }

    public JalaliDate withDayOfMonth(int dayOfMonth) {
        if (this.day == dayOfMonth) {
            return this;
        }
        return JalaliDate.of(this.year, this.month, dayOfMonth);
    }

    public JalaliDate withDayOfYear(int dayOfYear) {
        if (this.getDayOfYear() == dayOfYear) {
            return this;
        }
        return JalaliDate.ofYearDay(this.year, dayOfYear);
    }

    @Override
    public JalaliDate plus(TemporalAmount amountToAdd) {
        if (amountToAdd instanceof Period) {
            Period periodToAdd = (Period)amountToAdd;
            return this.plusMonths(periodToAdd.toTotalMonths()).plusDays(periodToAdd.getDays());
        }
        Objects.requireNonNull(amountToAdd, "amountToAdd");
        return (JalaliDate)amountToAdd.addTo(this);
    }

    @Override
    public JalaliDate plus(long amountToAdd, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            ChronoUnit f = (ChronoUnit)unit;
            switch (f) {
                case DAYS: {
                    return this.plusDays(amountToAdd);
                }
                case WEEKS: {
                    return this.plusWeeks(amountToAdd);
                }
                case MONTHS: {
                    return this.plusMonths(amountToAdd);
                }
                case YEARS: {
                    return this.plusYears(amountToAdd);
                }
                case DECADES: {
                    return this.plusYears(Math.multiplyExact(amountToAdd, 10L));
                }
                case CENTURIES: {
                    return this.plusYears(Math.multiplyExact(amountToAdd, 100L));
                }
                case MILLENNIA: {
                    return this.plusYears(Math.multiplyExact(amountToAdd, 1000L));
                }
                case ERAS: {
                    return this.with(ChronoField.ERA, Math.addExact(this.getLong(ChronoField.ERA), amountToAdd));
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
        }
        return unit.addTo(this, amountToAdd);
    }

    public JalaliDate plusYears(long yearsToAdd) {
        if (yearsToAdd == 0L) {
            return this;
        }
        int newYear = ChronoField.YEAR.checkValidIntValue((long)this.year + yearsToAdd);
        return JalaliDate.resolvePreviousValid(newYear, this.month, this.day);
    }

    public JalaliDate plusMonths(long monthsToAdd) {
        if (monthsToAdd == 0L) {
            return this;
        }
        long monthCount = (long)this.year * 12L + (long)(this.month - 1);
        long calcMonths = monthCount + monthsToAdd;
        int newYear = ChronoField.YEAR.checkValidIntValue(Math.floorDiv(calcMonths, 12L));
        int newMonth = (int)(Math.floorMod(calcMonths, 12L) + 1L);
        return JalaliDate.resolvePreviousValid(newYear, newMonth, this.day);
    }

    public JalaliDate plusWeeks(long weeksToAdd) {
        return this.plusDays(Math.multiplyExact(weeksToAdd, 7L));
    }

    public JalaliDate plusDays(long daysToAdd) {
        if (daysToAdd == 0L) {
            return this;
        }
        JalaliYear year = JalaliYear.of(this.getYear());
        JalaliMonth month = this.getMonth();
        int dayOfMonth = this.getDayOfMonth();
        while (daysToAdd >= (long)year.length()) {
            daysToAdd -= (long)year.length();
            year = year.plusYears(1L);
        }
        while (daysToAdd >= (long)month.length(year.isLeap())) {
            daysToAdd -= (long)month.length(year.isLeap());
            if ((month = month.plus(1L)) != JalaliMonth.FARVARDIN) continue;
            year = year.plusYears(1L);
        }
        if ((dayOfMonth = (int)((long)dayOfMonth + daysToAdd)) > month.length(year.isLeap())) {
            dayOfMonth -= month.length(year.isLeap());
            if ((month = month.plus(1L)) == JalaliMonth.FARVARDIN) {
                year = year.plusYears(1L);
            }
        }
        return JalaliDate.of(year.getValue(), month, dayOfMonth);
    }

    @Override
    public JalaliDate minus(TemporalAmount amountToSubtract) {
        if (amountToSubtract instanceof Period) {
            Period periodToSubtract = (Period)amountToSubtract;
            return this.minusMonths(periodToSubtract.toTotalMonths()).minusDays(periodToSubtract.getDays());
        }
        Objects.requireNonNull(amountToSubtract, "amountToSubtract");
        return (JalaliDate)amountToSubtract.subtractFrom(this);
    }

    @Override
    public JalaliDate minus(long amountToSubtract, TemporalUnit unit) {
        return amountToSubtract == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, unit).plus(1L, unit) : this.plus(-amountToSubtract, unit);
    }

    public JalaliDate minusYears(long yearsToSubtract) {
        return yearsToSubtract == Long.MIN_VALUE ? this.plusYears(Long.MAX_VALUE).plusYears(1L) : this.plusYears(-yearsToSubtract);
    }

    public JalaliDate minusMonths(long monthsToSubtract) {
        return monthsToSubtract == Long.MIN_VALUE ? this.plusMonths(Long.MAX_VALUE).plusMonths(1L) : this.plusMonths(-monthsToSubtract);
    }

    public JalaliDate minusWeeks(long weeksToSubtract) {
        return weeksToSubtract == Long.MIN_VALUE ? this.plusWeeks(Long.MAX_VALUE).plusWeeks(1L) : this.plusWeeks(-weeksToSubtract);
    }

    public JalaliDate minusDays(long daysToSubtract) {
        return daysToSubtract == Long.MIN_VALUE ? this.plusDays(Long.MAX_VALUE).plusDays(1L) : this.plusDays(-daysToSubtract);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.localDate()) {
            return (R)this;
        }
        return ChronoLocalDate.super.query(query);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return ChronoLocalDate.super.adjustInto(temporal);
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        JalaliDate end = JalaliDate.from(endExclusive);
        if (unit instanceof ChronoUnit) {
            switch ((ChronoUnit)unit) {
                case DAYS: {
                    return this.daysUntil(end);
                }
                case WEEKS: {
                    return this.daysUntil(end) / 7L;
                }
                case MONTHS: {
                    return this.monthsUntil(end);
                }
                case YEARS: {
                    return this.monthsUntil(end) / 12L;
                }
                case DECADES: {
                    return this.monthsUntil(end) / 120L;
                }
                case CENTURIES: {
                    return this.monthsUntil(end) / 1200L;
                }
                case MILLENNIA: {
                    return this.monthsUntil(end) / 12000L;
                }
                case ERAS: {
                    return end.getLong(ChronoField.ERA) - this.getLong(ChronoField.ERA);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
        }
        return unit.between(this, end);
    }

    long daysUntil(JalaliDate end) {
        return end.toEpochDay() - this.toEpochDay();
    }

    private long monthsUntil(JalaliDate end) {
        long packed1 = this.getProlepticMonth() * 32L + (long)this.getDayOfMonth();
        long packed2 = end.getProlepticMonth() * 32L + (long)end.getDayOfMonth();
        return (packed2 - packed1) / 32L;
    }

    @Override
    public Period until(ChronoLocalDate endDateExclusive) {
        JalaliDate end = JalaliDate.from(endDateExclusive);
        long totalMonths = end.getProlepticMonth() - this.getProlepticMonth();
        int days = end.day - this.day;
        if (totalMonths > 0L && days < 0) {
            JalaliDate calcDate = this.plusMonths(--totalMonths);
            days = (int)(end.toEpochDay() - calcDate.toEpochDay());
        } else if (totalMonths < 0L && days > 0) {
            ++totalMonths;
            days -= end.lengthOfMonth();
        }
        long years = totalMonths / 12L;
        int months = (int)(totalMonths % 12L);
        return Period.of(Math.toIntExact(years), months, days);
    }

    @Override
    public String format(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.withChronology(this.getChronology()).format(this);
    }

    public final JalaliDateTime atTime(LocalTime time) {
        return JalaliDateTime.of(this, time);
    }

    public JalaliDateTime atTime(int hour, int minute) {
        return this.atTime(LocalTime.of(hour, minute));
    }

    public JalaliDateTime atTime(int hour, int minute, int second) {
        return this.atTime(LocalTime.of(hour, minute, second));
    }

    public JalaliDateTime atTime(int hour, int minute, int second, int nanoOfSecond) {
        return this.atTime(LocalTime.of(hour, minute, second, nanoOfSecond));
    }

    public JalaliDateTime atStartOfDay() {
        return JalaliDateTime.of(this, LocalTime.MIDNIGHT);
    }

    @Override
    public long toEpochDay() {
        long total = this.year * 365;
        for (int i = 0; i < this.year; ++i) {
            if (!JalaliYear.isLeap(i)) continue;
            ++total;
        }
        return (total += (long)this.getDayOfYear()) - 492634L;
    }

    @Override
    public int compareTo(ChronoLocalDate other) {
        if (other instanceof JalaliDate) {
            return this.compareTo0((JalaliDate)other);
        }
        return ChronoLocalDate.super.compareTo(other);
    }

    int compareTo0(JalaliDate otherDate) {
        int cmp = this.year - otherDate.year;
        if (cmp == 0 && (cmp = this.month - otherDate.month) == 0) {
            cmp = this.day - otherDate.day;
        }
        return cmp;
    }

    @Override
    public boolean isAfter(ChronoLocalDate other) {
        if (other instanceof JalaliDate) {
            return this.compareTo0((JalaliDate)other) > 0;
        }
        return ChronoLocalDate.super.isAfter(other);
    }

    @Override
    public boolean isBefore(ChronoLocalDate other) {
        if (other instanceof JalaliDate) {
            return this.compareTo0((JalaliDate)other) < 0;
        }
        return ChronoLocalDate.super.isBefore(other);
    }

    @Override
    public boolean isEqual(ChronoLocalDate other) {
        if (other instanceof JalaliDate) {
            return this.compareTo0((JalaliDate)other) == 0;
        }
        return ChronoLocalDate.super.isEqual(other);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JalaliDate) {
            return this.compareTo0((JalaliDate)obj) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int yearValue = this.year;
        return yearValue & 0xFFFFF800 ^ (yearValue << 11) + (this.month << 6) + this.day;
    }

    @Override
    public String toString() {
        int yearValue = this.year;
        short monthValue = this.month;
        short dayValue = this.day;
        int absYear = Math.abs(yearValue);
        StringBuilder buf = new StringBuilder(10);
        if (absYear < 1000) {
            if (yearValue < 0) {
                buf.append(yearValue - 10000).deleteCharAt(1);
            } else {
                buf.append(yearValue + 10000).deleteCharAt(0);
            }
        } else {
            if (yearValue > 9999) {
                buf.append('+');
            }
            buf.append(yearValue);
        }
        return buf.append(monthValue < 10 ? "-0" : "-").append(monthValue).append(dayValue < 10 ? "-0" : "-").append(dayValue).toString();
    }
}

