/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.time.temporal.WeekFields;
import java.util.Objects;
import org.bardframework.time.JalaliChronology;
import org.bardframework.time.JalaliDate;
import org.bardframework.time.JalaliMonth;
import org.bardframework.time.format.JalaliDateTimeFormatter;
import org.bardframework.time.temporal.JalaliIsoFields;

public final class JalaliDateTime
implements Temporal,
TemporalAdjuster,
ChronoLocalDateTime<JalaliDate>,
Serializable {
    public static final JalaliDateTime MIN = JalaliDateTime.of(JalaliDate.MIN, LocalTime.MIN);
    public static final JalaliDateTime MAX = JalaliDateTime.of(JalaliDate.MAX, LocalTime.MAX);
    static final long HOURS_PER_DAY = 24L;
    static final int MINUTES_PER_HOUR = 60;
    static final long MINUTES_PER_DAY = 1440L;
    static final int SECONDS_PER_MINUTE = 60;
    static final int SECONDS_PER_HOUR = 3600;
    static final long SECONDS_PER_DAY = 86400L;
    static final long MILLIS_PER_DAY = 86400000L;
    static final long MICROS_PER_DAY = 86400000000L;
    static final long NANOS_PER_SECOND = 1000000000L;
    static final long NANOS_PER_MINUTE = 60000000000L;
    static final long NANOS_PER_HOUR = 3600000000000L;
    static final long NANOS_PER_DAY = 86400000000000L;
    private static final long serialVersionUID = 6207766400415563566L;
    private final JalaliDate date;
    private final LocalTime time;

    private JalaliDateTime(JalaliDate date, LocalTime time) {
        this.date = date;
        this.time = time;
    }

    public static JalaliDateTime now() {
        return JalaliDateTime.now(Clock.system(ZoneOffset.UTC));
    }

    public static JalaliDateTime now(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        Instant now = clock.instant();
        return JalaliDateTime.ofEpochSecond(now.getEpochSecond(), now.getNano());
    }

    public static JalaliDateTime of(int year, JalaliMonth month, int dayOfMonth, int hour, int minute) {
        JalaliDate date = JalaliDate.of(year, month, dayOfMonth);
        LocalTime time = LocalTime.of(hour, minute);
        return new JalaliDateTime(date, time);
    }

    public static JalaliDateTime of(int year, JalaliMonth month, int dayOfMonth, int hour, int minute, int second) {
        JalaliDate date = JalaliDate.of(year, month, dayOfMonth);
        LocalTime time = LocalTime.of(hour, minute, second);
        return new JalaliDateTime(date, time);
    }

    public static JalaliDateTime of(int year, JalaliMonth month, int dayOfMonth, int hour, int minute, int second, int nanoOfSecond) {
        JalaliDate date = JalaliDate.of(year, month, dayOfMonth);
        LocalTime time = LocalTime.of(hour, minute, second, nanoOfSecond);
        return new JalaliDateTime(date, time);
    }

    public static JalaliDateTime of(int year, int month, int dayOfMonth, int hour, int minute) throws DateTimeException {
        JalaliDate date = JalaliDate.of(year, month, dayOfMonth);
        LocalTime time = LocalTime.of(hour, minute);
        return new JalaliDateTime(date, time);
    }

    public static JalaliDateTime of(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        JalaliDate date = JalaliDate.of(year, month, dayOfMonth);
        LocalTime time = LocalTime.of(hour, minute, second);
        return new JalaliDateTime(date, time);
    }

    public static JalaliDateTime of(int year, int month, int dayOfMonth, int hour, int minute, int second, int nanoOfSecond) {
        JalaliDate date = JalaliDate.of(year, month, dayOfMonth);
        LocalTime time = LocalTime.of(hour, minute, second, nanoOfSecond);
        return new JalaliDateTime(date, time);
    }

    public static JalaliDateTime of(JalaliDate date, LocalTime time) {
        Objects.requireNonNull(date, "date");
        Objects.requireNonNull(time, "time");
        return new JalaliDateTime(date, time);
    }

    public static JalaliDateTime of(LocalDateTime dateTime) {
        Objects.requireNonNull(dateTime, "dateTime");
        return new JalaliDateTime(JalaliDate.of(dateTime.toLocalDate()), dateTime.toLocalTime());
    }

    public static JalaliDateTime of(String jalaliDateTimeString) {
        if (null == jalaliDateTimeString) {
            throw new IllegalArgumentException("invalid jalaliDateTimeString: " + jalaliDateTimeString);
        }
        String digit = jalaliDateTimeString.replaceAll("[^\\d]", "");
        if (8 > digit.length() || 23 < digit.length()) {
            throw new IllegalArgumentException("cant obtain date value from: " + digit + " min digit count is 8 (yyyymmdd) and max is 23 (yyyymmddhhmmssnnnnnnnnnn) ");
        }
        JalaliDate jalaliDate = JalaliDate.of(Integer.parseInt(digit.substring(0, 4)), Integer.parseInt(digit.substring(4, 6)), Integer.parseInt(digit.substring(6, 8)));
        int hour = 0;
        int minute = 0;
        int second = 0;
        int nanoOfSecond = 0;
        if (8 < digit.length()) {
            hour = Integer.parseInt(digit.substring(8, 9 < digit.length() ? 10 : 9));
        }
        if (10 < digit.length()) {
            minute = Integer.parseInt(digit.substring(10, 11 < digit.length() ? 12 : 11));
        }
        if (12 < digit.length()) {
            second = Integer.parseInt(digit.substring(12, 13 < digit.length() ? 14 : 13));
        }
        if (14 < digit.length()) {
            nanoOfSecond = Integer.parseInt(digit.substring(14));
        }
        return JalaliDateTime.of(jalaliDate, LocalTime.of(hour, minute, second, nanoOfSecond));
    }

    public static JalaliDateTime ofInstant(Instant instant) {
        Objects.requireNonNull(instant, "instant");
        return JalaliDateTime.ofEpochSecond(instant.getEpochSecond(), instant.getNano());
    }

    public static JalaliDateTime ofEpochSecond(long epochSecond, int nanoOfSecond) {
        ChronoField.NANO_OF_SECOND.checkValidValue(nanoOfSecond);
        long localEpochDay = Math.floorDiv(epochSecond, 86400L);
        long secsOfDay = Math.floorMod(epochSecond, 86400L);
        JalaliDate date = JalaliDate.ofEpochDay(localEpochDay);
        LocalTime time = LocalTime.ofNanoOfDay(secsOfDay * 1000000000L + (long)nanoOfSecond);
        return new JalaliDateTime(date, time);
    }

    public static JalaliDateTime from(TemporalAccessor temporal) {
        if (temporal instanceof JalaliDateTime) {
            return (JalaliDateTime)temporal;
        }
        try {
            JalaliDate date = JalaliDate.from(temporal);
            LocalTime time = LocalTime.from(temporal);
            return new JalaliDateTime(date, time);
        }
        catch (DateTimeException ex) {
            throw new DateTimeException("Unable to obtain LocalDateTime from TemporalAccessor: " + temporal + " of type " + temporal.getClass().getName(), ex);
        }
    }

    public static JalaliDateTime parse(CharSequence text) {
        return JalaliDateTime.parse(text, JalaliDateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public static JalaliDateTime parse(CharSequence text, JalaliDateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.withChronology(JalaliChronology.INSTANCE).parse(text, JalaliDateTime::from);
    }

    public LocalDateTime toLocalDateTime() {
        return LocalDateTime.of(this.toLocalDate().toLocalDate(), this.toLocalTime());
    }

    @Override
    public JalaliDate toLocalDate() {
        return this.date;
    }

    private JalaliDateTime with(JalaliDate newDate, LocalTime newTime) {
        if (this.date == newDate && this.time == newTime) {
            return this;
        }
        return new JalaliDateTime(newDate, newTime);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            return f.isDateBased() || f.isTimeBased();
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            return unit != ChronoUnit.FOREVER;
        }
        return unit != null && unit.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            return f.isTimeBased() ? this.time.range(field) : this.date.range(field);
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField field) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            return f.isTimeBased() ? this.time.get(field) : this.date.get(field);
        }
        ValueRange range = this.range(field);
        if (!range.isIntValue()) {
            throw new UnsupportedTemporalTypeException("Invalid field " + field + " for get() method, use getLong() instead");
        }
        long value = this.getLong(field);
        if (!range.isValidValue(value)) {
            throw new DateTimeException("Invalid value for " + field + " (valid values " + range + "): " + value);
        }
        return (int)value;
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            return f.isTimeBased() ? this.time.getLong(field) : this.date.getLong(field);
        }
        if (WeekFields.WEEK_BASED_YEARS.equals(field)) {
            return JalaliIsoFields.getWeekBasedYear(this.date);
        }
        if (IsoFields.WEEK_OF_WEEK_BASED_YEAR.equals(field)) {
            return JalaliIsoFields.getWeek(this.date);
        }
        return field.getFrom(this);
    }

    public int getYear() {
        return this.date.getYear();
    }

    public int getMonthValue() {
        return this.date.getMonthValue();
    }

    public JalaliMonth getMonth() {
        return this.date.getMonth();
    }

    public int getDayOfMonth() {
        return this.date.getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.date.getDayOfYear();
    }

    public DayOfWeek getDayOfWeek() {
        return this.date.getDayOfWeek();
    }

    @Override
    public LocalTime toLocalTime() {
        return this.time;
    }

    public int getHour() {
        return this.time.getHour();
    }

    public int getMinute() {
        return this.time.getMinute();
    }

    public int getSecond() {
        return this.time.getSecond();
    }

    public int getNano() {
        return this.time.getNano();
    }

    @Override
    public JalaliDateTime with(TemporalAdjuster adjuster) {
        if (adjuster instanceof JalaliDate) {
            return this.with((JalaliDate)adjuster, this.time);
        }
        if (adjuster instanceof LocalTime) {
            return this.with(this.date, (LocalTime)adjuster);
        }
        if (adjuster instanceof JalaliDateTime) {
            return (JalaliDateTime)adjuster;
        }
        return (JalaliDateTime)adjuster.adjustInto(this);
    }

    @Override
    public JalaliDateTime with(TemporalField field, long newValue) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            if (f.isTimeBased()) {
                return this.with(this.date, this.time.with(field, newValue));
            }
            return this.with(this.date.with(field, newValue), this.time);
        }
        return field.adjustInto(this, newValue);
    }

    public JalaliDateTime withYear(int year) {
        return this.with(this.date.withYear(year), this.time);
    }

    public JalaliDateTime withMonth(int month) {
        return this.with(this.date.withMonth(month), this.time);
    }

    public JalaliDateTime withDayOfMonth(int dayOfMonth) {
        return this.with(this.date.withDayOfMonth(dayOfMonth), this.time);
    }

    public JalaliDateTime withDayOfYear(int dayOfYear) {
        return this.with(this.date.withDayOfYear(dayOfYear), this.time);
    }

    public JalaliDateTime withHour(int hour) {
        LocalTime newTime = this.time.withHour(hour);
        return this.with(this.date, newTime);
    }

    public JalaliDateTime withMinute(int minute) {
        LocalTime newTime = this.time.withMinute(minute);
        return this.with(this.date, newTime);
    }

    public JalaliDateTime withSecond(int second) {
        LocalTime newTime = this.time.withSecond(second);
        return this.with(this.date, newTime);
    }

    public JalaliDateTime withNano(int nanoOfSecond) {
        LocalTime newTime = this.time.withNano(nanoOfSecond);
        return this.with(this.date, newTime);
    }

    public JalaliDateTime truncatedTo(TemporalUnit unit) {
        return this.with(this.date, this.time.truncatedTo(unit));
    }

    @Override
    public JalaliDateTime plus(TemporalAmount amountToAdd) {
        if (amountToAdd instanceof Period) {
            Period periodToAdd = (Period)amountToAdd;
            return this.with(this.date.plus(periodToAdd), this.time);
        }
        Objects.requireNonNull(amountToAdd, "amountToAdd");
        return (JalaliDateTime)amountToAdd.addTo(this);
    }

    @Override
    public JalaliDateTime plus(long amountToAdd, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            ChronoUnit f = (ChronoUnit)unit;
            switch (f) {
                case NANOS: {
                    return this.plusNanos(amountToAdd);
                }
                case MICROS: {
                    return this.plusDays(amountToAdd / 86400000000L).plusNanos(amountToAdd % 86400000000L * 1000L);
                }
                case MILLIS: {
                    return this.plusDays(amountToAdd / 86400000L).plusNanos(amountToAdd % 86400000L * 1000000L);
                }
                case SECONDS: {
                    return this.plusSeconds(amountToAdd);
                }
                case MINUTES: {
                    return this.plusMinutes(amountToAdd);
                }
                case HOURS: {
                    return this.plusHours(amountToAdd);
                }
                case HALF_DAYS: {
                    return this.plusDays(amountToAdd / 256L).plusHours(amountToAdd % 256L * 12L);
                }
            }
            return this.with(this.date.plus(amountToAdd, unit), this.time);
        }
        return unit.addTo(this, amountToAdd);
    }

    public JalaliDateTime plusYears(long years) {
        JalaliDate newDate = this.date.plusYears(years);
        return this.with(newDate, this.time);
    }

    public JalaliDateTime plusMonths(long months) {
        JalaliDate newDate = this.date.plusMonths(months);
        return this.with(newDate, this.time);
    }

    public JalaliDateTime plusWeeks(long weeks) {
        JalaliDate newDate = this.date.plusWeeks(weeks);
        return this.with(newDate, this.time);
    }

    public JalaliDateTime plusDays(long days) {
        JalaliDate newDate = this.date.plusDays(days);
        return this.with(newDate, this.time);
    }

    public JalaliDateTime plusHours(long hours) {
        return this.plusWithOverflow(this.date, hours, 0L, 0L, 0L, 1);
    }

    public JalaliDateTime plusMinutes(long minutes) {
        return this.plusWithOverflow(this.date, 0L, minutes, 0L, 0L, 1);
    }

    public JalaliDateTime plusSeconds(long seconds) {
        return this.plusWithOverflow(this.date, 0L, 0L, seconds, 0L, 1);
    }

    public JalaliDateTime plusNanos(long nanos) {
        return this.plusWithOverflow(this.date, 0L, 0L, 0L, nanos, 1);
    }

    @Override
    public JalaliDateTime minus(TemporalAmount amountToSubtract) {
        if (amountToSubtract instanceof Period) {
            Period periodToSubtract = (Period)amountToSubtract;
            return this.with(this.date.minus(periodToSubtract), this.time);
        }
        Objects.requireNonNull(amountToSubtract, "amountToSubtract");
        return (JalaliDateTime)amountToSubtract.subtractFrom(this);
    }

    @Override
    public JalaliDateTime minus(long amountToSubtract, TemporalUnit unit) {
        return amountToSubtract == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, unit).plus(1L, unit) : this.plus(-amountToSubtract, unit);
    }

    public JalaliDateTime minusYears(long years) {
        return years == Long.MIN_VALUE ? this.plusYears(Long.MAX_VALUE).plusYears(1L) : this.plusYears(-years);
    }

    public JalaliDateTime minusMonths(long months) {
        return months == Long.MIN_VALUE ? this.plusMonths(Long.MAX_VALUE).plusMonths(1L) : this.plusMonths(-months);
    }

    public JalaliDateTime minusWeeks(long weeks) {
        return weeks == Long.MIN_VALUE ? this.plusWeeks(Long.MAX_VALUE).plusWeeks(1L) : this.plusWeeks(-weeks);
    }

    public JalaliDateTime minusDays(long days) {
        return days == Long.MIN_VALUE ? this.plusDays(Long.MAX_VALUE).plusDays(1L) : this.plusDays(-days);
    }

    public JalaliDateTime minusHours(long hours) {
        return this.plusWithOverflow(this.date, hours, 0L, 0L, 0L, -1);
    }

    public JalaliDateTime minusMinutes(long minutes) {
        return this.plusWithOverflow(this.date, 0L, minutes, 0L, 0L, -1);
    }

    public JalaliDateTime minusSeconds(long seconds) {
        return this.plusWithOverflow(this.date, 0L, 0L, seconds, 0L, -1);
    }

    public JalaliDateTime minusNanos(long nanos) {
        return this.plusWithOverflow(this.date, 0L, 0L, 0L, nanos, -1);
    }

    private JalaliDateTime plusWithOverflow(JalaliDate newDate, long hours, long minutes, long seconds, long nanos, int sign) {
        if ((hours | minutes | seconds | nanos) == 0L) {
            return this.with(newDate, this.time);
        }
        long totDays = nanos / 86400000000000L + seconds / 86400L + minutes / 1440L + hours / 24L;
        totDays *= (long)sign;
        long totNanos = nanos % 86400000000000L + seconds % 86400L * 1000000000L + minutes % 1440L * 60000000000L + hours % 24L * 3600000000000L;
        long curNoD = this.time.toNanoOfDay();
        totNanos = totNanos * (long)sign + curNoD;
        long newNoD = Math.floorMod(totNanos, 86400000000000L);
        LocalTime newTime = newNoD == curNoD ? this.time : LocalTime.ofNanoOfDay(newNoD);
        return this.with(newDate.plusDays(totDays += Math.floorDiv(totNanos, 86400000000000L)), newTime);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.localDate()) {
            return (R)this.date;
        }
        if (query == TemporalQueries.zoneId() || query == TemporalQueries.zone() || query == TemporalQueries.offset()) {
            return null;
        }
        if (query == TemporalQueries.localTime()) {
            return (R)this.toLocalTime();
        }
        if (query == TemporalQueries.chronology()) {
            return (R)this.getChronology();
        }
        if (query == TemporalQueries.precision()) {
            return (R)ChronoUnit.NANOS;
        }
        return query.queryFrom(this);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField.EPOCH_DAY, this.toLocalDate().toEpochDay()).with(ChronoField.NANO_OF_DAY, this.toLocalTime().toNanoOfDay());
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        JalaliDateTime end = JalaliDateTime.from(endExclusive);
        if (unit instanceof ChronoUnit) {
            if (unit.isTimeBased()) {
                long amount = this.date.daysUntil(end.date);
                if (amount == 0L) {
                    return this.time.until(end.time, unit);
                }
                long timePart = end.time.toNanoOfDay() - this.time.toNanoOfDay();
                if (amount > 0L) {
                    --amount;
                    timePart += 86400000000000L;
                } else {
                    ++amount;
                    timePart -= 86400000000000L;
                }
                switch ((ChronoUnit)unit) {
                    case NANOS: {
                        amount = Math.multiplyExact(amount, 86400000000000L);
                        break;
                    }
                    case MICROS: {
                        amount = Math.multiplyExact(amount, 86400000000L);
                        timePart /= 1000L;
                        break;
                    }
                    case MILLIS: {
                        amount = Math.multiplyExact(amount, 86400000L);
                        timePart /= 1000000L;
                        break;
                    }
                    case SECONDS: {
                        amount = Math.multiplyExact(amount, 86400L);
                        timePart /= 1000000000L;
                        break;
                    }
                    case MINUTES: {
                        amount = Math.multiplyExact(amount, 1440L);
                        timePart /= 60000000000L;
                        break;
                    }
                    case HOURS: {
                        amount = Math.multiplyExact(amount, 24L);
                        timePart /= 3600000000000L;
                        break;
                    }
                    case HALF_DAYS: {
                        amount = Math.multiplyExact(amount, 2L);
                        timePart /= 43200000000000L;
                    }
                }
                return Math.addExact(amount, timePart);
            }
            JalaliDate endDate = end.date;
            if (endDate.isAfter(this.date) && end.time.isBefore(this.time)) {
                endDate = endDate.minusDays(1L);
            } else if (endDate.isBefore(this.date) && end.time.isAfter(this.time)) {
                endDate = endDate.plusDays(1L);
            }
            return this.date.until(endDate, unit);
        }
        return unit.between(this, end);
    }

    @Override
    public String format(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.withChronology(this.getChronology()).format(this);
    }

    @Override
    public ChronoZonedDateTime<JalaliDate> atZone(ZoneId zone) {
        throw new IllegalArgumentException("not implemented");
    }

    @Override
    public int compareTo(ChronoLocalDateTime<?> other) {
        if (other instanceof JalaliDateTime) {
            return this.compareTo0((JalaliDateTime)other);
        }
        return ChronoLocalDateTime.super.compareTo(other);
    }

    private int compareTo0(JalaliDateTime other) {
        int cmp = this.date.compareTo0(other.toLocalDate());
        if (cmp == 0) {
            cmp = this.time.compareTo(other.toLocalTime());
        }
        return cmp;
    }

    @Override
    public boolean isAfter(ChronoLocalDateTime<?> other) {
        if (other instanceof JalaliDateTime) {
            return this.compareTo0((JalaliDateTime)other) > 0;
        }
        return ChronoLocalDateTime.super.isAfter(other);
    }

    @Override
    public boolean isBefore(ChronoLocalDateTime<?> other) {
        if (other instanceof JalaliDateTime) {
            return this.compareTo0((JalaliDateTime)other) < 0;
        }
        return ChronoLocalDateTime.super.isBefore(other);
    }

    @Override
    public boolean isEqual(ChronoLocalDateTime<?> other) {
        if (other instanceof JalaliDateTime) {
            return this.compareTo0((JalaliDateTime)other) == 0;
        }
        return ChronoLocalDateTime.super.isEqual(other);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JalaliDateTime) {
            JalaliDateTime other = (JalaliDateTime)obj;
            return this.date.equals(other.date) && this.time.equals(other.time);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.date.hashCode() ^ this.time.hashCode();
    }

    @Override
    public String toString() {
        return this.date.toString() + 'T' + this.time.toString();
    }
}

