/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Objects;
import org.bardframework.time.JalaliChronology;
import org.bardframework.time.JalaliDate;
import org.bardframework.time.JalaliMonth;
import org.bardframework.time.JalaliYear;

public final class JalaliMonthDay
implements TemporalAccessor,
TemporalAdjuster,
Comparable<JalaliMonthDay>,
Serializable {
    private static final long serialVersionUID = -939150713474957432L;
    private static final DateTimeFormatter PARSER = new DateTimeFormatterBuilder().appendLiteral("--").appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();
    private final int month;
    private final int day;

    private JalaliMonthDay(int month, int dayOfMonth) {
        this.month = month;
        this.day = dayOfMonth;
    }

    public static JalaliMonthDay now() {
        return JalaliMonthDay.now(Clock.systemDefaultZone());
    }

    public static JalaliMonthDay now(ZoneId zone) {
        return JalaliMonthDay.now(Clock.system(zone));
    }

    public static JalaliMonthDay now(Clock clock) {
        JalaliDate now = JalaliDate.now(clock);
        return JalaliMonthDay.of(now.getMonth(), now.getDayOfMonth());
    }

    public static JalaliMonthDay of(JalaliMonth month, int dayOfMonth) {
        Objects.requireNonNull(month, "month");
        ChronoField.DAY_OF_MONTH.checkValidValue(dayOfMonth);
        if (dayOfMonth > month.maxLength()) {
            throw new DateTimeException("Illegal value for DayOfMonth field, value " + dayOfMonth + " is not valid for month " + month.name());
        }
        return new JalaliMonthDay(month.getValue(), dayOfMonth);
    }

    public static JalaliMonthDay of(int month, int dayOfMonth) {
        return JalaliMonthDay.of(JalaliMonth.of(month), dayOfMonth);
    }

    public static JalaliMonthDay from(TemporalAccessor temporal) {
        if (temporal instanceof JalaliMonthDay) {
            return (JalaliMonthDay)temporal;
        }
        try {
            if (!JalaliChronology.INSTANCE.equals(Chronology.from(temporal))) {
                temporal = JalaliDate.from(temporal);
            }
            return JalaliMonthDay.of(temporal.get(ChronoField.MONTH_OF_YEAR), temporal.get(ChronoField.DAY_OF_MONTH));
        }
        catch (DateTimeException ex) {
            throw new DateTimeException("Unable to obtain JalaliMonthDay from TemporalAccessor: " + temporal + " of type " + temporal.getClass().getName(), ex);
        }
    }

    public static JalaliMonthDay parse(CharSequence text) {
        return JalaliMonthDay.parse(text, PARSER);
    }

    public static JalaliMonthDay parse(CharSequence text, DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.parse(text, JalaliMonthDay::from);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return field == ChronoField.MONTH_OF_YEAR || field == ChronoField.DAY_OF_MONTH;
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field == ChronoField.MONTH_OF_YEAR) {
            return field.range();
        }
        if (field == ChronoField.DAY_OF_MONTH) {
            return ValueRange.of(1L, this.getMonth().minLength(), this.getMonth().maxLength());
        }
        return TemporalAccessor.super.range(field);
    }

    @Override
    public int get(TemporalField field) {
        return this.range(field).checkValidIntValue(this.getLong(field), field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            switch ((ChronoField)field) {
                case DAY_OF_MONTH: {
                    return this.day;
                }
                case MONTH_OF_YEAR: {
                    return this.month;
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return field.getFrom(this);
    }

    public int getMonthValue() {
        return this.month;
    }

    public JalaliMonth getMonth() {
        return JalaliMonth.of(this.month);
    }

    public int getDayOfMonth() {
        return this.day;
    }

    public boolean isValidYear(int year) {
        return this.day != 29 || this.month != 2 || JalaliYear.isLeap(year);
    }

    public JalaliMonthDay withMonth(int month) {
        return this.with(JalaliMonth.of(month));
    }

    public JalaliMonthDay with(JalaliMonth month) {
        Objects.requireNonNull(month, "month");
        if (month.getValue() == this.month) {
            return this;
        }
        int day = Math.min(this.day, month.maxLength());
        return new JalaliMonthDay(month.getValue(), day);
    }

    public JalaliMonthDay withDayOfMonth(int dayOfMonth) {
        if (dayOfMonth == this.day) {
            return this;
        }
        return JalaliMonthDay.of(this.month, dayOfMonth);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.chronology()) {
            return (R)JalaliChronology.INSTANCE;
        }
        return TemporalAccessor.super.query(query);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        if (!Chronology.from(temporal).equals(JalaliChronology.INSTANCE)) {
            throw new DateTimeException("Adjustment only supported on ISO date-time");
        }
        temporal = temporal.with(ChronoField.MONTH_OF_YEAR, this.month);
        return temporal.with(ChronoField.DAY_OF_MONTH, Math.min(temporal.range(ChronoField.DAY_OF_MONTH).getMaximum(), (long)this.day));
    }

    public String format(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.format(this);
    }

    public JalaliDate atYear(int year) {
        return JalaliDate.of(year, this.month, this.isValidYear(year) ? this.day : 28);
    }

    @Override
    public int compareTo(JalaliMonthDay other) {
        int cmp = this.month - other.month;
        if (cmp == 0) {
            cmp = this.day - other.day;
        }
        return cmp;
    }

    public boolean isAfter(JalaliMonthDay other) {
        return this.compareTo(other) > 0;
    }

    public boolean isBefore(JalaliMonthDay other) {
        return this.compareTo(other) < 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JalaliMonthDay) {
            JalaliMonthDay other = (JalaliMonthDay)obj;
            return this.month == other.month && this.day == other.day;
        }
        return false;
    }

    public int hashCode() {
        return (this.month << 6) + this.day;
    }

    public String toString() {
        return "--" + (this.month < 10 ? "0" : "") + this.month + (this.day < 10 ? "-0" : "-") + this.day;
    }
}

