/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Objects;
import org.bardframework.time.JalaliChronology;
import org.bardframework.time.JalaliDate;
import org.bardframework.time.JalaliMonth;
import org.bardframework.time.JalaliMonthDay;
import org.bardframework.time.JalaliYearMonth;

public final class JalaliYear
implements Temporal,
TemporalAdjuster,
Comparable<JalaliYear>,
Serializable {
    public static final int MIN_VALUE = -999999999;
    public static final int MAX_VALUE = 999999999;
    private static final int[] validRemaining_after_474 = new int[]{0, 4, 8, 12, 16, 20, 24, 29, 33, 37, 41, 45, 49, 53, 57, 62, 66, 70, 74, 78, 82, 86, 90, 95, 99, 103, 107, 111, 115, 119, 124};
    private static final int[] validRemaining_before_474 = new int[]{0, 4, 8, 12, 16, 20, 25, 29, 33, 37, 41, 45, 49, 53, 58, 62, 66, 70, 74, 78, 82, 86, 91, 95, 99, 103, 107, 111, 115, 120, 124};
    private static final long serialVersionUID = -23038383694477807L;
    private static final DateTimeFormatter PARSER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).toFormatter();
    private final int year;

    private JalaliYear(int year) {
        this.year = year;
    }

    public static JalaliYear now() {
        return JalaliYear.now(Clock.systemDefaultZone());
    }

    public static JalaliYear now(ZoneId zone) {
        return JalaliYear.now(Clock.system(zone));
    }

    public static JalaliYear now(Clock clock) {
        JalaliDate now = JalaliDate.now(clock);
        return JalaliYear.of(now.getYear());
    }

    public static JalaliYear of(int isoYear) throws DateTimeException {
        ChronoField.YEAR.checkValidValue(isoYear);
        return new JalaliYear(isoYear);
    }

    public static JalaliYear from(TemporalAccessor temporal) {
        if (temporal instanceof JalaliYear) {
            return (JalaliYear)temporal;
        }
        Objects.requireNonNull(temporal, "temporal");
        try {
            if (!JalaliChronology.INSTANCE.equals(Chronology.from(temporal))) {
                temporal = JalaliDate.from(temporal);
            }
            return JalaliYear.of(temporal.get(ChronoField.YEAR));
        }
        catch (DateTimeException ex) {
            throw new DateTimeException("Unable to obtain JalaliYear from TemporalAccessor: " + temporal + " of type " + temporal.getClass().getName(), ex);
        }
    }

    public static JalaliYear parse(CharSequence text) {
        return JalaliYear.parse(text, PARSER);
    }

    public static JalaliYear parse(CharSequence text, DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.parse(text, JalaliYear::from);
    }

    public static boolean isLeap(long year) {
        return year % 33L == 1L || year % 33L == 5L || year % 33L == 9L || year % 33L == 13L || year % 33L == 17L || year % 33L == 22L || year % 33L == 26L || year % 33L == 30L;
    }

    public int getValue() {
        return this.year;
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return field == ChronoField.YEAR || field == ChronoField.YEAR_OF_ERA || field == ChronoField.ERA;
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            return unit == ChronoUnit.YEARS || unit == ChronoUnit.DECADES || unit == ChronoUnit.CENTURIES || unit == ChronoUnit.MILLENNIA || unit == ChronoUnit.ERAS;
        }
        return unit != null && unit.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field == ChronoField.YEAR_OF_ERA) {
            return this.year <= 0 ? ValueRange.of(1L, 1000000000L) : ValueRange.of(1L, 999999999L);
        }
        return Temporal.super.range(field);
    }

    @Override
    public int get(TemporalField field) {
        return this.range(field).checkValidIntValue(this.getLong(field), field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            switch ((ChronoField)field) {
                case YEAR_OF_ERA: {
                    return this.year < 1 ? 1 - this.year : this.year;
                }
                case YEAR: {
                    return this.year;
                }
                case ERA: {
                    return this.year < 1 ? 0 : 1;
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return field.getFrom(this);
    }

    public boolean isLeap() {
        return JalaliYear.isLeap(this.year);
    }

    public boolean isValidMonthDay(JalaliMonthDay monthDay) {
        return monthDay != null && monthDay.isValidYear(this.year);
    }

    public int length() {
        return this.isLeap() ? 366 : 365;
    }

    @Override
    public JalaliYear with(TemporalAdjuster adjuster) {
        return (JalaliYear)adjuster.adjustInto(this);
    }

    @Override
    public JalaliYear with(TemporalField field, long newValue) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            f.checkValidValue(newValue);
            switch (f) {
                case YEAR_OF_ERA: {
                    return JalaliYear.of((int)(this.year < 1 ? 1L - newValue : newValue));
                }
                case YEAR: {
                    return JalaliYear.of((int)newValue);
                }
                case ERA: {
                    return this.getLong(ChronoField.ERA) == newValue ? this : JalaliYear.of(1 - this.year);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return field.adjustInto(this, newValue);
    }

    @Override
    public JalaliYear plus(TemporalAmount amountToAdd) {
        return (JalaliYear)amountToAdd.addTo(this);
    }

    @Override
    public JalaliYear plus(long amountToAdd, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            switch ((ChronoUnit)unit) {
                case YEARS: {
                    return this.plusYears(amountToAdd);
                }
                case DECADES: {
                    return this.plusYears(Math.multiplyExact(amountToAdd, 10L));
                }
                case CENTURIES: {
                    return this.plusYears(Math.multiplyExact(amountToAdd, 100L));
                }
                case MILLENNIA: {
                    return this.plusYears(Math.multiplyExact(amountToAdd, 1000L));
                }
                case ERAS: {
                    return this.with(ChronoField.ERA, Math.addExact(this.getLong(ChronoField.ERA), amountToAdd));
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
        }
        return unit.addTo(this, amountToAdd);
    }

    public JalaliYear plusYears(long yearsToAdd) {
        if (yearsToAdd == 0L) {
            return this;
        }
        return JalaliYear.of(ChronoField.YEAR.checkValidIntValue((long)this.year + yearsToAdd));
    }

    @Override
    public JalaliYear minus(TemporalAmount amountToSubtract) {
        return (JalaliYear)amountToSubtract.subtractFrom(this);
    }

    @Override
    public JalaliYear minus(long amountToSubtract, TemporalUnit unit) {
        return amountToSubtract == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, unit).plus(1L, unit) : this.plus(-amountToSubtract, unit);
    }

    public JalaliYear minusYears(long yearsToSubtract) {
        return yearsToSubtract == Long.MIN_VALUE ? this.plusYears(Long.MAX_VALUE).plusYears(1L) : this.plusYears(-yearsToSubtract);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.chronology()) {
            return (R)JalaliChronology.INSTANCE;
        }
        if (query == TemporalQueries.precision()) {
            return (R)ChronoUnit.YEARS;
        }
        return Temporal.super.query(query);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        if (!Chronology.from(temporal).equals(JalaliChronology.INSTANCE)) {
            throw new DateTimeException("Adjustment only supported on ISO date-time");
        }
        return temporal.with(ChronoField.YEAR, this.year);
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        JalaliYear end = JalaliYear.from(endExclusive);
        if (unit instanceof ChronoUnit) {
            long yearsUntil = (long)end.year - (long)this.year;
            switch ((ChronoUnit)unit) {
                case YEARS: {
                    return yearsUntil;
                }
                case DECADES: {
                    return yearsUntil / 10L;
                }
                case CENTURIES: {
                    return yearsUntil / 100L;
                }
                case MILLENNIA: {
                    return yearsUntil / 1000L;
                }
                case ERAS: {
                    return end.getLong(ChronoField.ERA) - this.getLong(ChronoField.ERA);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
        }
        return unit.between(this, end);
    }

    public String format(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.format(this);
    }

    public JalaliDate atDay(int dayOfYear) {
        return JalaliDate.ofYearDay(this.year, dayOfYear);
    }

    public JalaliYearMonth atMonth(JalaliMonth month) {
        return JalaliYearMonth.of(this.year, month);
    }

    public JalaliYearMonth atMonth(int month) {
        return JalaliYearMonth.of(this.year, month);
    }

    public JalaliDate atMonthDay(JalaliMonthDay monthDay) {
        return monthDay.atYear(this.year);
    }

    @Override
    public int compareTo(JalaliYear other) {
        return this.year - other.year;
    }

    public boolean isAfter(JalaliYear other) {
        return this.year > other.year;
    }

    public boolean isBefore(JalaliYear other) {
        return this.year < other.year;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JalaliYear) {
            return this.year == ((JalaliYear)obj).year;
        }
        return false;
    }

    public int hashCode() {
        return this.year;
    }

    public String toString() {
        return Integer.toString(this.year);
    }
}

