/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.time.format;

import java.time.chrono.Chronology;
import java.time.chrono.JapaneseChronology;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalField;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bardframework.time.JalaliChronology;
import org.bardframework.time.format.JalaliDateTimeFormatter;
import org.bardframework.time.format.TextStyle;

class DateTimeTextProvider {
    private static final ConcurrentMap<Map.Entry<TemporalField, Locale>, Object> CACHE = new ConcurrentHashMap<Map.Entry<TemporalField, Locale>, Object>(16, 0.75f, 2);
    private static final Comparator<Map.Entry<String, Long>> COMPARATOR = (obj1, obj2) -> ((String)obj2.getKey()).length() - ((String)obj1.getKey()).length();

    DateTimeTextProvider() {
    }

    static DateTimeTextProvider getInstance() {
        return new DateTimeTextProvider();
    }

    private static int toWeekDay(int calWeekDay) {
        if (calWeekDay == 1) {
            return 7;
        }
        return calWeekDay - 1;
    }

    private static <A, B> Map.Entry<A, B> createEntry(A text, B field) {
        return new AbstractMap.SimpleImmutableEntry<A, B>(text, field);
    }

    static <T> T getLocalizedResource(String key, Locale locale) {
        return null;
    }

    String getText(TemporalField field, long value, TextStyle style, Locale locale) {
        Object store = this.findStore(field, locale);
        if (store instanceof LocaleStore) {
            return ((LocaleStore)store).getText(value, style);
        }
        return null;
    }

    String getText(Chronology chrono, TemporalField field, long value, TextStyle style, Locale locale) {
        if (chrono == JalaliChronology.INSTANCE || !(field instanceof ChronoField)) {
            return this.getText(field, value, style, locale);
        }
        if (field == ChronoField.ERA) {
            boolean fieldIndex = false;
            if (chrono == JapaneseChronology.INSTANCE) {
                if (value == -999L) {
                    boolean fieldValue = false;
                } else {
                    int fieldValue = (int)value + 2;
                }
            } else {
                int fieldValue = (int)value;
            }
        } else if (field == ChronoField.MONTH_OF_YEAR) {
            int fieldIndex = 2;
            int fieldValue = (int)value - 1;
        } else if (field == ChronoField.DAY_OF_WEEK) {
            int fieldIndex = 7;
            int fieldValue = (int)value + 1;
            if (fieldValue > 7) {
                fieldValue = 1;
            }
        } else if (field == ChronoField.AMPM_OF_DAY) {
            int fieldIndex = 9;
            int fieldValue = (int)value;
        } else {
            return null;
        }
        if (field == ChronoField.MONTH_OF_YEAR) {
            return JalaliDateTimeFormatter.MONTH_OF_YEAR.get(value);
        }
        if (field == ChronoField.DAY_OF_WEEK) {
            return JalaliDateTimeFormatter.DAY_OF_WEEK.get(value);
        }
        if (field == ChronoField.AMPM_OF_DAY) {
            return JalaliDateTimeFormatter.AMPM_OF_DAY.get(value);
        }
        return null;
    }

    Iterator<Map.Entry<String, Long>> getTextIterator(TemporalField field, TextStyle style, Locale locale) {
        Object store = this.findStore(field, locale);
        if (store instanceof LocaleStore) {
            return ((LocaleStore)store).getTextIterator(style);
        }
        return null;
    }

    Iterator<Map.Entry<String, Long>> getTextIterator(Chronology chrono, TemporalField field, TextStyle style, Locale locale) {
        int fieldIndex;
        if (chrono == JalaliChronology.INSTANCE || !(field instanceof ChronoField)) {
            return this.getTextIterator(field, style, locale);
        }
        switch ((ChronoField)field) {
            case ERA: {
                fieldIndex = 0;
                break;
            }
            case MONTH_OF_YEAR: {
                fieldIndex = 2;
                break;
            }
            case DAY_OF_WEEK: {
                fieldIndex = 7;
                break;
            }
            case AMPM_OF_DAY: {
                fieldIndex = 9;
                break;
            }
            default: {
                return null;
            }
        }
        int calendarStyle = style == null ? 0 : style.toCalendarStyle();
        Map map = null;
        if (map == null) {
            return null;
        }
        ArrayList list = new ArrayList(map.size());
        switch (fieldIndex) {
            case 0: {
                for (Map.Entry entry : map.entrySet()) {
                    int era = (Integer)entry.getValue();
                    if (chrono == JapaneseChronology.INSTANCE) {
                        era = era == 0 ? -999 : (era -= 2);
                    }
                    list.add(DateTimeTextProvider.createEntry(entry.getKey(), Long.valueOf(era)));
                }
                break;
            }
            case 2: {
                for (Map.Entry entry : map.entrySet()) {
                    list.add(DateTimeTextProvider.createEntry(entry.getKey(), Long.valueOf((Integer)entry.getValue() + 1)));
                }
                break;
            }
            case 7: {
                for (Map.Entry entry : map.entrySet()) {
                    list.add(DateTimeTextProvider.createEntry(entry.getKey(), Long.valueOf(DateTimeTextProvider.toWeekDay((Integer)entry.getValue()))));
                }
                break;
            }
            default: {
                for (Map.Entry entry : map.entrySet()) {
                    list.add(DateTimeTextProvider.createEntry(entry.getKey(), Long.valueOf(((Integer)entry.getValue()).intValue())));
                }
            }
        }
        return list.iterator();
    }

    private Object findStore(TemporalField field, Locale locale) {
        Map.Entry<TemporalField, Locale> key = DateTimeTextProvider.createEntry(field, locale);
        Object store = CACHE.get(key);
        if (store == null) {
            store = this.createStore(field, locale);
            CACHE.putIfAbsent(key, store);
            store = CACHE.get(key);
        }
        return store;
    }

    private Object createStore(TemporalField field, Locale locale) {
        HashMap<TextStyle, Map<Long, String>> styleMap = new HashMap<TextStyle, Map<Long, String>>();
        if (field == ChronoField.ERA) {
            for (TextStyle textStyle : TextStyle.values()) {
                Map displayNames;
                if (textStyle.isStandalone() || (displayNames = null) == null) continue;
                HashMap map = new HashMap();
                for (Map.Entry entry : displayNames.entrySet()) {
                    map.put(Long.valueOf(((Integer)entry.getValue()).intValue()), entry.getKey());
                }
                if (map.isEmpty()) continue;
                styleMap.put(textStyle, map);
            }
            return new LocaleStore(styleMap);
        }
        if (field == ChronoField.MONTH_OF_YEAR) {
            for (TextStyle textStyle : TextStyle.values()) {
                HashMap<Long, String> map = new HashMap<Long, String>();
                for (Map.Entry<Long, String> entry : JalaliDateTimeFormatter.MONTH_OF_YEAR.entrySet()) {
                    map.put(entry.getKey(), entry.getValue());
                }
                styleMap.put(textStyle, map);
            }
            return new LocaleStore(styleMap);
        }
        if (field == ChronoField.DAY_OF_WEEK) {
            for (TextStyle textStyle : TextStyle.values()) {
                HashMap<Long, String> map = new HashMap<Long, String>();
                for (Map.Entry<Long, String> entry : JalaliDateTimeFormatter.DAY_OF_WEEK.entrySet()) {
                    map.put(entry.getKey(), entry.getValue());
                }
                styleMap.put(textStyle, map);
            }
            return new LocaleStore(styleMap);
        }
        if (field == ChronoField.AMPM_OF_DAY) {
            for (TextStyle textStyle : TextStyle.values()) {
                HashMap<Long, String> map = new HashMap<Long, String>();
                for (Map.Entry<Long, String> entry : JalaliDateTimeFormatter.AMPM_OF_DAY.entrySet()) {
                    map.put(entry.getKey(), entry.getValue());
                }
                styleMap.put(textStyle, map);
            }
            return new LocaleStore(styleMap);
        }
        if (field == IsoFields.QUARTER_OF_YEAR) {
            String[] keys = new String[]{"QuarterNames", "standalone.QuarterNames", "QuarterAbbreviations", "standalone.QuarterAbbreviations", "QuarterNarrows", "standalone.QuarterNarrows"};
            for (int i = 0; i < keys.length; ++i) {
                String[] names = (String[])DateTimeTextProvider.getLocalizedResource(keys[i], locale);
                if (names == null) continue;
                HashMap<Long, String> map = new HashMap<Long, String>();
                for (int q = 0; q < names.length; ++q) {
                    map.put(Long.valueOf(q + 1), names[q]);
                }
                styleMap.put(TextStyle.values()[i], map);
            }
            return new LocaleStore(styleMap);
        }
        return "";
    }

    static final class LocaleStore {
        private final Map<TextStyle, Map<Long, String>> valueTextMap;
        private final Map<TextStyle, List<Map.Entry<String, Long>>> parsable;

        LocaleStore(Map<TextStyle, Map<Long, String>> valueTextMap) {
            this.valueTextMap = valueTextMap;
            HashMap<TextStyle, List<Map.Entry<String, Long>>> map = new HashMap<TextStyle, List<Map.Entry<String, Long>>>();
            ArrayList allList = new ArrayList();
            for (Map.Entry<TextStyle, Map<Long, String>> vtmEntry : valueTextMap.entrySet()) {
                HashMap<String, Map.Entry> reverse = new HashMap<String, Map.Entry>();
                for (Map.Entry<Long, String> entry : vtmEntry.getValue().entrySet()) {
                    if (reverse.put(entry.getValue(), DateTimeTextProvider.createEntry(entry.getValue(), entry.getKey())) == null) continue;
                }
                ArrayList list = new ArrayList(reverse.values());
                list.sort(COMPARATOR);
                map.put(vtmEntry.getKey(), list);
                allList.addAll(list);
                map.put(null, allList);
            }
            allList.sort(COMPARATOR);
            this.parsable = map;
        }

        String getText(long value, TextStyle style) {
            Map<Long, String> map = this.valueTextMap.get((Object)style);
            return map != null ? map.get(value) : null;
        }

        Iterator<Map.Entry<String, Long>> getTextIterator(TextStyle style) {
            List<Map.Entry<String, Long>> list = this.parsable.get((Object)style);
            return list != null ? list.iterator() : null;
        }
    }
}

