/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.time.format;

import java.time.ZoneId;
import java.time.chrono.Chronology;
import java.time.format.ResolverStyle;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.bardframework.time.JalaliChronology;
import org.bardframework.time.format.DecimalStyle;
import org.bardframework.time.format.JalaliDateTimeFormatter;
import org.bardframework.time.format.Parsed;

final class JalaliDateTimeParseContext {
    private final ArrayList<Parsed> parsed = new ArrayList();
    private final JalaliDateTimeFormatter formatter;
    private boolean caseSensitive = true;
    private boolean strict = true;
    private ArrayList<Consumer<Chronology>> chronoListeners = null;

    JalaliDateTimeParseContext(JalaliDateTimeFormatter formatter) {
        this.formatter = formatter;
        this.parsed.add(new Parsed());
    }

    static boolean charEqualsIgnoreCase(char c1, char c2) {
        return c1 == c2 || Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2);
    }

    JalaliDateTimeParseContext copy() {
        JalaliDateTimeParseContext newContext = new JalaliDateTimeParseContext(this.formatter);
        newContext.caseSensitive = this.caseSensitive;
        newContext.strict = this.strict;
        return newContext;
    }

    Locale getLocale() {
        return this.formatter.getLocale();
    }

    DecimalStyle getDecimalStyle() {
        return this.formatter.getDecimalStyle();
    }

    Chronology getEffectiveChronology() {
        Chronology chrono = this.currentParsed().chrono;
        if (chrono == null && (chrono = this.formatter.getChronology()) == null) {
            chrono = JalaliChronology.INSTANCE;
        }
        return chrono;
    }

    boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    boolean subSequenceEquals(CharSequence cs1, int offset1, CharSequence cs2, int offset2, int length) {
        if (offset1 + length > cs1.length() || offset2 + length > cs2.length()) {
            return false;
        }
        if (this.isCaseSensitive()) {
            for (int i = 0; i < length; ++i) {
                char ch2;
                char ch1 = cs1.charAt(offset1 + i);
                if (ch1 == (ch2 = cs2.charAt(offset2 + i))) continue;
                return false;
            }
        } else {
            for (int i = 0; i < length; ++i) {
                char ch2;
                char ch1 = cs1.charAt(offset1 + i);
                if (ch1 == (ch2 = cs2.charAt(offset2 + i)) || Character.toUpperCase(ch1) == Character.toUpperCase(ch2) || Character.toLowerCase(ch1) == Character.toLowerCase(ch2)) continue;
                return false;
            }
        }
        return true;
    }

    boolean charEquals(char ch1, char ch2) {
        if (this.isCaseSensitive()) {
            return ch1 == ch2;
        }
        return JalaliDateTimeParseContext.charEqualsIgnoreCase(ch1, ch2);
    }

    boolean isStrict() {
        return this.strict;
    }

    void setStrict(boolean strict) {
        this.strict = strict;
    }

    void startOptional() {
        this.parsed.add(this.currentParsed().copy());
    }

    void endOptional(boolean successful) {
        if (successful) {
            this.parsed.remove(this.parsed.size() - 2);
        } else {
            this.parsed.remove(this.parsed.size() - 1);
        }
    }

    private Parsed currentParsed() {
        return this.parsed.get(this.parsed.size() - 1);
    }

    Parsed toUnresolved() {
        return this.currentParsed();
    }

    TemporalAccessor toResolved(ResolverStyle resolverStyle, Set<TemporalField> resolverFields) {
        Parsed parsed = this.currentParsed();
        parsed.chrono = this.getEffectiveChronology();
        parsed.zone = parsed.zone != null ? parsed.zone : this.formatter.getZone();
        return parsed.resolve(resolverStyle, resolverFields);
    }

    Long getParsed(TemporalField field) {
        return this.currentParsed().fieldValues.get(field);
    }

    int setParsedField(TemporalField field, long value, int errorPos, int successPos) {
        Objects.requireNonNull(field, "field");
        Long old = this.currentParsed().fieldValues.put(field, value);
        return old != null && old != value ? ~errorPos : successPos;
    }

    void setParsed(Chronology chrono) {
        Objects.requireNonNull(chrono, "chrono");
        this.currentParsed().chrono = chrono;
        if (this.chronoListeners != null && !this.chronoListeners.isEmpty()) {
            Consumer[] tmp = new Consumer[1];
            Consumer[] listeners = this.chronoListeners.toArray(tmp);
            this.chronoListeners.clear();
            for (Consumer l : listeners) {
                l.accept(chrono);
            }
        }
    }

    void addChronoChangedListener(Consumer<Chronology> listener) {
        if (this.chronoListeners == null) {
            this.chronoListeners = new ArrayList();
        }
        this.chronoListeners.add(listener);
    }

    void setParsed(ZoneId zone) {
        Objects.requireNonNull(zone, "zone");
        this.currentParsed().zone = zone;
    }

    void setParsedLeapSecond() {
        this.currentParsed().leapSecond = true;
    }

    public String toString() {
        return this.currentParsed().toString();
    }
}

