/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.List;
import java.util.Objects;
import org.bardframework.time.LocalDateJalali;
import org.bardframework.time.LocalDateTimeJalali;
import org.bardframework.time.MonthJalali;
import org.bardframework.time.OffsetDateTimeJalali;
import org.bardframework.time.zone.ZoneOffsetTransition;
import org.bardframework.time.zone.ZoneRules;
import org.bardframework.time.zone.ZoneUtils;

public final class ZonedDateTimeJalali
implements Temporal,
ChronoZonedDateTime<LocalDateJalali>,
Serializable {
    private static final long serialVersionUID = -6260982410461394882L;
    private final LocalDateTimeJalali dateTime;
    private final ZoneOffset offset;
    private final ZoneId zone;

    private ZonedDateTimeJalali(LocalDateTimeJalali dateTime, ZoneOffset offset, ZoneId zone) {
        this.dateTime = dateTime;
        this.offset = offset;
        this.zone = zone;
    }

    public static ZonedDateTimeJalali now() {
        return ZonedDateTimeJalali.now(Clock.systemDefaultZone());
    }

    public static ZonedDateTimeJalali now(ZoneId zone) {
        return ZonedDateTimeJalali.now(Clock.system(zone));
    }

    public static ZonedDateTimeJalali now(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        Instant now = clock.instant();
        return ZonedDateTimeJalali.ofInstant(now, clock.getZone());
    }

    public static ZonedDateTimeJalali of(LocalDateJalali date, LocalTime time, ZoneId zone) {
        return ZonedDateTimeJalali.of(LocalDateTimeJalali.of(date, time), zone);
    }

    public static ZonedDateTimeJalali of(LocalDateTimeJalali localDateTime, ZoneId zone) {
        return ZonedDateTimeJalali.ofLocal(localDateTime, zone, null);
    }

    public static ZonedDateTimeJalali of(int year, int month, int dayOfMonth, int hour, int minute, int second, int nanoOfSecond, ZoneId zone) {
        LocalDateTimeJalali dt = LocalDateTimeJalali.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond);
        return ZonedDateTimeJalali.ofLocal(dt, zone, null);
    }

    public static ZonedDateTimeJalali ofLocal(LocalDateTimeJalali localDateTime, ZoneId zone, ZoneOffset preferredOffset) {
        ZoneOffset offset;
        Objects.requireNonNull(localDateTime, "localDateTime");
        Objects.requireNonNull(zone, "zone");
        if (zone instanceof ZoneOffset) {
            return new ZonedDateTimeJalali(localDateTime, (ZoneOffset)zone, zone);
        }
        ZoneRules rules = ZoneUtils.getRules(zone);
        List<ZoneOffset> validOffsets = rules.getValidOffsets(localDateTime);
        if (validOffsets.size() == 1) {
            offset = validOffsets.get(0);
        } else if (validOffsets.size() == 0) {
            ZoneOffsetTransition trans = rules.getTransition(localDateTime);
            localDateTime = localDateTime.plusSeconds(Objects.requireNonNull(trans).getDuration().getSeconds());
            offset = trans.getOffsetAfter();
        } else {
            offset = preferredOffset != null && validOffsets.contains(preferredOffset) ? preferredOffset : Objects.requireNonNull(validOffsets.get(0), "offset");
        }
        return new ZonedDateTimeJalali(localDateTime, offset, zone);
    }

    public static ZonedDateTimeJalali ofInstant(Instant instant, ZoneId zone) {
        Objects.requireNonNull(instant, "instant");
        Objects.requireNonNull(zone, "zone");
        return ZonedDateTimeJalali.create(instant.getEpochSecond(), instant.getNano(), zone);
    }

    public static ZonedDateTimeJalali ofInstant(LocalDateTimeJalali localDateTime, ZoneOffset offset, ZoneId zone) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        Objects.requireNonNull(offset, "offset");
        Objects.requireNonNull(zone, "zone");
        if (ZoneUtils.getRules(zone).isValidOffset(localDateTime, offset)) {
            return new ZonedDateTimeJalali(localDateTime, offset, zone);
        }
        return ZonedDateTimeJalali.create(localDateTime.toEpochSecond(offset), localDateTime.getNano(), zone);
    }

    private static ZonedDateTimeJalali create(long epochSecond, int nanoOfSecond, ZoneId zone) {
        ZoneRules rules = ZoneUtils.getRules(zone);
        Instant instant = Instant.ofEpochSecond(epochSecond, nanoOfSecond);
        ZoneOffset offset = rules.getOffset(instant);
        LocalDateTimeJalali ldt = LocalDateTimeJalali.ofEpochSecond(epochSecond, nanoOfSecond, offset);
        return new ZonedDateTimeJalali(ldt, offset, zone);
    }

    public static ZonedDateTimeJalali ofStrict(LocalDateTimeJalali localDateTime, ZoneOffset offset, ZoneId zone) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        Objects.requireNonNull(offset, "offset");
        Objects.requireNonNull(zone, "zone");
        ZoneRules rules = ZoneUtils.getRules(zone);
        if (!rules.isValidOffset(localDateTime, offset)) {
            ZoneOffsetTransition trans = rules.getTransition(localDateTime);
            if (trans != null && trans.isGap()) {
                throw new DateTimeException("LocalDateTimeJalali '" + localDateTime + "' does not exist in zone '" + zone + "' due to a gap in the local time-line, typically caused by daylight savings");
            }
            throw new DateTimeException("ZoneOffset '" + offset + "' is not valid for LocalDateTimeJalali '" + localDateTime + "' in zone '" + zone + "'");
        }
        return new ZonedDateTimeJalali(localDateTime, offset, zone);
    }

    private static ZonedDateTimeJalali ofLenient(LocalDateTimeJalali localDateTime, ZoneOffset offset, ZoneId zone) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        Objects.requireNonNull(offset, "offset");
        Objects.requireNonNull(zone, "zone");
        if (zone instanceof ZoneOffset && !offset.equals(zone)) {
            throw new IllegalArgumentException("ZoneId must match ZoneOffset");
        }
        return new ZonedDateTimeJalali(localDateTime, offset, zone);
    }

    public static ZonedDateTimeJalali from(TemporalAccessor temporal) {
        if (temporal instanceof ZonedDateTimeJalali) {
            return (ZonedDateTimeJalali)temporal;
        }
        try {
            ZoneId zone = ZoneId.from(temporal);
            if (temporal.isSupported(ChronoField.INSTANT_SECONDS)) {
                long epochSecond = temporal.getLong(ChronoField.INSTANT_SECONDS);
                int nanoOfSecond = temporal.get(ChronoField.NANO_OF_SECOND);
                return ZonedDateTimeJalali.create(epochSecond, nanoOfSecond, zone);
            }
            LocalDateJalali date = LocalDateJalali.from(temporal);
            LocalTime time = LocalTime.from(temporal);
            return ZonedDateTimeJalali.of(date, time, zone);
        }
        catch (DateTimeException ex) {
            throw new DateTimeException("Unable to obtain ZonedDateTime from TemporalAccessor: " + temporal + " of type " + temporal.getClass().getName(), ex);
        }
    }

    public static ZonedDateTimeJalali parse(CharSequence text) {
        return ZonedDateTimeJalali.parse(text, DateTimeFormatter.ISO_ZONED_DATE_TIME);
    }

    public static ZonedDateTimeJalali parse(CharSequence text, DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.parse(text, ZonedDateTimeJalali::from);
    }

    private ZonedDateTimeJalali resolveLocal(LocalDateTimeJalali newDateTime) {
        return ZonedDateTimeJalali.ofLocal(newDateTime, this.zone, this.offset);
    }

    private ZonedDateTimeJalali resolveInstant(LocalDateTimeJalali newDateTime) {
        return ZonedDateTimeJalali.ofInstant(newDateTime, this.offset, this.zone);
    }

    private ZonedDateTimeJalali resolveOffset(ZoneOffset offset) {
        if (!offset.equals(this.offset) && ZoneUtils.getRules(this.zone).isValidOffset(this.dateTime, offset)) {
            return new ZonedDateTimeJalali(this.dateTime, offset, this.zone);
        }
        return this;
    }

    @Override
    public boolean isSupported(TemporalField field) {
        return field instanceof ChronoField || field != null && field.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(TemporalUnit unit) {
        return ChronoZonedDateTime.super.isSupported(unit);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field instanceof ChronoField) {
            if (field == ChronoField.INSTANT_SECONDS || field == ChronoField.OFFSET_SECONDS) {
                return field.range();
            }
            return this.dateTime.range(field);
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField field) {
        if (field instanceof ChronoField) {
            switch ((ChronoField)field) {
                case INSTANT_SECONDS: {
                    throw new UnsupportedTemporalTypeException("Invalid field 'InstantSeconds' for get() method, use getLong() instead");
                }
                case OFFSET_SECONDS: {
                    return this.getOffset().getTotalSeconds();
                }
            }
            return this.dateTime.get(field);
        }
        return ChronoZonedDateTime.super.get(field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            switch ((ChronoField)field) {
                case INSTANT_SECONDS: {
                    return this.toEpochSecond();
                }
                case OFFSET_SECONDS: {
                    return this.getOffset().getTotalSeconds();
                }
            }
            return this.dateTime.getLong(field);
        }
        return field.getFrom(this);
    }

    @Override
    public ZoneOffset getOffset() {
        return this.offset;
    }

    public ZonedDateTimeJalali withEarlierOffsetAtOverlap() {
        ZoneOffset earlierOffset;
        ZoneOffsetTransition trans = ZoneUtils.getRules(this.getZone()).getTransition(this.dateTime);
        if (trans != null && trans.isOverlap() && !(earlierOffset = trans.getOffsetBefore()).equals(this.offset)) {
            return new ZonedDateTimeJalali(this.dateTime, earlierOffset, this.zone);
        }
        return this;
    }

    public ZonedDateTimeJalali withLaterOffsetAtOverlap() {
        ZoneOffset laterOffset;
        ZoneOffsetTransition trans = ZoneUtils.getRules(this.zone).getTransition(this.toLocalDateTime());
        if (trans != null && !(laterOffset = trans.getOffsetAfter()).equals(this.offset)) {
            return new ZonedDateTimeJalali(this.dateTime, laterOffset, this.zone);
        }
        return this;
    }

    @Override
    public ZoneId getZone() {
        return this.zone;
    }

    public ZonedDateTimeJalali withZoneSameLocal(ZoneId zone) {
        Objects.requireNonNull(zone, "zone");
        return this.zone.equals(zone) ? this : ZonedDateTimeJalali.ofLocal(this.dateTime, zone, this.offset);
    }

    public ZonedDateTimeJalali withZoneSameInstant(ZoneId zone) {
        Objects.requireNonNull(zone, "zone");
        return this.zone.equals(zone) ? this : ZonedDateTimeJalali.create(this.dateTime.toEpochSecond(this.offset), this.dateTime.getNano(), zone);
    }

    public ZonedDateTimeJalali withFixedOffsetZone() {
        return this.zone.equals(this.offset) ? this : new ZonedDateTimeJalali(this.dateTime, this.offset, this.offset);
    }

    public LocalDateTimeJalali toLocalDateTime() {
        return this.dateTime;
    }

    @Override
    public LocalDateJalali toLocalDate() {
        return this.dateTime.toLocalDate();
    }

    public int getYear() {
        return this.dateTime.getYear();
    }

    public int getMonthValue() {
        return this.dateTime.getMonthValue();
    }

    public MonthJalali getMonth() {
        return this.dateTime.getMonth();
    }

    public int getDayOfMonth() {
        return this.dateTime.getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.dateTime.getDayOfYear();
    }

    public DayOfWeek getDayOfWeek() {
        return this.dateTime.getDayOfWeek();
    }

    @Override
    public LocalTime toLocalTime() {
        return this.dateTime.toLocalTime();
    }

    public int getHour() {
        return this.dateTime.getHour();
    }

    public int getMinute() {
        return this.dateTime.getMinute();
    }

    public int getSecond() {
        return this.dateTime.getSecond();
    }

    public int getNano() {
        return this.dateTime.getNano();
    }

    @Override
    public ZonedDateTimeJalali with(TemporalAdjuster adjuster) {
        if (adjuster instanceof LocalDateJalali) {
            return this.resolveLocal(LocalDateTimeJalali.of((LocalDateJalali)adjuster, this.dateTime.toLocalTime()));
        }
        if (adjuster instanceof LocalTime) {
            return this.resolveLocal(LocalDateTimeJalali.of(this.dateTime.toLocalDate(), (LocalTime)adjuster));
        }
        if (adjuster instanceof LocalDateTimeJalali) {
            return this.resolveLocal((LocalDateTimeJalali)adjuster);
        }
        if (adjuster instanceof OffsetDateTimeJalali) {
            OffsetDateTimeJalali odt = (OffsetDateTimeJalali)adjuster;
            return ZonedDateTimeJalali.ofLocal(odt.toLocalDateTimeJalali(), this.zone, odt.getOffset());
        }
        if (adjuster instanceof Instant) {
            Instant instant = (Instant)adjuster;
            return ZonedDateTimeJalali.create(instant.getEpochSecond(), instant.getNano(), this.zone);
        }
        if (adjuster instanceof ZoneOffset) {
            return this.resolveOffset((ZoneOffset)adjuster);
        }
        return (ZonedDateTimeJalali)adjuster.adjustInto(this);
    }

    @Override
    public ZonedDateTimeJalali with(TemporalField field, long newValue) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            switch (f) {
                case INSTANT_SECONDS: {
                    return ZonedDateTimeJalali.create(newValue, this.getNano(), this.zone);
                }
                case OFFSET_SECONDS: {
                    ZoneOffset offset = ZoneOffset.ofTotalSeconds(f.checkValidIntValue(newValue));
                    return this.resolveOffset(offset);
                }
            }
            return this.resolveLocal(this.dateTime.with(field, newValue));
        }
        return field.adjustInto(this, newValue);
    }

    public ZonedDateTimeJalali withYear(int year) {
        return this.resolveLocal(this.dateTime.withYear(year));
    }

    public ZonedDateTimeJalali withMonth(int month) {
        return this.resolveLocal(this.dateTime.withMonth(month));
    }

    public ZonedDateTimeJalali withDayOfMonth(int dayOfMonth) {
        return this.resolveLocal(this.dateTime.withDayOfMonth(dayOfMonth));
    }

    public ZonedDateTimeJalali withDayOfYear(int dayOfYear) {
        return this.resolveLocal(this.dateTime.withDayOfYear(dayOfYear));
    }

    public ZonedDateTimeJalali withHour(int hour) {
        return this.resolveLocal(this.dateTime.withHour(hour));
    }

    public ZonedDateTimeJalali withMinute(int minute) {
        return this.resolveLocal(this.dateTime.withMinute(minute));
    }

    public ZonedDateTimeJalali withSecond(int second) {
        return this.resolveLocal(this.dateTime.withSecond(second));
    }

    public ZonedDateTimeJalali withNano(int nanoOfSecond) {
        return this.resolveLocal(this.dateTime.withNano(nanoOfSecond));
    }

    public ZonedDateTimeJalali truncatedTo(TemporalUnit unit) {
        return this.resolveLocal(this.dateTime.truncatedTo(unit));
    }

    @Override
    public ZonedDateTimeJalali plus(TemporalAmount amountToAdd) {
        if (amountToAdd instanceof Period) {
            Period periodToAdd = (Period)amountToAdd;
            return this.resolveLocal(this.dateTime.plus(periodToAdd));
        }
        Objects.requireNonNull(amountToAdd, "amountToAdd");
        return (ZonedDateTimeJalali)amountToAdd.addTo(this);
    }

    @Override
    public ZonedDateTimeJalali plus(long amountToAdd, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            if (unit.isDateBased()) {
                return this.resolveLocal(this.dateTime.plus(amountToAdd, unit));
            }
            return this.resolveInstant(this.dateTime.plus(amountToAdd, unit));
        }
        return unit.addTo(this, amountToAdd);
    }

    public ZonedDateTimeJalali plusYears(long years) {
        return this.resolveLocal(this.dateTime.plusYears(years));
    }

    public ZonedDateTimeJalali plusMonths(long months) {
        return this.resolveLocal(this.dateTime.plusMonths(months));
    }

    public ZonedDateTimeJalali plusWeeks(long weeks) {
        return this.resolveLocal(this.dateTime.plusWeeks(weeks));
    }

    public ZonedDateTimeJalali plusDays(long days) {
        return this.resolveLocal(this.dateTime.plusDays(days));
    }

    public ZonedDateTimeJalali plusHours(long hours) {
        return this.resolveInstant(this.dateTime.plusHours(hours));
    }

    public ZonedDateTimeJalali plusMinutes(long minutes) {
        return this.resolveInstant(this.dateTime.plusMinutes(minutes));
    }

    public ZonedDateTimeJalali plusSeconds(long seconds) {
        return this.resolveInstant(this.dateTime.plusSeconds(seconds));
    }

    public ZonedDateTimeJalali plusNanos(long nanos) {
        return this.resolveInstant(this.dateTime.plusNanos(nanos));
    }

    @Override
    public ZonedDateTimeJalali minus(TemporalAmount amountToSubtract) {
        if (amountToSubtract instanceof Period) {
            Period periodToSubtract = (Period)amountToSubtract;
            return this.resolveLocal(this.dateTime.minus(periodToSubtract));
        }
        Objects.requireNonNull(amountToSubtract, "amountToSubtract");
        return (ZonedDateTimeJalali)amountToSubtract.subtractFrom(this);
    }

    @Override
    public ZonedDateTimeJalali minus(long amountToSubtract, TemporalUnit unit) {
        return amountToSubtract == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, unit).plus(1L, unit) : this.plus(-amountToSubtract, unit);
    }

    public ZonedDateTimeJalali minusYears(long years) {
        return years == Long.MIN_VALUE ? this.plusYears(Long.MAX_VALUE).plusYears(1L) : this.plusYears(-years);
    }

    public ZonedDateTimeJalali minusMonths(long months) {
        return months == Long.MIN_VALUE ? this.plusMonths(Long.MAX_VALUE).plusMonths(1L) : this.plusMonths(-months);
    }

    public ZonedDateTimeJalali minusWeeks(long weeks) {
        return weeks == Long.MIN_VALUE ? this.plusWeeks(Long.MAX_VALUE).plusWeeks(1L) : this.plusWeeks(-weeks);
    }

    public ZonedDateTimeJalali minusDays(long days) {
        return days == Long.MIN_VALUE ? this.plusDays(Long.MAX_VALUE).plusDays(1L) : this.plusDays(-days);
    }

    public ZonedDateTimeJalali minusHours(long hours) {
        return hours == Long.MIN_VALUE ? this.plusHours(Long.MAX_VALUE).plusHours(1L) : this.plusHours(-hours);
    }

    public ZonedDateTimeJalali minusMinutes(long minutes) {
        return minutes == Long.MIN_VALUE ? this.plusMinutes(Long.MAX_VALUE).plusMinutes(1L) : this.plusMinutes(-minutes);
    }

    public ZonedDateTimeJalali minusSeconds(long seconds) {
        return seconds == Long.MIN_VALUE ? this.plusSeconds(Long.MAX_VALUE).plusSeconds(1L) : this.plusSeconds(-seconds);
    }

    public ZonedDateTimeJalali minusNanos(long nanos) {
        return nanos == Long.MIN_VALUE ? this.plusNanos(Long.MAX_VALUE).plusNanos(1L) : this.plusNanos(-nanos);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.localDate()) {
            return (R)this.toLocalDate();
        }
        return ChronoZonedDateTime.super.query(query);
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        ZonedDateTimeJalali end = ZonedDateTimeJalali.from(endExclusive);
        if (unit instanceof ChronoUnit) {
            ZonedDateTimeJalali start = this;
            try {
                end = end.withZoneSameInstant(this.zone);
            }
            catch (DateTimeException ex) {
                start = this.withZoneSameInstant(end.zone);
            }
            if (unit.isDateBased()) {
                return start.dateTime.until(end.dateTime, unit);
            }
            return start.toOffsetDateTime().until(end.toOffsetDateTime(), unit);
        }
        return unit.between(this, end);
    }

    @Override
    public String format(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.format(this);
    }

    public OffsetDateTimeJalali toOffsetDateTime() {
        return OffsetDateTimeJalali.of(this.dateTime, this.offset);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ZonedDateTimeJalali) {
            ZonedDateTimeJalali other = (ZonedDateTimeJalali)obj;
            return this.dateTime.equals(other.dateTime) && this.offset.equals(other.offset) && this.zone.equals(other.zone);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.dateTime.hashCode() ^ this.offset.hashCode() ^ Integer.rotateLeft(this.zone.hashCode(), 3);
    }

    @Override
    public String toString() {
        String str = this.dateTime.toString() + this.offset.toString();
        if (this.offset != this.zone) {
            str = str + "[" + this.zone.toString() + "]";
        }
        return str;
    }
}

