/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.Period;
import java.time.ZoneId;
import java.time.chrono.AbstractChronology;
import java.time.chrono.Era;
import java.time.chrono.IsoEra;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.ValueRange;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bardframework.time.LocalDateJalali;
import org.bardframework.time.LocalDateTimeJalali;
import org.bardframework.time.YearJalali;
import org.bardframework.time.ZonedDateTimeJalali;

public final class ChronologyJalali
extends AbstractChronology
implements Serializable {
    public static final ChronologyJalali INSTANCE = new ChronologyJalali();
    private static final long serialVersionUID = -1440403870442975015L;

    private ChronologyJalali() {
    }

    @Override
    public String getId() {
        return "JALALI";
    }

    @Override
    public String getCalendarType() {
        return "jalali";
    }

    @Override
    public LocalDateJalali date(Era era, int yearOfEra, int month, int dayOfMonth) throws DateTimeException {
        return this.date(this.prolepticYear(era, yearOfEra), month, dayOfMonth);
    }

    @Override
    public LocalDateJalali date(int prolepticYear, int month, int dayOfMonth) {
        return LocalDateJalali.of(prolepticYear, month, dayOfMonth);
    }

    @Override
    public LocalDateJalali dateYearDay(Era era, int yearOfEra, int dayOfYear) {
        return this.dateYearDay(this.prolepticYear(era, yearOfEra), dayOfYear);
    }

    @Override
    public LocalDateJalali dateYearDay(int prolepticYear, int dayOfYear) {
        return LocalDateJalali.ofYearDay(prolepticYear, dayOfYear);
    }

    @Override
    public LocalDateJalali dateEpochDay(long epochDay) {
        return LocalDateJalali.ofEpochDay(epochDay);
    }

    @Override
    public LocalDateJalali date(TemporalAccessor temporal) {
        return LocalDateJalali.from(temporal);
    }

    public LocalDateTimeJalali localDateTime(TemporalAccessor temporal) {
        return LocalDateTimeJalali.from(temporal);
    }

    public ZonedDateTimeJalali zonedDateTime(TemporalAccessor temporal) throws DateTimeException {
        return ZonedDateTimeJalali.from(temporal);
    }

    public ZonedDateTimeJalali zonedDateTime(Instant instant, ZoneId zone) {
        return ZonedDateTimeJalali.ofInstant(instant, zone);
    }

    @Override
    public LocalDateJalali dateNow() {
        return this.dateNow(Clock.systemDefaultZone());
    }

    @Override
    public LocalDateJalali dateNow(ZoneId zone) {
        return this.dateNow(Clock.system(zone));
    }

    @Override
    public LocalDateJalali dateNow(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        return this.date(LocalDateJalali.now(clock));
    }

    @Override
    public boolean isLeapYear(long prolepticYear) {
        return YearJalali.isLeap(prolepticYear);
    }

    @Override
    public int prolepticYear(Era era, int yearOfEra) {
        if (!(era instanceof IsoEra)) {
            throw new ClassCastException("Era must be IsoEra");
        }
        return era == IsoEra.CE ? yearOfEra : 1 - yearOfEra;
    }

    @Override
    public IsoEra eraOf(int eraValue) {
        return IsoEra.of(eraValue);
    }

    @Override
    public List<Era> eras() {
        return List.of(IsoEra.values());
    }

    @Override
    public LocalDateJalali resolveDate(Map<TemporalField, Long> fieldValues, ResolverStyle resolverStyle) {
        return (LocalDateJalali)super.resolveDate(fieldValues, resolverStyle);
    }

    @Override
    public ValueRange range(ChronoField field) {
        return field.range();
    }

    @Override
    public Period period(int years, int months, int days) {
        return Period.of(years, months, days);
    }
}

