/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.time;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Locale;
import org.bardframework.time.ChronologyJalali;

public enum MonthJalali implements TemporalAccessor,
TemporalAdjuster
{
    FARVARDIN,
    ORDIBEHESHT,
    KHORDAD,
    TIR,
    MORDAD,
    SHAHRIVAR,
    MEHR,
    ABAN,
    AZAR,
    DEY,
    BAHMAN,
    ESFAND;

    private static final MonthJalali[] ENUMS;

    public static MonthJalali of(int month) {
        if (month < 1 || month > 12) {
            throw new DateTimeException("Invalid value for MonthOfYear: " + month);
        }
        return ENUMS[month - 1];
    }

    public static MonthJalali from(TemporalAccessor temporal) {
        if (temporal instanceof MonthJalali) {
            return (MonthJalali)temporal;
        }
        try {
            if (!ChronologyJalali.INSTANCE.equals(Chronology.from(temporal))) {
                temporal = LocalDate.from(temporal);
            }
            return MonthJalali.of(temporal.get(ChronoField.MONTH_OF_YEAR));
        }
        catch (DateTimeException ex) {
            throw new DateTimeException("Unable to obtain JalaliMonth from TemporalAccessor: " + temporal + " of type " + temporal.getClass().getName(), ex);
        }
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    public String getDisplayName(TextStyle style, Locale locale) {
        return new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField.MONTH_OF_YEAR, style).toFormatter(locale).format(this);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return field == ChronoField.MONTH_OF_YEAR;
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field == ChronoField.MONTH_OF_YEAR) {
            return field.range();
        }
        return TemporalAccessor.super.range(field);
    }

    @Override
    public int get(TemporalField field) {
        if (field == ChronoField.MONTH_OF_YEAR) {
            return this.getValue();
        }
        return TemporalAccessor.super.get(field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field == ChronoField.MONTH_OF_YEAR) {
            return this.getValue();
        }
        if (field instanceof ChronoField) {
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return field.getFrom(this);
    }

    public MonthJalali plus(long months) {
        int amount = (int)(months % 12L);
        return ENUMS[(this.ordinal() + (amount + 12)) % 12];
    }

    public MonthJalali minus(long months) {
        return this.plus(-(months % 12L));
    }

    public int length(boolean leapYear) {
        switch (this) {
            case FARVARDIN: 
            case ORDIBEHESHT: 
            case KHORDAD: 
            case TIR: 
            case MORDAD: 
            case SHAHRIVAR: {
                return 31;
            }
            case MEHR: 
            case ABAN: 
            case AZAR: 
            case DEY: 
            case BAHMAN: {
                return 30;
            }
        }
        return leapYear ? 30 : 29;
    }

    public int minLength() {
        switch (this) {
            case FARVARDIN: 
            case ORDIBEHESHT: 
            case KHORDAD: 
            case TIR: 
            case MORDAD: 
            case SHAHRIVAR: {
                return 31;
            }
            case MEHR: 
            case ABAN: 
            case AZAR: 
            case DEY: 
            case BAHMAN: {
                return 30;
            }
        }
        return 29;
    }

    public int maxLength() {
        switch (this) {
            case FARVARDIN: 
            case ORDIBEHESHT: 
            case KHORDAD: 
            case TIR: 
            case MORDAD: 
            case SHAHRIVAR: {
                return 31;
            }
        }
        return 30;
    }

    public int firstDayOfYear(boolean leapYear) {
        boolean leap = leapYear;
        switch (this) {
            case FARVARDIN: {
                return 1;
            }
            case ORDIBEHESHT: {
                return 32;
            }
            case KHORDAD: {
                return 63;
            }
            case TIR: {
                return 94;
            }
            case MORDAD: {
                return 125;
            }
            case SHAHRIVAR: {
                return 156;
            }
            case MEHR: {
                return 187;
            }
            case ABAN: {
                return 217;
            }
            case AZAR: {
                return 247;
            }
            case DEY: {
                return 277;
            }
            case BAHMAN: {
                return 307;
            }
        }
        return 337;
    }

    public MonthJalali firstMonthOfQuarter() {
        return ENUMS[this.ordinal() / 3 * 3];
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.chronology()) {
            return (R)ChronologyJalali.INSTANCE;
        }
        if (query == TemporalQueries.precision()) {
            return (R)ChronoUnit.MONTHS;
        }
        return TemporalAccessor.super.query(query);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        if (!Chronology.from(temporal).equals(ChronologyJalali.INSTANCE)) {
            throw new DateTimeException("Adjustment only supported on ISO date-time");
        }
        return temporal.with(ChronoField.MONTH_OF_YEAR, this.getValue());
    }

    static {
        ENUMS = MonthJalali.values();
    }
}

