/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.time.format;

import java.io.IOException;
import java.text.ParsePosition;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.chrono.Chronology;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQuery;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.bardframework.time.ChronologyJalali;
import org.bardframework.time.format.DateTimeFormatterBuilderJalali;
import org.bardframework.time.format.DateTimeParseContextJalali;
import org.bardframework.time.format.DateTimePrintContextJalali;
import org.bardframework.time.format.DecimalStyle;
import org.bardframework.time.format.Parsed;
import org.bardframework.time.format.SignStyle;

public final class DateTimeFormatterJalali {
    public static final DateTimeFormatterJalali ISO_LOCAL_DATE;
    public static final DateTimeFormatterJalali RFC_1123_DATE_TIME;
    public static final DateTimeFormatterJalali ISO_OFFSET_DATE;
    public static final DateTimeFormatterJalali ISO_DATE;
    public static final DateTimeFormatterJalali ISO_LOCAL_TIME;
    public static final DateTimeFormatterJalali ISO_OFFSET_TIME;
    public static final DateTimeFormatterJalali ISO_TIME;
    public static final DateTimeFormatterJalali ISO_LOCAL_DATE_TIME;
    public static final DateTimeFormatterJalali ISO_OFFSET_DATE_TIME;
    public static final DateTimeFormatterJalali ISO_ZONED_DATE_TIME;
    public static final DateTimeFormatterJalali ISO_DATE_TIME;
    public static final DateTimeFormatterJalali ISO_ORDINAL_DATE;
    public static final DateTimeFormatterJalali ISO_WEEK_DATE;
    public static final DateTimeFormatterJalali ISO_INSTANT;
    public static final DateTimeFormatterJalali BASIC_ISO_DATE;
    private static final Locale LOCALE_FA;
    private static final Locale LOCALE_EN;
    private static final Map<Locale, Map<Long, String>> DAY_OF_WEEK;
    private static final Map<Locale, Map<Long, String>> MONTH_OF_YEAR;
    private static final Map<Locale, Map<Long, String>> AMPM_OF_DAY;
    private static final TemporalQuery<Boolean> PARSED_LEAP_SECOND;
    private final DateTimeFormatterBuilderJalali.CompositePrinterParser printerParser;
    private final Locale locale;
    private final DecimalStyle decimalStyle;
    private final ResolverStyle resolverStyle;
    private final Set<TemporalField> resolverFields;
    private final Chronology chrono;
    private final ZoneId zone;

    DateTimeFormatterJalali(DateTimeFormatterBuilderJalali.CompositePrinterParser printerParser, Locale locale, DecimalStyle decimalStyle, ResolverStyle resolverStyle, Set<TemporalField> resolverFields, Chronology chrono, ZoneId zone) {
        this.printerParser = Objects.requireNonNull(printerParser, "printerParser");
        this.resolverFields = resolverFields;
        this.locale = Objects.requireNonNull(locale, "locale");
        this.decimalStyle = Objects.requireNonNull(decimalStyle, "decimalStyle");
        this.resolverStyle = Objects.requireNonNull(resolverStyle, "resolverStyle");
        this.chrono = chrono;
        this.zone = zone;
    }

    public static DateTimeFormatterJalali ofPattern(String pattern) {
        return new DateTimeFormatterBuilderJalali().appendPattern(pattern).toFormatter();
    }

    public static TemporalQuery<Boolean> parsedLeapSecond() {
        return PARSED_LEAP_SECOND;
    }

    static String retrieveJavaTimeFieldValueName(int field, long value, int style, Locale locale) {
        if (field == 2) {
            return DateTimeFormatterJalali.getMonthOfYear(locale).get(value);
        }
        if (field == 7) {
            return DateTimeFormatterJalali.getDayOfWeek(locale).get(value);
        }
        if (field == 9) {
            return DateTimeFormatterJalali.getAmPm(locale).get(value);
        }
        return null;
    }

    public static Map<Long, String> getDayOfWeek(Locale locale) {
        locale = locale.getLanguage().startsWith("fa") ? LOCALE_FA : LOCALE_EN;
        return DAY_OF_WEEK.get(locale);
    }

    public static Map<Long, String> getAmPm(Locale locale) {
        locale = locale.getLanguage().startsWith("fa") ? LOCALE_FA : LOCALE_EN;
        return AMPM_OF_DAY.get(locale);
    }

    public static Map<Long, String> getMonthOfYear(Locale locale) {
        locale = locale.getLanguage().startsWith("fa") ? LOCALE_FA : LOCALE_EN;
        return MONTH_OF_YEAR.get(locale);
    }

    public DateTimeFormatterJalali withLocale(Locale locale) {
        if (this.locale.equals(locale)) {
            return this;
        }
        return new DateTimeFormatterJalali(this.printerParser, locale, this.decimalStyle, this.resolverStyle, this.resolverFields, this.chrono, this.zone);
    }

    public DateTimeFormatterJalali withDecimalStyle(DecimalStyle decimalStyle) {
        if (this.decimalStyle.equals(decimalStyle)) {
            return this;
        }
        return new DateTimeFormatterJalali(this.printerParser, this.locale, decimalStyle, this.resolverStyle, this.resolverFields, this.chrono, this.zone);
    }

    public Chronology getChronology() {
        return this.chrono;
    }

    public DateTimeFormatterJalali withChronology(Chronology chrono) {
        if (Objects.equals(this.chrono, chrono)) {
            return this;
        }
        return new DateTimeFormatterJalali(this.printerParser, this.locale, this.decimalStyle, this.resolverStyle, this.resolverFields, chrono, this.zone);
    }

    public DateTimeFormatterJalali withZone(ZoneId zone) {
        if (Objects.equals(this.zone, zone)) {
            return this;
        }
        return new DateTimeFormatterJalali(this.printerParser, this.locale, this.decimalStyle, this.resolverStyle, this.resolverFields, this.chrono, zone);
    }

    public String format(TemporalAccessor temporal) {
        StringBuilder buf = new StringBuilder(32);
        this.formatTo(temporal, buf);
        return buf.toString();
    }

    public void formatTo(TemporalAccessor temporal, Appendable appendable) {
        Objects.requireNonNull(temporal, "temporal");
        Objects.requireNonNull(appendable, "appendable");
        try {
            DateTimePrintContextJalali context = new DateTimePrintContextJalali(temporal, this);
            if (appendable instanceof StringBuilder) {
                this.printerParser.format(context, (StringBuilder)appendable);
            } else {
                StringBuilder buf = new StringBuilder(32);
                this.printerParser.format(context, buf);
                appendable.append(buf);
            }
        }
        catch (IOException ex) {
            throw new DateTimeException(ex.getMessage(), ex);
        }
    }

    public TemporalAccessor parse(CharSequence text) {
        Objects.requireNonNull(text, "text");
        try {
            return this.parseResolved0(text, null);
        }
        catch (DateTimeParseException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw this.createError(text, ex);
        }
    }

    public TemporalAccessor parse(CharSequence text, ParsePosition position) {
        Objects.requireNonNull(text, "text");
        Objects.requireNonNull(position, "position");
        try {
            return this.parseResolved0(text, position);
        }
        catch (IndexOutOfBoundsException | DateTimeParseException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw this.createError(text, ex);
        }
    }

    public <T> T parse(CharSequence text, TemporalQuery<T> query) {
        Objects.requireNonNull(text, "text");
        Objects.requireNonNull(query, "query");
        try {
            return this.parseResolved0(text, null).query(query);
        }
        catch (DateTimeParseException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw this.createError(text, ex);
        }
    }

    private DateTimeParseException createError(CharSequence text, RuntimeException ex) {
        Object abbr = text.length() > 64 ? text.subSequence(0, 64) + "..." : text.toString();
        return new DateTimeParseException("Text '" + (String)abbr + "' could not be parsed: " + ex.getMessage(), text, 0, ex);
    }

    private TemporalAccessor parseResolved0(CharSequence text, ParsePosition position) {
        ParsePosition pos = position != null ? position : new ParsePosition(0);
        DateTimeParseContextJalali context = this.parseUnresolved0(text, pos);
        if (context == null || pos.getErrorIndex() >= 0 || position == null && pos.getIndex() < text.length()) {
            Object abbr = text.length() > 64 ? text.subSequence(0, 64) + "..." : text.toString();
            if (pos.getErrorIndex() >= 0) {
                throw new DateTimeParseException("Text '" + (String)abbr + "' could not be parsed at index " + pos.getErrorIndex(), text, pos.getErrorIndex());
            }
            throw new DateTimeParseException("Text '" + (String)abbr + "' could not be parsed, unparsed text found at index " + pos.getIndex(), text, pos.getIndex());
        }
        return context.toResolved(this.resolverStyle, this.resolverFields);
    }

    private DateTimeParseContextJalali parseUnresolved0(CharSequence text, ParsePosition position) {
        Objects.requireNonNull(text, "text");
        Objects.requireNonNull(position, "position");
        DateTimeParseContextJalali context = new DateTimeParseContextJalali(this);
        int pos = position.getIndex();
        pos = this.printerParser.parse(context, text, pos);
        if (pos < 0) {
            position.setErrorIndex(~pos);
            return null;
        }
        position.setIndex(pos);
        return context;
    }

    DateTimeFormatterBuilderJalali.CompositePrinterParser toPrinterParser(boolean optional) {
        return this.printerParser.withOptional(optional);
    }

    public String toString() {
        String pattern = this.printerParser.toString();
        pattern = pattern.startsWith("[") ? pattern : pattern.substring(1, pattern.length() - 1);
        return pattern;
    }

    @Generated
    public DateTimeFormatterBuilderJalali.CompositePrinterParser getPrinterParser() {
        return this.printerParser;
    }

    @Generated
    public Locale getLocale() {
        return this.locale;
    }

    @Generated
    public DecimalStyle getDecimalStyle() {
        return this.decimalStyle;
    }

    @Generated
    public ResolverStyle getResolverStyle() {
        return this.resolverStyle;
    }

    @Generated
    public Set<TemporalField> getResolverFields() {
        return this.resolverFields;
    }

    @Generated
    public Chronology getChrono() {
        return this.chrono;
    }

    @Generated
    public ZoneId getZone() {
        return this.zone;
    }

    static {
        LOCALE_FA = new Locale("fa");
        LOCALE_EN = new Locale("en");
        DAY_OF_WEEK = new HashMap<Locale, Map<Long, String>>();
        MONTH_OF_YEAR = new HashMap<Locale, Map<Long, String>>();
        AMPM_OF_DAY = new HashMap<Locale, Map<Long, String>>();
        PARSED_LEAP_SECOND = t -> {
            if (t instanceof Parsed) {
                return ((Parsed)t).leapSecond;
            }
            return Boolean.FALSE;
        };
        AMPM_OF_DAY.put(LOCALE_FA, new HashMap());
        AMPM_OF_DAY.get(LOCALE_FA).put(0L, "\u0642\u200c\u0638");
        AMPM_OF_DAY.get(LOCALE_FA).put(1L, "\u0628\u200c\u0638");
        AMPM_OF_DAY.put(LOCALE_EN, new HashMap());
        AMPM_OF_DAY.get(LOCALE_EN).put(0L, "AM");
        AMPM_OF_DAY.get(LOCALE_EN).put(1L, "PM");
        DAY_OF_WEEK.put(LOCALE_FA, new HashMap());
        DAY_OF_WEEK.get(LOCALE_FA).put(1L, "\u062f\u0648\u0634\u0646\u0628\u0647");
        DAY_OF_WEEK.get(LOCALE_FA).put(2L, "\u0633\u0647\u200c\u0634\u0646\u0628\u0647");
        DAY_OF_WEEK.get(LOCALE_FA).put(3L, "\u0686\u0647\u0627\u0631\u0634\u0646\u0628\u0647");
        DAY_OF_WEEK.get(LOCALE_FA).put(4L, "\u067e\u0646\u062c\u0634\u0646\u0628\u0647");
        DAY_OF_WEEK.get(LOCALE_FA).put(5L, "\u062c\u0645\u0639\u0647");
        DAY_OF_WEEK.get(LOCALE_FA).put(6L, "\u0634\u0646\u0628\u0647");
        DAY_OF_WEEK.get(LOCALE_FA).put(7L, "\u06cc\u06a9\u0634\u0646\u0628\u0647");
        DAY_OF_WEEK.put(LOCALE_EN, new HashMap());
        DAY_OF_WEEK.get(LOCALE_EN).put(1L, "DoShanbe");
        DAY_OF_WEEK.get(LOCALE_EN).put(2L, "SeShanbe");
        DAY_OF_WEEK.get(LOCALE_EN).put(3L, "ChaharShanbe");
        DAY_OF_WEEK.get(LOCALE_EN).put(4L, "PanjShanbe");
        DAY_OF_WEEK.get(LOCALE_EN).put(5L, "Jome");
        DAY_OF_WEEK.get(LOCALE_EN).put(6L, "Shanbe");
        DAY_OF_WEEK.get(LOCALE_EN).put(7L, "YekShanbe");
        MONTH_OF_YEAR.put(LOCALE_FA, new HashMap());
        MONTH_OF_YEAR.get(LOCALE_FA).put(1L, "\u0641\u0631\u0648\u0631\u062f\u06cc\u0646");
        MONTH_OF_YEAR.get(LOCALE_FA).put(2L, "\u0627\u0631\u062f\u06cc\u0628\u0647\u0634\u062a");
        MONTH_OF_YEAR.get(LOCALE_FA).put(3L, "\u062e\u0631\u062f\u0627\u062f");
        MONTH_OF_YEAR.get(LOCALE_FA).put(4L, "\u062a\u06cc\u0631");
        MONTH_OF_YEAR.get(LOCALE_FA).put(5L, "\u0645\u0631\u062f\u0627\u062f");
        MONTH_OF_YEAR.get(LOCALE_FA).put(6L, "\u0634\u0647\u0631\u06cc\u0648\u0631");
        MONTH_OF_YEAR.get(LOCALE_FA).put(7L, "\u0645\u0647\u0631");
        MONTH_OF_YEAR.get(LOCALE_FA).put(8L, "\u0622\u0628\u0627\u0646");
        MONTH_OF_YEAR.get(LOCALE_FA).put(9L, "\u0622\u0630\u0631");
        MONTH_OF_YEAR.get(LOCALE_FA).put(10L, "\u062f\u06cc");
        MONTH_OF_YEAR.get(LOCALE_FA).put(11L, "\u0628\u0647\u0645\u0646");
        MONTH_OF_YEAR.get(LOCALE_FA).put(12L, "\u0627\u0633\u0641\u0646\u062f");
        MONTH_OF_YEAR.put(LOCALE_EN, new HashMap());
        MONTH_OF_YEAR.get(LOCALE_EN).put(1L, "Farvardin");
        MONTH_OF_YEAR.get(LOCALE_EN).put(2L, "Ordibehesht");
        MONTH_OF_YEAR.get(LOCALE_EN).put(3L, "Khordad");
        MONTH_OF_YEAR.get(LOCALE_EN).put(4L, "Tir");
        MONTH_OF_YEAR.get(LOCALE_EN).put(5L, "Mordad");
        MONTH_OF_YEAR.get(LOCALE_EN).put(6L, "Shahrivar");
        MONTH_OF_YEAR.get(LOCALE_EN).put(7L, "Mehr");
        MONTH_OF_YEAR.get(LOCALE_EN).put(8L, "Aban");
        MONTH_OF_YEAR.get(LOCALE_EN).put(9L, "Azar");
        MONTH_OF_YEAR.get(LOCALE_EN).put(10L, "Dey");
        MONTH_OF_YEAR.get(LOCALE_EN).put(11L, "Bahman");
        MONTH_OF_YEAR.get(LOCALE_EN).put(12L, "Esfand");
        RFC_1123_DATE_TIME = new DateTimeFormatterBuilderJalali().parseCaseInsensitive().parseLenient().optionalStart().appendText((TemporalField)ChronoField.DAY_OF_WEEK, DateTimeFormatterJalali.getDayOfWeek(LOCALE_FA)).appendLiteral(", ").optionalEnd().appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral(' ').appendText((TemporalField)ChronoField.MONTH_OF_YEAR, DateTimeFormatterJalali.getMonthOfYear(LOCALE_FA)).appendLiteral(' ').appendValue(ChronoField.YEAR, 4).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().appendLiteral(' ').appendOffset("+HHMM", "GMT").toFormatter(ResolverStyle.SMART, ChronologyJalali.INSTANCE);
        ISO_LOCAL_DATE = new DateTimeFormatterBuilderJalali().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter(ResolverStyle.STRICT, ChronologyJalali.INSTANCE);
        ISO_OFFSET_DATE = new DateTimeFormatterBuilderJalali().parseCaseInsensitive().append(ISO_LOCAL_DATE).appendOffsetId().toFormatter(ResolverStyle.STRICT, ChronologyJalali.INSTANCE);
        ISO_DATE = new DateTimeFormatterBuilderJalali().parseCaseInsensitive().append(ISO_LOCAL_DATE).optionalStart().appendOffsetId().toFormatter(ResolverStyle.STRICT, ChronologyJalali.INSTANCE);
        ISO_LOCAL_TIME = new DateTimeFormatterBuilderJalali().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter(ResolverStyle.STRICT, null);
        ISO_OFFSET_TIME = new DateTimeFormatterBuilderJalali().parseCaseInsensitive().append(ISO_LOCAL_TIME).appendOffsetId().toFormatter(ResolverStyle.STRICT, null);
        ISO_TIME = new DateTimeFormatterBuilderJalali().parseCaseInsensitive().append(ISO_LOCAL_TIME).optionalStart().appendOffsetId().toFormatter(ResolverStyle.STRICT, null);
        ISO_LOCAL_DATE_TIME = new DateTimeFormatterBuilderJalali().parseCaseInsensitive().append(ISO_LOCAL_DATE).appendLiteral('T').append(ISO_LOCAL_TIME).toFormatter(ResolverStyle.STRICT, ChronologyJalali.INSTANCE);
        ISO_OFFSET_DATE_TIME = new DateTimeFormatterBuilderJalali().parseCaseInsensitive().append(ISO_LOCAL_DATE_TIME).appendOffsetId().toFormatter(ResolverStyle.STRICT, ChronologyJalali.INSTANCE);
        ISO_ZONED_DATE_TIME = new DateTimeFormatterBuilderJalali().append(ISO_OFFSET_DATE_TIME).optionalStart().appendLiteral('[').parseCaseSensitive().appendZoneRegionId().appendLiteral(']').toFormatter(ResolverStyle.STRICT, ChronologyJalali.INSTANCE);
        ISO_DATE_TIME = new DateTimeFormatterBuilderJalali().append(ISO_LOCAL_DATE_TIME).optionalStart().appendOffsetId().optionalStart().appendLiteral('[').parseCaseSensitive().appendZoneRegionId().appendLiteral(']').toFormatter(ResolverStyle.STRICT, ChronologyJalali.INSTANCE);
        ISO_ORDINAL_DATE = new DateTimeFormatterBuilderJalali().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.DAY_OF_YEAR, 3).optionalStart().appendOffsetId().toFormatter(ResolverStyle.STRICT, ChronologyJalali.INSTANCE);
        ISO_WEEK_DATE = new DateTimeFormatterBuilderJalali().parseCaseInsensitive().appendValue(IsoFields.WEEK_BASED_YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral("-W").appendValue(IsoFields.WEEK_OF_WEEK_BASED_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_WEEK, 1).optionalStart().appendOffsetId().toFormatter(ResolverStyle.STRICT, ChronologyJalali.INSTANCE);
        ISO_INSTANT = new DateTimeFormatterBuilderJalali().parseCaseInsensitive().appendInstant().toFormatter(ResolverStyle.STRICT, null);
        BASIC_ISO_DATE = new DateTimeFormatterBuilderJalali().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4).appendValue(ChronoField.MONTH_OF_YEAR, 2).appendValue(ChronoField.DAY_OF_MONTH, 2).optionalStart().appendOffset("+HHMMss", "Z").toFormatter(ResolverStyle.STRICT, ChronologyJalali.INSTANCE);
    }
}

