/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.time.zone;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.bardframework.time.LocalDateTimeJalali;
import org.bardframework.time.zone.Ser;

public final class ZoneOffsetTransition
implements Comparable<ZoneOffsetTransition>,
Serializable {
    private static final long serialVersionUID = -6946044323557704546L;
    private final long epochSecond;
    private final LocalDateTimeJalali transition;
    private final ZoneOffset offsetBefore;
    private final ZoneOffset offsetAfter;

    ZoneOffsetTransition(LocalDateTimeJalali transition, ZoneOffset offsetBefore, ZoneOffset offsetAfter) {
        assert (transition.getNano() == 0);
        this.epochSecond = transition.toEpochSecond(offsetBefore);
        this.transition = transition;
        this.offsetBefore = offsetBefore;
        this.offsetAfter = offsetAfter;
    }

    ZoneOffsetTransition(long epochSecond, ZoneOffset offsetBefore, ZoneOffset offsetAfter) {
        this.epochSecond = epochSecond;
        this.transition = LocalDateTimeJalali.ofEpochSecond(epochSecond, 0, offsetBefore);
        this.offsetBefore = offsetBefore;
        this.offsetAfter = offsetAfter;
    }

    public static ZoneOffsetTransition of(LocalDateTimeJalali transition, ZoneOffset offsetBefore, ZoneOffset offsetAfter) {
        Objects.requireNonNull(transition, "transition");
        Objects.requireNonNull(offsetBefore, "offsetBefore");
        Objects.requireNonNull(offsetAfter, "offsetAfter");
        if (offsetBefore.equals(offsetAfter)) {
            throw new IllegalArgumentException("Offsets must not be equal");
        }
        if (transition.getNano() != 0) {
            throw new IllegalArgumentException("Nano-of-second must be zero");
        }
        return new ZoneOffsetTransition(transition, offsetBefore, offsetAfter);
    }

    static ZoneOffsetTransition readExternal(DataInput in) throws IOException {
        ZoneOffset after;
        long epochSecond = Ser.readEpochSec(in);
        ZoneOffset before = Ser.readOffset(in);
        if (before.equals(after = Ser.readOffset(in))) {
            throw new IllegalArgumentException("Offsets must not be equal");
        }
        return new ZoneOffsetTransition(epochSecond, before, after);
    }

    private void readObject(ObjectInputStream s) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    private Object writeReplace() {
        return new Ser(2, this);
    }

    void writeExternal(DataOutput out) throws IOException {
        Ser.writeEpochSec(this.epochSecond, out);
        Ser.writeOffset(this.offsetBefore, out);
        Ser.writeOffset(this.offsetAfter, out);
    }

    public Instant getInstant() {
        return Instant.ofEpochSecond(this.epochSecond);
    }

    public long toEpochSecond() {
        return this.epochSecond;
    }

    public LocalDateTimeJalali getDateTimeBefore() {
        return this.transition;
    }

    public LocalDateTimeJalali getDateTimeAfter() {
        return this.transition.plusSeconds(this.getDurationSeconds());
    }

    public Duration getDuration() {
        return Duration.ofSeconds(this.getDurationSeconds());
    }

    private int getDurationSeconds() {
        return this.getOffsetAfter().getTotalSeconds() - this.getOffsetBefore().getTotalSeconds();
    }

    public boolean isGap() {
        return this.getOffsetAfter().getTotalSeconds() > this.getOffsetBefore().getTotalSeconds();
    }

    public boolean isOverlap() {
        return this.getOffsetAfter().getTotalSeconds() < this.getOffsetBefore().getTotalSeconds();
    }

    public boolean isValidOffset(ZoneOffset offset) {
        return !this.isGap() && (this.getOffsetBefore().equals(offset) || this.getOffsetAfter().equals(offset));
    }

    List<ZoneOffset> getValidOffsets() {
        if (this.isGap()) {
            return Collections.emptyList();
        }
        return List.of(this.getOffsetBefore(), this.getOffsetAfter());
    }

    @Override
    public int compareTo(ZoneOffsetTransition transition) {
        return Long.compare(this.epochSecond, transition.epochSecond);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ZoneOffsetTransition) {
            ZoneOffsetTransition d = (ZoneOffsetTransition)other;
            return this.epochSecond == d.epochSecond && this.offsetBefore.equals(d.offsetBefore) && this.offsetAfter.equals(d.offsetAfter);
        }
        return false;
    }

    public int hashCode() {
        return this.transition.hashCode() ^ this.offsetBefore.hashCode() ^ Integer.rotateLeft(this.offsetAfter.hashCode(), 16);
    }

    public String toString() {
        String buf = "Transition[" + (this.isGap() ? "Gap" : "Overlap") + " at " + this.transition + this.offsetBefore + " to " + this.offsetAfter + "]";
        return buf;
    }

    @Generated
    public long getEpochSecond() {
        return this.epochSecond;
    }

    @Generated
    public LocalDateTimeJalali getTransition() {
        return this.transition;
    }

    @Generated
    public ZoneOffset getOffsetBefore() {
        return this.offsetBefore;
    }

    @Generated
    public ZoneOffset getOffsetAfter() {
        return this.offsetAfter;
    }
}

