/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.maven.shade;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ManifestResourceTransformer;

public final class CollectingManifestResourceTransformer
extends ManifestResourceTransformer {
    private final List<String> defaultAttributes = Arrays.asList("Export-Package", "Import-Package", "Provide-Capability", "Require-Capability");
    private String mainClass;
    private Map<String, Object> manifestEntries = Collections.emptyMap();
    private boolean collectSections = false;
    private List<String> additionalAttributes = Collections.emptyList();
    private Manifest rootManifest = null;
    private long time = Long.MIN_VALUE;

    public void setCollectSections(boolean collectSections) {
        this.collectSections = collectSections;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setManifestEntries(Map<String, Object> manifestEntries) {
        this.manifestEntries = manifestEntries != null ? new HashMap<String, Object>(manifestEntries) : Collections.emptyMap();
    }

    public void setAdditionalAttributes(List<String> additionalAttributes) {
        this.additionalAttributes = additionalAttributes != null ? new ArrayList<String>(additionalAttributes) : Collections.emptyList();
    }

    public boolean canTransformResource(String resource) {
        return "META-INF/MANIFEST.MF".equalsIgnoreCase(resource);
    }

    public void processResource(String resource, InputStream is, List<Relocator> relocators, long time) throws IOException {
        Manifest loadedManifest = new Manifest(is);
        if (relocators != null && !relocators.isEmpty()) {
            Attributes attributes = loadedManifest.getMainAttributes();
            this.defaultAttributes.forEach(attribute -> {
                String attributeValue = attributes.getValue((String)attribute);
                if (attributeValue != null) {
                    String newValue = this.relocate(attributeValue, relocators);
                    attributes.putValue((String)attribute, newValue);
                }
            });
            if (this.additionalAttributes != null) {
                this.additionalAttributes.forEach(attribute -> {
                    String attributeValue = attributes.getValue((String)attribute);
                    if (attributeValue != null) {
                        String newValue = this.relocate(attributeValue, relocators);
                        attributes.putValue((String)attribute, newValue);
                    }
                });
            }
        }
        if (this.rootManifest == null) {
            this.rootManifest = loadedManifest;
            if (time > this.time) {
                this.time = time;
            }
        }
        if (this.collectSections && loadedManifest != this.rootManifest) {
            Map<String, Attributes> existingRootSections = this.rootManifest.getEntries();
            loadedManifest.getEntries().forEach((key, value) -> {
                Attributes existingRootSectionAttributes = (Attributes)existingRootSections.get(key);
                if (existingRootSectionAttributes == null) {
                    existingRootSectionAttributes = new Attributes();
                    existingRootSections.put((String)key, existingRootSectionAttributes);
                }
                if (value != null) {
                    value.forEach(existingRootSectionAttributes::put);
                }
            });
        }
    }

    public boolean hasTransformedResource() {
        return true;
    }

    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        if (this.rootManifest == null) {
            this.rootManifest = new Manifest();
        }
        Attributes attributes = this.rootManifest.getMainAttributes();
        if (this.mainClass != null && !this.mainClass.isEmpty()) {
            attributes.put(Attributes.Name.MAIN_CLASS, this.mainClass);
        }
        if (this.manifestEntries != null) {
            this.manifestEntries.forEach((k, v) -> {
                if (v != null) {
                    attributes.put(new Attributes.Name((String)k), v);
                } else {
                    attributes.remove(new Attributes.Name((String)k));
                }
            });
        }
        jos.putNextEntry(new JarEntry("META-INF/MANIFEST.MF"));
        this.rootManifest.write(jos);
    }

    private String relocate(String originalValue, List<Relocator> relocators) {
        String newValue = originalValue;
        for (Relocator relocator : relocators) {
            String value;
            while (!(value = newValue).equals(newValue = relocator.relocateClass(value))) {
            }
        }
        return newValue;
    }
}

