/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.maven.shade;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ManifestResourceTransformer;

public final class CollectingManifestResourceTransformer
extends ManifestResourceTransformer {
    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"})
    private String mainClass;
    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"})
    private Map<String, String> manifestEntries;
    private boolean collectSections = false;
    private Manifest manifest;

    public boolean canTransformResource(String resource) {
        return "META-INF/MANIFEST.MF".equalsIgnoreCase(resource);
    }

    public void processResource(String resource, InputStream is, List<Relocator> relocators) throws IOException {
        Manifest loadedManifest = new Manifest(is);
        if (this.manifest == null) {
            this.manifest = loadedManifest;
        }
        if (this.collectSections && loadedManifest != this.manifest) {
            Map<String, Attributes> sections = this.manifest.getEntries();
            for (Map.Entry<String, Attributes> manifestSection : loadedManifest.getEntries().entrySet()) {
                Attributes sectionAttributes = sections.get(manifestSection.getKey());
                if (sectionAttributes == null) {
                    sectionAttributes = new Attributes();
                    sections.put(manifestSection.getKey(), sectionAttributes);
                }
                for (Map.Entry<Object, Object> attributeEntry : manifestSection.getValue().entrySet()) {
                    sectionAttributes.put(attributeEntry.getKey(), attributeEntry.getValue());
                }
            }
        }
    }

    public boolean hasTransformedResource() {
        return true;
    }

    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        if (this.manifest == null) {
            this.manifest = new Manifest();
        }
        Attributes attributes = this.manifest.getMainAttributes();
        if (this.mainClass != null) {
            attributes.put(Attributes.Name.MAIN_CLASS, this.mainClass);
        }
        if (this.manifestEntries != null) {
            for (Map.Entry<String, String> entry : this.manifestEntries.entrySet()) {
                attributes.put(new Attributes.Name(entry.getKey()), entry.getValue());
            }
        }
        jos.putNextEntry(new JarEntry("META-INF/MANIFEST.MF"));
        this.manifest.write(jos);
    }
}

