/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.maven.shade;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ManifestResourceTransformer;

public final class CollectingManifestResourceTransformer
extends ManifestResourceTransformer {
    private final List<String> defaultAttributes = Arrays.asList("Export-Package", "Import-Package", "Provide-Capability", "Require-Capability");
    private String mainClass;
    private Map<String, Object> manifestEntries = Collections.emptyMap();
    private boolean collectSections = false;
    private List<String> additionalAttributes = Collections.emptyList();
    private Manifest rootManifest = null;
    private long time = Long.MIN_VALUE;

    public void setCollectSections(boolean collectSections) {
        this.collectSections = collectSections;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setManifestEntries(Map<String, Object> manifestEntries) {
        this.manifestEntries = manifestEntries != null ? manifestEntries : Collections.emptyMap();
    }

    public void setAdditionalAttributes(List<String> additionalAttributes) {
        this.additionalAttributes = additionalAttributes != null ? additionalAttributes : Collections.emptyList();
    }

    public boolean canTransformResource(String resource) {
        return "META-INF/MANIFEST.MF".equalsIgnoreCase(resource);
    }

    public void processResource(String resource, InputStream is, List<Relocator> relocators, long time) throws IOException {
        Manifest loadedManifest = new Manifest(is);
        if (relocators != null && !relocators.isEmpty()) {
            String newValue;
            String attributeValue;
            Attributes attributes = loadedManifest.getMainAttributes();
            for (String string : this.defaultAttributes) {
                attributeValue = attributes.getValue(string);
                if (attributeValue == null) continue;
                newValue = this.relocate(attributeValue, relocators);
                attributes.putValue(string, newValue);
            }
            for (String string : this.additionalAttributes) {
                attributeValue = attributes.getValue(string);
                if (attributeValue == null) continue;
                newValue = this.relocate(attributeValue, relocators);
                attributes.putValue(string, newValue);
            }
        }
        if (this.rootManifest == null) {
            this.rootManifest = loadedManifest;
            if (time > this.time) {
                this.time = time;
            }
        }
        if (this.collectSections && loadedManifest != this.rootManifest) {
            Map<String, Attributes> existingRootSections = this.rootManifest.getEntries();
            for (Map.Entry entry : loadedManifest.getEntries().entrySet()) {
                Attributes existingRootSectionAttributes = existingRootSections.get(entry.getKey());
                if (existingRootSectionAttributes == null) {
                    existingRootSectionAttributes = new Attributes();
                    existingRootSections.put((String)entry.getKey(), existingRootSectionAttributes);
                }
                for (Map.Entry<Object, Object> attributeEntry : ((Attributes)entry.getValue()).entrySet()) {
                    existingRootSectionAttributes.put(attributeEntry.getKey(), attributeEntry.getValue());
                }
            }
        }
    }

    public boolean hasTransformedResource() {
        return true;
    }

    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        if (this.rootManifest == null) {
            this.rootManifest = new Manifest();
        }
        Attributes attributes = this.rootManifest.getMainAttributes();
        if (this.mainClass != null && !this.mainClass.isEmpty()) {
            attributes.put(Attributes.Name.MAIN_CLASS, this.mainClass);
        }
        if (this.manifestEntries != null) {
            for (Map.Entry<String, Object> entry : this.manifestEntries.entrySet()) {
                attributes.put(new Attributes.Name(entry.getKey()), entry.getValue());
            }
        }
        jos.putNextEntry(new JarEntry("META-INF/MANIFEST.MF"));
        this.rootManifest.write(jos);
    }

    private String relocate(String originalValue, List<Relocator> relocators) {
        String newValue = originalValue;
        for (Relocator relocator : relocators) {
            String value;
            while (!(value = newValue).equals(newValue = relocator.relocateClass(value))) {
            }
        }
        return newValue;
    }
}

