/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.transformer.processor;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.basepom.inline.transformer.ClassPathResource;
import org.basepom.inline.transformer.ClassPathTag;
import org.basepom.inline.transformer.JarProcessor;
import org.basepom.inline.transformer.TransformerException;
import org.basepom.inline.transformer.processor.ProcessorContext;

public abstract class AbstractServiceFileCollectingProcessor
implements JarProcessor {
    private final Consumer<ClassPathResource> outputSink;
    private final String prefix;
    private final Map<String, ImmutableList.Builder<String>> resourceMap = new HashMap<String, ImmutableList.Builder<String>>();
    private boolean wroteFiles = false;

    protected AbstractServiceFileCollectingProcessor(ProcessorContext processorContext, String prefix) {
        this.outputSink = ((ProcessorContext)Preconditions.checkNotNull((Object)processorContext, (Object)"processorContext is null")).getOutputSink();
        this.prefix = prefix;
    }

    @Override
    public int getPriority() {
        return 110;
    }

    @Override
    @CheckForNull
    public ClassPathResource scan(@Nonnull ClassPathResource classPathResource, JarProcessor.Chain<ClassPathResource> chain) throws TransformerException, IOException {
        if (classPathResource.containsTags(ClassPathTag.RESOURCE) && classPathResource.getName().startsWith(this.prefix)) {
            ImmutableList.Builder builder = this.resourceMap.computeIfAbsent(classPathResource.getName(), n -> ImmutableList.builder());
            try (ByteArrayInputStream byteStream = new ByteArrayInputStream(classPathResource.getContent());
                 InputStreamReader reader = new InputStreamReader((InputStream)byteStream, StandardCharsets.UTF_8);){
                Splitter.on((char)'\n').trimResults().omitEmptyStrings().split((CharSequence)CharStreams.toString((Readable)reader)).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            }
        }
        return chain.next(classPathResource);
    }

    @Override
    @CheckForNull
    public ClassPathResource process(@Nonnull ClassPathResource classPathResource, JarProcessor.Chain<ClassPathResource> chain) throws TransformerException, IOException {
        if (!this.wroteFiles) {
            this.wroteFiles = true;
            for (Map.Entry<String, ImmutableList.Builder<String>> entry : this.resourceMap.entrySet()) {
                ImmutableList.Builder<String> builder = entry.getValue();
                byte[] content = (Joiner.on((char)'\n').join((Iterable)builder.build()) + "\n").getBytes(StandardCharsets.UTF_8);
                ClassPathResource fileClassPathResource = ClassPathResource.forContent(entry.getKey(), content);
                this.outputSink.accept(fileClassPathResource);
            }
        }
        if (this.resourceMap.containsKey(classPathResource.getName())) {
            return null;
        }
        return chain.next(classPathResource);
    }
}

