/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.transformer.processor;

import java.io.IOException;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.basepom.inline.transformer.ClassNameUtils;
import org.basepom.inline.transformer.ClassPathResource;
import org.basepom.inline.transformer.JarProcessor;
import org.basepom.inline.transformer.TransformerException;

public class MultiReleaseJarProcessor
implements JarProcessor {
    @Override
    public int getPriority() {
        return 20;
    }

    @Override
    @CheckForNull
    public ClassPathResource preScan(@Nonnull ClassPathResource classPathResource, JarProcessor.Chain<ClassPathResource> chain) throws TransformerException, IOException {
        return this.convertMultiReleaseJarEntry(classPathResource, chain);
    }

    @Override
    @CheckForNull
    public ClassPathResource scan(@Nonnull ClassPathResource classPathResource, JarProcessor.Chain<ClassPathResource> chain) throws TransformerException, IOException {
        return this.convertMultiReleaseJarEntry(classPathResource, chain);
    }

    @Override
    @CheckForNull
    public ClassPathResource process(@Nonnull ClassPathResource classPathResource, JarProcessor.Chain<ClassPathResource> chain) throws TransformerException, IOException {
        return this.convertMultiReleaseJarEntry(classPathResource, chain);
    }

    @CheckForNull
    ClassPathResource convertMultiReleaseJarEntry(@Nonnull ClassPathResource classPathResource, JarProcessor.Chain<ClassPathResource> chain) throws TransformerException, IOException {
        if (classPathResource.getName().startsWith("META-INF/versions/")) {
            List<String> elements = ClassNameUtils.pathToElements(classPathResource.getName());
            int version = -1;
            try {
                version = Integer.parseInt(elements.get(2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (version > 8 && elements.size() > 3) {
                String name = ClassNameUtils.elementsToPath(elements.subList(3, elements.size()));
                String prefix = ClassNameUtils.elementsToPath(elements.subList(0, 3));
                classPathResource = classPathResource.withPrefix(prefix, name);
            }
        }
        if ((classPathResource = chain.next(classPathResource)) != null && classPathResource.hasPrefix()) {
            classPathResource = classPathResource.withPrefix(null, classPathResource.getNameWithPrefix());
        }
        return classPathResource;
    }
}

