/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.transformer.processor;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.basepom.inline.transformer.ClassPathResource;
import org.basepom.inline.transformer.ClassPathTag;
import org.basepom.inline.transformer.JarProcessor;
import org.basepom.inline.transformer.Rename;
import org.basepom.inline.transformer.TransformerException;
import org.basepom.inline.transformer.processor.RemapperProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRenamerJarProcessor
implements JarProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceRenamerJarProcessor.class);
    private final RemapperProcessor remapperProcessor;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ResourceRenamerJarProcessor(@Nonnull RemapperProcessor remapperProcessor) {
        this.remapperProcessor = remapperProcessor;
    }

    @Override
    public int getPriority() {
        return 90;
    }

    @Override
    @CheckForNull
    public ClassPathResource scan(@Nonnull ClassPathResource classPathResource, JarProcessor.Chain<ClassPathResource> chain) throws TransformerException, IOException {
        return this.process(classPathResource, chain);
    }

    @Override
    @CheckForNull
    public ClassPathResource process(@Nonnull ClassPathResource classPathResource, JarProcessor.Chain<ClassPathResource> chain) throws TransformerException, IOException {
        if (classPathResource.containsTags(ClassPathTag.RESOURCE)) {
            ImmutableSet<Rename> eligibleRenames = this.remapperProcessor.renamersForClassPathResource(classPathResource);
            classPathResource = classPathResource.withName(this.mapResourceName(classPathResource.getName(), (Set<Rename>)eligibleRenames));
        }
        return chain.next(classPathResource);
    }

    private String mapResourceName(String value, Set<Rename> renames) {
        if (renames.isEmpty()) {
            LOG.debug(String.format("Rejecting '%s', not part of any rename!", value));
            return value;
        }
        for (Rename rename : renames) {
            String result = rename.renamePath(value);
            if (result == null) continue;
            LOG.debug(String.format("Renamed %s to %s", value, result));
            return result;
        }
        return value;
    }
}

