/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.transformer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.basepom.inline.transformer.ClassPathResource;
import org.basepom.inline.transformer.TransformerException;

public interface JarProcessor
extends Comparable<JarProcessor> {
    @CheckForNull
    default public ClassPathResource preScan(@Nonnull ClassPathResource classPathResource, Chain<ClassPathResource> chain) throws TransformerException, IOException {
        return chain.next(classPathResource);
    }

    @CheckForNull
    default public ClassPathResource scan(@Nonnull ClassPathResource classPathResource, Chain<ClassPathResource> chain) throws TransformerException, IOException {
        return chain.next(classPathResource);
    }

    @CheckForNull
    default public ClassPathResource process(@Nonnull ClassPathResource classPathResource, Chain<ClassPathResource> chain) throws TransformerException, IOException {
        return chain.next(classPathResource);
    }

    public int getPriority();

    @Override
    default public int compareTo(JarProcessor other) {
        return ComparisonChain.start().compare(this.getPriority(), other.getPriority()).compare((Comparable)((Object)this.getClass().getSimpleName()), (Comparable)((Object)other.getClass().getSimpleName())).result();
    }

    public static interface Chain<T> {
        @CheckForNull
        public T next(@Nullable T var1) throws TransformerException, IOException;
    }

    public static class Holder {
        private final ImmutableSet<JarProcessor> processors;

        public Holder(Set<JarProcessor> processors) {
            this.processors = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(processors, (Object)"processors is null")));
        }

        public Holder(JarProcessor ... processors) {
            this.processors = ImmutableSet.copyOf((Object[])processors);
        }

        @Nonnull
        public Optional<ClassPathResource> preScan(@Nonnull ClassPathResource classPathResource) throws TransformerException, IOException {
            ChainInstance<ClassPathResource> instance = new ChainInstance<ClassPathResource>(JarProcessor::preScan);
            return Optional.ofNullable(instance.next(classPathResource));
        }

        @Nonnull
        public Optional<ClassPathResource> scan(@Nonnull ClassPathResource classPathResource) throws TransformerException, IOException {
            ChainInstance<ClassPathResource> instance = new ChainInstance<ClassPathResource>(JarProcessor::scan);
            return Optional.ofNullable(instance.next(classPathResource));
        }

        @Nonnull
        public Optional<ClassPathResource> process(@Nonnull ClassPathResource classPathResource) throws TransformerException, IOException {
            ChainInstance<ClassPathResource> instance = new ChainInstance<ClassPathResource>(JarProcessor::process);
            return Optional.ofNullable(instance.next(classPathResource));
        }

        final class ChainInstance<T>
        implements Chain<T> {
            private final Iterator<JarProcessor> iterator;
            private final ProcessorOperation<T> operation;

            ChainInstance(ProcessorOperation<T> operation) {
                this.operation = operation;
                this.iterator = Holder.this.processors.iterator();
            }

            @Override
            @CheckForNull
            public T next(@Nullable T source) throws TransformerException, IOException {
                if (source != null && this.iterator.hasNext()) {
                    return this.operation.apply(this.iterator.next(), source, this);
                }
                return source;
            }
        }

        @FunctionalInterface
        static interface ProcessorOperation<T> {
            public T apply(JarProcessor var1, T var2, Chain<T> var3) throws TransformerException, IOException;
        }
    }
}

