/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.transformer.processor;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.basepom.inline.transformer.ClassPathResource;
import org.basepom.inline.transformer.ClassPathTag;
import org.basepom.inline.transformer.JarProcessor;
import org.basepom.inline.transformer.TransformerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateDiscardProcessor
implements JarProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DuplicateDiscardProcessor.class);
    private final Set<String> files = new HashSet<String>();
    private final boolean failOnDuplicates;

    public DuplicateDiscardProcessor(boolean failOnDuplicates) {
        this.failOnDuplicates = failOnDuplicates;
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    @Override
    @CheckForNull
    public ClassPathResource process(@Nonnull ClassPathResource classPathResource, JarProcessor.Chain<ClassPathResource> chain) throws IOException, TransformerException {
        String name;
        if (classPathResource.containsTags(ClassPathTag.FILE) && !this.files.add(name = classPathResource.getNameWithPrefix())) {
            if (this.failOnDuplicates) {
                throw new TransformerException(String.format("Duplicate found: %s", name), new Object[0]);
            }
            LOG.warn(String.format("Entry '%s' is a duplicate, discarding!", name));
            return null;
        }
        return chain.next(classPathResource);
    }
}

