/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.transformer.processor;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.basepom.inline.transformer.ClassNameUtils;
import org.basepom.inline.transformer.ClassPathResource;
import org.basepom.inline.transformer.ClassPathTag;
import org.basepom.inline.transformer.JarProcessor;
import org.basepom.inline.transformer.TransformerException;

public class MetaInfFileProcessor
implements JarProcessor {
    @Override
    public int getPriority() {
        return 50;
    }

    @Override
    @CheckForNull
    public ClassPathResource scan(@Nonnull ClassPathResource classPathResource, JarProcessor.Chain<ClassPathResource> chain) throws TransformerException, IOException {
        return chain.next(this.processMetaInfFile(classPathResource));
    }

    @Override
    @CheckForNull
    public ClassPathResource process(@Nonnull ClassPathResource classPathResource, JarProcessor.Chain<ClassPathResource> chain) throws TransformerException, IOException {
        return chain.next(this.processMetaInfFile(classPathResource));
    }

    private ClassPathResource processMetaInfFile(@Nonnull ClassPathResource classPathResource) {
        if (classPathResource.containsTags(ClassPathTag.ROOT_JAR) || !classPathResource.containsTags(ClassPathTag.RESOURCE)) {
            return classPathResource;
        }
        List<String> elements = ClassNameUtils.pathToElements(classPathResource.getName());
        if (elements.size() != 2 || !elements.get(0).equals("META-INF")) {
            return classPathResource;
        }
        String name = classPathResource.getClassPathElement().map(c -> Joiner.on((char)'/').join((Object)"META-INF", (Object)"inlined", new Object[]{c.getGroupId(), c.getArtifactId(), elements.get(1)})).orElse(classPathResource.getName());
        return classPathResource.withName(name);
    }
}

