/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.transformer.processor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.basepom.inline.transformer.ClassNameUtils;
import org.basepom.inline.transformer.ClassPathElement;
import org.basepom.inline.transformer.ClassPathResource;
import org.basepom.inline.transformer.ClassPathTag;
import org.basepom.inline.transformer.JarProcessor;
import org.basepom.inline.transformer.Rename;
import org.basepom.inline.transformer.TransformerException;
import org.basepom.inline.transformer.util.SetMultiTrie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemapperProcessor
implements JarProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(RemapperProcessor.class);
    private final SetMultimap<ClassPathElement, Rename> renamers = HashMultimap.create();
    private final SetMultiTrie<String, ClassPathResource> elementMatches = new SetMultiTrie();
    private final SetMultiTrie<String, ClassPathResource> packageNameMatches = new SetMultiTrie();

    @Override
    public int getPriority() {
        return 70;
    }

    @Override
    @CheckForNull
    public ClassPathResource preScan(@Nonnull ClassPathResource classPathResource, JarProcessor.Chain<ClassPathResource> chain) throws TransformerException, IOException {
        ClassNameUtils.ifClass(classPathResource.getName(), p -> {
            List<String> elements = ClassNameUtils.pathToElements(ClassNameUtils.stripClassExtension(classPathResource.getName()));
            classPathResource.getClassPathElement().ifPresent(c -> {
                String packageName = ClassNameUtils.pathToJavaName(ClassNameUtils.elementsToPath(ClassNameUtils.packageForElement(elements)));
                this.addRule((ClassPathElement)c, packageName);
            });
            return p;
        });
        this.addResource(classPathResource);
        return chain.next(classPathResource);
    }

    @VisibleForTesting
    void addRule(@Nonnull ClassPathElement classPathElement, String packageName) {
        classPathElement.getPrefix().ifPresent(p -> {
            Rename rename = Rename.forClassName(packageName, Joiner.on((char)'.').join(p, (Object)packageName, new Object[0]), classPathElement.isHideClasses());
            this.renamers.put((Object)classPathElement, (Object)rename);
            LOG.debug(String.format("Allowing %s in %s", packageName, classPathElement.getArchiveName()));
        });
    }

    @VisibleForTesting
    void addResource(@Nonnull ClassPathResource classPathResource) {
        List<String> elements = ClassNameUtils.pathToElements(ClassNameUtils.stripClassExtension(classPathResource.getName()));
        this.elementMatches.add(elements, classPathResource);
        ClassNameUtils.ifClass(classPathResource.getName(), p -> {
            this.packageNameMatches.add(ClassNameUtils.packageForElement(elements), classPathResource);
            return p;
        });
        LOG.debug(String.format("Accepting %s from %s", classPathResource.getName(), classPathResource.getClassPathElement()));
    }

    public ImmutableSet<Rename> renamersForClassPathResource(ClassPathResource resource) {
        Set<ClassPathElement> candidates = RemapperProcessor.computeCandidates(this.elementMatches, ClassNameUtils.pathToElements(resource.getName()), null);
        return (ImmutableSet)candidates.stream().filter(c -> c.equals(resource.getClassPathElement().orElse(null))).flatMap(c -> this.renamers.get(c).stream()).collect(ImmutableSet.toImmutableSet());
    }

    public ImmutableSortedSet<Rename> renamersForElement(List<String> elements, ClassPathTag type) {
        Set<ClassPathElement> candidates = RemapperProcessor.computeCandidates(this.elementMatches, elements, type);
        ImmutableSortedSet renames = (ImmutableSortedSet)candidates.stream().flatMap(c -> this.renamers.get(c).stream()).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.reverseOrder()));
        return renames;
    }

    public ImmutableSortedSet<Rename> packageNameRenamersForElement(List<String> elements, ClassPathTag type) {
        Set<ClassPathElement> candidates = RemapperProcessor.computeCandidates(this.packageNameMatches, elements, type);
        ImmutableSortedSet renames = (ImmutableSortedSet)candidates.stream().flatMap(c -> this.renamers.get(c).stream()).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.reverseOrder()));
        return renames;
    }

    private static Set<ClassPathElement> computeCandidates(SetMultiTrie<String, ClassPathResource> trie, List<String> elements, ClassPathTag type) {
        return trie.getValues(elements).stream().filter(c -> c.containsTags(ClassPathTag.FILE)).filter(c -> type == null || c.containsTags(type)).flatMap(r -> r.getClassPathElement().stream()).collect(Collectors.toUnmodifiableSet());
    }
}

