/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.transformer;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;

public final class ClassNameUtils {
    public static final String EXT_CLASS = ".class";

    private ClassNameUtils() {
        throw new AssertionError((Object)"ClassNameUtils can not be instantiated");
    }

    public static boolean isObjectArray(String value) {
        return value.startsWith("[L") && value.endsWith(";");
    }

    public static boolean isClassNameHeuristic(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(Character.codePointAt(value, 0))) {
            return false;
        }
        if (value.codePoints().filter(Character::isWhitespace).findFirst().isPresent()) {
            return false;
        }
        double count = value.length();
        double validChars = value.codePoints().filter(Character::isJavaIdentifierPart).count();
        return validChars / count > 0.7;
    }

    @Nonnull
    public static String javaNameToPath(@Nonnull String className) {
        return ClassNameUtils.toPath(className) + EXT_CLASS;
    }

    @Nonnull
    public static String pathToJavaName(@Nonnull String path) {
        return ClassNameUtils.toPackage(ClassNameUtils.stripClassExtension(path));
    }

    public static String stripClassExtension(@Nonnull String path) {
        return ClassNameUtils.ifClass(path, p -> p.substring(0, p.length() - EXT_CLASS.length()));
    }

    public static boolean isClass(@Nonnull String path) {
        return path.endsWith(EXT_CLASS);
    }

    public static String ifClass(@Nonnull String path, Function<String, String> function) {
        return ClassNameUtils.isClass(path) ? function.apply(path) : path;
    }

    public static String toPath(String value) {
        return value.replace('.', '/');
    }

    public static String toPackage(String value) {
        return value.replace('/', '.');
    }

    public static List<String> pathToElements(String path) {
        return Splitter.on((char)'/').trimResults().splitToList((CharSequence)path);
    }

    public static String elementsToPath(List<String> elements) {
        return Joiner.on((char)'/').join(elements);
    }

    public static List<String> packageForElement(List<String> elements) {
        return elements.subList(0, elements.size() - 1);
    }
}

