/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.transformer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Iterator;
import java.util.StringJoiner;
import org.basepom.inline.transformer.ClassPathElement;
import org.basepom.inline.transformer.ClassPathTag;

public class ClassPath
implements Iterable<ClassPathElement> {
    private final ImmutableSet.Builder<ClassPathElement> entries = ImmutableSet.builder();
    private final File root;
    private final long timestamp;

    public ClassPath(File root, long timestamp) {
        this.root = (File)Preconditions.checkNotNull((Object)root, (Object)"root is null");
        this.timestamp = timestamp;
    }

    public void addFile(File file, String groupId, String artifactId, ClassPathTag ... tags) {
        if (!file.isAbsolute()) {
            file = new File(this.root, file.getPath());
        }
        this.entries.add((Object)ClassPathElement.forFile(file, null, groupId, artifactId, false, this.timestamp, tags));
    }

    public void addFile(File file, String prefix, String groupId, String artifactId, boolean hideClasses, ClassPathTag ... tags) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        if (!file.isAbsolute()) {
            file = new File(this.root, file.getPath());
        }
        this.entries.add((Object)ClassPathElement.forFile(file, prefix, groupId, artifactId, hideClasses, this.timestamp, tags));
    }

    @Override
    public Iterator<ClassPathElement> iterator() {
        return this.entries.build().iterator();
    }

    public String toString() {
        return new StringJoiner(", ", ClassPath.class.getSimpleName() + "[", "]").add("entries=" + this.entries.build()).add("root=" + this.root).toString();
    }
}

