/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.transformer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import org.basepom.inline.transformer.ClassPathResource;
import org.basepom.inline.transformer.ClassPathTag;
import org.basepom.inline.transformer.util.ExceptionUtil;

public abstract class ClassPathElement
implements Iterable<ClassPathResource> {
    private final File archiveFile;
    private final boolean hideClasses;
    private final String prefix;
    private final ImmutableSet<ClassPathTag> tags;
    private final String groupId;
    private final String artifactId;

    public static ClassPathElement forFile(final File file, @Nullable String prefix, String groupId, String artifactId, boolean hideClasses, final long timestamp, ClassPathTag ... tags) {
        if (file.isDirectory()) {
            return new ClassPathElement(file, prefix, groupId, artifactId, hideClasses, tags){

                @Override
                public Iterator<ClassPathResource> iterator() {
                    return new DirectoryIterator(file, timestamp);
                }
            };
        }
        return new ClassPathElement(file, prefix, groupId, artifactId, hideClasses, tags){

            @Override
            public Iterator<ClassPathResource> iterator() {
                return ExceptionUtil.wrapIOException(() -> new ZipIterator(file));
            }
        };
    }

    private ClassPathElement(@Nonnull File archiveFile, @Nullable String prefix, String groupId, String artifactId, boolean hideClasses, ClassPathTag ... tags) {
        this.archiveFile = (File)Preconditions.checkNotNull((Object)archiveFile, (Object)"archiveFile is null");
        this.prefix = prefix;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.hideClasses = hideClasses;
        this.tags = ImmutableSet.copyOf((Object[])tags);
    }

    @Nonnull
    public String getArchiveName() {
        return this.archiveFile.getPath();
    }

    public boolean isHideClasses() {
        return this.hideClasses;
    }

    @NonNull
    public Optional<String> getPrefix() {
        return Optional.ofNullable(this.prefix);
    }

    public ImmutableSet<ClassPathTag> getTags() {
        return this.tags;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public abstract Iterator<ClassPathResource> iterator();

    private void findClassFiles(@Nonnull ImmutableList.Builder<ClassPathResource> out, long timestamp, @Nonnull File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.findClassFiles(out, timestamp, file);
                    continue;
                }
                if (!file.isFile()) continue;
                out.add((Object)ClassPathResource.fromFile(this, file, timestamp, this.tags));
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.archiveFile + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassPathElement that = (ClassPathElement)o;
        return Objects.equals(this.archiveFile, that.archiveFile);
    }

    public int hashCode() {
        return Objects.hash(this.archiveFile);
    }

    private class DirectoryIterator
    implements Iterator<ClassPathResource> {
        private final Iterator<ClassPathResource> entries;

        DirectoryIterator(File directory, long timestamp) {
            ImmutableList.Builder builder = ImmutableList.builder();
            ClassPathElement.this.findClassFiles((ImmutableList.Builder<ClassPathResource>)builder, timestamp, directory);
            this.entries = builder.build().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.entries.hasNext();
        }

        @Override
        public ClassPathResource next() {
            return this.entries.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ZipIterator
    implements Iterator<ClassPathResource>,
    Closeable {
        private final ZipFile zipFile;
        private final Iterator<? extends ZipEntry> zipEntries;

        ZipIterator(File archiveFile) throws IOException {
            this.zipFile = new ZipFile(archiveFile);
            this.zipEntries = Iterators.forEnumeration(this.zipFile.entries());
        }

        @Override
        public boolean hasNext() {
            if (this.zipEntries.hasNext()) {
                return true;
            }
            this.close();
            return false;
        }

        @Override
        public ClassPathResource next() {
            return ClassPathResource.fromZipEntry(ClassPathElement.this, this.zipFile, this.zipEntries.next(), ClassPathElement.this.tags);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            try {
                this.zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

