/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.transformer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.basepom.inline.transformer.ClassPath;
import org.basepom.inline.transformer.ClassPathElement;
import org.basepom.inline.transformer.ClassPathResource;
import org.basepom.inline.transformer.JarProcessor;
import org.basepom.inline.transformer.TransformerException;
import org.basepom.inline.transformer.asm.InlineRemapper;
import org.basepom.inline.transformer.asm.RemappingClassTransformer;
import org.basepom.inline.transformer.processor.ClassTransformerJarProcessor;
import org.basepom.inline.transformer.processor.DirectoryFilterProcessor;
import org.basepom.inline.transformer.processor.DirectoryScanProcessor;
import org.basepom.inline.transformer.processor.DuplicateDiscardProcessor;
import org.basepom.inline.transformer.processor.JarWriterProcessor;
import org.basepom.inline.transformer.processor.MetaInfFileProcessor;
import org.basepom.inline.transformer.processor.ModuleInfoFilterProcessor;
import org.basepom.inline.transformer.processor.MultiReleaseJarProcessor;
import org.basepom.inline.transformer.processor.ProcessorContext;
import org.basepom.inline.transformer.processor.RemapperProcessor;
import org.basepom.inline.transformer.processor.ResourceRenamerJarProcessor;
import org.basepom.inline.transformer.processor.ServiceLoaderCollectingProcessor;
import org.basepom.inline.transformer.processor.ServiceLoaderRewritingProcessor;
import org.basepom.inline.transformer.processor.SignatureFilterProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JarTransformer {
    private static final Logger LOG = LoggerFactory.getLogger(JarTransformer.class);
    private final JarProcessor.Holder holder;

    @VisibleForTesting
    JarTransformer(@Nonnull Consumer<ClassPathResource> outputSink) {
        this(outputSink, 0L, false, (ImmutableSet<String>)ImmutableSet.of());
    }

    public JarTransformer(@Nonnull Consumer<ClassPathResource> outputSink, long timestamp, boolean failOnDuplicates, ImmutableSet<String> additionalProcessors) {
        Preconditions.checkNotNull(outputSink, (Object)"outputFile is null");
        RemapperProcessor packageRemapperProcessor = new RemapperProcessor();
        InlineRemapper remapper = new InlineRemapper(packageRemapperProcessor);
        ProcessorContext processorContext = new ProcessorContext(remapper, outputSink, timestamp);
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        this.createAdditionalProcessors((ImmutableSortedSet.Builder<JarProcessor>)builder, processorContext, (Set<String>)additionalProcessors);
        builder.add((Object)new JarWriterProcessor(outputSink));
        builder.add((Object)new DirectoryFilterProcessor());
        builder.add((Object)new MultiReleaseJarProcessor());
        builder.add((Object)new ServiceLoaderRewritingProcessor(processorContext));
        builder.add((Object)new SignatureFilterProcessor());
        builder.add((Object)new MetaInfFileProcessor());
        builder.add((Object)new ModuleInfoFilterProcessor());
        builder.add((Object)packageRemapperProcessor);
        builder.add((Object)new ClassTransformerJarProcessor(new RemappingClassTransformer(remapper)));
        builder.add((Object)new ResourceRenamerJarProcessor(packageRemapperProcessor));
        builder.add((Object)new DirectoryScanProcessor(outputSink, timestamp));
        builder.add((Object)new ServiceLoaderCollectingProcessor(processorContext));
        builder.add((Object)new DuplicateDiscardProcessor(failOnDuplicates));
        this.holder = new JarProcessor.Holder((Set<JarProcessor>)builder.build());
    }

    private void createAdditionalProcessors(ImmutableSortedSet.Builder<JarProcessor> builder, ProcessorContext processorContext, Set<String> additionalProcessors) {
        for (String additionalProcessor : additionalProcessors) {
            try {
                Constructor<?> ctor;
                Class<?> processorClass = Class.forName(additionalProcessor);
                try {
                    ctor = processorClass.getDeclaredConstructor(new Class[0]);
                    JarProcessor processor = (JarProcessor)ctor.newInstance(new Object[0]);
                    builder.add((Object)processor);
                    LOG.debug(String.format("Added '%s' processor with empty constructor", additionalProcessor));
                }
                catch (NoSuchMethodException e) {
                    ctor = processorClass.getDeclaredConstructor(ProcessorContext.class);
                    JarProcessor processor = (JarProcessor)ctor.newInstance(processorContext);
                    builder.add((Object)processor);
                    LOG.debug(String.format("Added '%s' processor with ProcessorContext constructor", additionalProcessor));
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOG.warn(String.format("Could not instantiate processor'%s'", additionalProcessor), (Throwable)e);
            }
            catch (ClassCastException e) {
                LOG.warn(String.format("Could not instantiate processor'%s', not a JarProcessor", additionalProcessor));
            }
        }
    }

    public void transform(@Nonnull ClassPath inputPath) throws TransformerException, IOException {
        for (ClassPathElement inputArchive : inputPath) {
            LOG.debug(String.format("Pre-scanning archive %s", inputArchive));
            for (ClassPathResource inputResource : inputArchive) {
                this.holder.preScan(inputResource);
            }
        }
        for (ClassPathElement inputArchive : inputPath) {
            LOG.debug(String.format("Scanning archive %s", inputArchive));
            for (ClassPathResource inputResource : inputArchive) {
                this.holder.scan(inputResource);
            }
        }
        try {
            for (ClassPathElement inputArchive : inputPath) {
                LOG.debug(String.format("Transforming archive %s", inputArchive));
                for (ClassPathResource inputResource : inputArchive) {
                    this.holder.process(inputResource);
                }
            }
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }
}

