/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.transformer.processor;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.io.CharStreams;
import com.google.common.io.LineProcessor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.basepom.inline.transformer.ClassNameUtils;
import org.basepom.inline.transformer.ClassPathResource;
import org.basepom.inline.transformer.ClassPathTag;
import org.basepom.inline.transformer.JarProcessor;
import org.basepom.inline.transformer.TransformerException;
import org.basepom.inline.transformer.asm.InlineRemapper;
import org.basepom.inline.transformer.processor.ProcessorContext;

public abstract class AbstractServiceFileRewritingProcessor
implements JarProcessor {
    private final InlineRemapper inlineRemapper;
    private final String prefix;

    protected AbstractServiceFileRewritingProcessor(ProcessorContext processorContext, String prefix) {
        Preconditions.checkNotNull((Object)processorContext, (Object)"processorContext is null");
        this.inlineRemapper = processorContext.getInlineRemapper();
        this.prefix = prefix;
    }

    @Override
    public int getPriority() {
        return 30;
    }

    @Override
    @CheckForNull
    public ClassPathResource scan(@Nonnull ClassPathResource classPathResource, JarProcessor.Chain<ClassPathResource> chain) throws TransformerException, IOException {
        return this.rewriteServiceLoaderJarEntry(classPathResource, chain);
    }

    @Override
    @CheckForNull
    public ClassPathResource process(@Nonnull ClassPathResource classPathResource, JarProcessor.Chain<ClassPathResource> chain) throws TransformerException, IOException {
        return this.rewriteServiceLoaderJarEntry(classPathResource, chain);
    }

    @CheckForNull
    ClassPathResource rewriteServiceLoaderJarEntry(ClassPathResource classPathResource, JarProcessor.Chain<ClassPathResource> chain) throws TransformerException, IOException {
        if (classPathResource.containsTags(ClassPathTag.RESOURCE) && classPathResource.getName().startsWith(this.prefix)) {
            try (ByteArrayInputStream byteStream = new ByteArrayInputStream(classPathResource.getContent());
                 InputStreamReader reader = new InputStreamReader((InputStream)byteStream, StandardCharsets.UTF_8);){
                String content = (String)CharStreams.readLines((Readable)reader, (LineProcessor)new LineProcessor<String>(){
                    private final StringWriter stringWriter = new StringWriter();

                    public boolean processLine(@Nonnull String line) {
                        List elements = Splitter.on((char)'#').trimResults().splitToList((CharSequence)line);
                        String path = ClassNameUtils.toPath((String)elements.get(0));
                        String result = AbstractServiceFileRewritingProcessor.this.inlineRemapper.map(path);
                        if (result != null) {
                            this.stringWriter.append(ClassNameUtils.pathToJavaName(result));
                            if (elements.size() > 1) {
                                this.stringWriter.append(" # ");
                                this.stringWriter.append(Joiner.on((char)'#').join(elements.subList(1, elements.size())));
                            }
                        } else {
                            this.stringWriter.append(line);
                        }
                        this.stringWriter.append('\n');
                        return true;
                    }

                    public String getResult() {
                        return this.stringWriter.toString();
                    }
                });
                classPathResource = classPathResource.withContent(content.getBytes(StandardCharsets.UTF_8));
                List<String> elements = ClassNameUtils.pathToElements(classPathResource.getName());
                String result = this.inlineRemapper.map(ClassNameUtils.toPath(elements.get(2)));
                if (result != null) {
                    classPathResource = classPathResource.withName(this.prefix + ClassNameUtils.pathToJavaName(result));
                }
            }
        }
        classPathResource = chain.next(classPathResource);
        return classPathResource;
    }
}

