/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.transformer.processor;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSortedSet;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.basepom.inline.transformer.ClassPathResource;
import org.basepom.inline.transformer.JarProcessor;
import org.basepom.inline.transformer.TransformerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryScanProcessor
implements JarProcessor {
    public static final Logger LOG = LoggerFactory.getLogger(DirectoryScanProcessor.class);
    private final Consumer<ClassPathResource> outputSink;
    private final long timestamp;
    private final ImmutableSortedSet.Builder<String> directories = ImmutableSortedSet.naturalOrder();
    private boolean wroteDirectories = false;

    public DirectoryScanProcessor(Consumer<ClassPathResource> outputSink, long timestamp) {
        this.outputSink = outputSink;
        this.timestamp = timestamp;
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    @CheckForNull
    public ClassPathResource scan(@Nonnull ClassPathResource classPathResource, JarProcessor.Chain<ClassPathResource> chain) throws TransformerException, IOException {
        String name = classPathResource.getName();
        List elements = Splitter.on((char)'/').splitToList((CharSequence)name);
        if (elements.size() > 1) {
            for (int i = 1; i < elements.size(); ++i) {
                String dirName = Joiner.on((char)'/').join(elements.subList(0, i));
                this.directories.add((Object)dirName);
            }
        }
        return chain.next(classPathResource);
    }

    @Override
    @CheckForNull
    public ClassPathResource process(@Nonnull ClassPathResource classPathResource, JarProcessor.Chain<ClassPathResource> chain) throws TransformerException, IOException {
        if (!this.wroteDirectories) {
            this.wroteDirectories = true;
            for (String directory : this.directories.build()) {
                LOG.debug(String.format("Adding directory '%s' to jar", directory));
                ClassPathResource directoryResource = ClassPathResource.forDirectory(directory, this.timestamp);
                this.outputSink.accept(directoryResource);
            }
        }
        return chain.next(classPathResource);
    }
}

