/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.transformer.util;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;

public final class SetMultiTrie<T, U> {
    private final TrieNode<T, U> rootNode = new TrieNode();

    public void add(Collection<T> elements, U value) {
        TrieNode<Object, U> current = this.rootNode;
        for (T element : elements) {
            current = current.computeIfAbsent(element, t -> new TrieNode());
        }
        current.terminal(value);
    }

    public ImmutableSet<U> getValues(Collection<T> elements) {
        TrieNode<T, U> current = this.rootNode;
        for (T element : elements) {
            if ((current = current.get(element)) != null) continue;
            return ImmutableSet.of();
        }
        return current.getValues();
    }

    private static final class TrieNode<T, U> {
        private final ImmutableSet.Builder<U> builder = ImmutableSet.builder();
        private final Map<T, TrieNode<T, U>> map = new HashMap<T, TrieNode<T, U>>();

        private TrieNode() {
        }

        private TrieNode<T, U> computeIfAbsent(T value, Function<T, TrieNode<T, U>> function) {
            return this.map.computeIfAbsent(value, function);
        }

        private TrieNode<T, U> get(T value) {
            return this.map.get(value);
        }

        private void terminal(@NonNull U value) {
            this.builder.add(value);
        }

        private ImmutableSet<U> getValues() {
            return this.builder.build();
        }

        public String toString() {
            return new StringJoiner(", ", TrieNode.class.getSimpleName() + "[", "]").add("values=" + this.builder.build()).add("map=" + this.map).toString();
        }
    }
}

