/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.transformer.asm;

import com.google.common.collect.ImmutableSortedSet;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.basepom.inline.transformer.ClassNameUtils;
import org.basepom.inline.transformer.ClassPathTag;
import org.basepom.inline.transformer.Rename;
import org.basepom.inline.transformer.processor.RemapperProcessor;
import org.objectweb.asm.commons.Remapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InlineRemapper
extends Remapper {
    private static final Logger LOG = LoggerFactory.getLogger(InlineRemapper.class);
    private final Map<String, String> typeCache = new HashMap<String, String>();
    private final RemapperProcessor remapperProcessor;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public InlineRemapper(RemapperProcessor remapperProcessor) {
        this.remapperProcessor = remapperProcessor;
    }

    public String map(String key) {
        return this.typeCache.computeIfAbsent(key, k -> this.computeNewName(key));
    }

    public Object mapValue(Object value) {
        if (!(value instanceof String)) {
            return super.mapValue(value);
        }
        String key = (String)value;
        String cacheResult = this.typeCache.get(key);
        if (cacheResult != null) {
            return cacheResult;
        }
        if (ClassNameUtils.isObjectArray(key)) {
            String arrayKey = this.mapDesc(key);
            if (!arrayKey.equals(key)) {
                return this.storeValue(key, arrayKey);
            }
        } else {
            boolean hasSlashes;
            boolean hasDots = key.indexOf(46) >= 0;
            boolean bl = hasSlashes = key.indexOf(47) >= 0;
            if (hasDots && !hasSlashes) {
                String classKey = ClassNameUtils.toPath(key);
                if (ClassNameUtils.isClassNameHeuristic(key)) {
                    String classValue = this.computeNewName(classKey);
                    if (classValue != null) {
                        if (!classValue.equals(classKey)) {
                            return this.storeValue(key, ClassNameUtils.toPackage(classValue));
                        }
                        List<String> classElements = ClassNameUtils.pathToElements(classKey);
                        for (int i = classElements.size(); i > 0; --i) {
                            List<String> testElements = classElements.subList(0, i);
                            ImmutableSortedSet<Rename> renamers = this.remapperProcessor.renamersForElement(testElements, ClassPathTag.CLASS);
                            if (renamers.isEmpty()) {
                                renamers = this.remapperProcessor.packageNameRenamersForElement(testElements, ClassPathTag.CLASS);
                            }
                            if (renamers.isEmpty() || (classValue = this.renamePath(classKey, renamers, false)) == null || classValue.equals(classKey)) continue;
                            return this.storeValue(key, ClassNameUtils.toPackage(classValue));
                        }
                    }
                    LOG.debug(String.format("%s passed heuristics but not rewriting", key));
                }
            } else if (hasSlashes && ClassNameUtils.isClassNameHeuristic(ClassNameUtils.toPackage(key))) {
                String pathValue = this.computeNewName(key);
                if (pathValue != null && !pathValue.equals(key)) {
                    return this.storeValue(key, pathValue);
                }
                LOG.debug(String.format("%s passed heuristics but not rewriting", key));
            }
        }
        this.typeCache.put(key, key);
        return key;
    }

    private String storeValue(String key, String value) {
        this.typeCache.put(key, value);
        LOG.debug(String.format("Rewrote value '%s' to '%s'", key, value));
        return value;
    }

    @CheckForNull
    private String computeNewName(String path) {
        List<String> elements = ClassNameUtils.pathToElements(path);
        ImmutableSortedSet<Rename> classRenamers = this.remapperProcessor.renamersForElement(elements, ClassPathTag.CLASS);
        if (!classRenamers.isEmpty()) {
            return this.renamePath(path, classRenamers, true);
        }
        ImmutableSortedSet<Rename> resourceRenamers = this.remapperProcessor.renamersForElement(elements, ClassPathTag.RESOURCE);
        if (!resourceRenamers.isEmpty()) {
            return this.renamePath(path, resourceRenamers, false);
        }
        return null;
    }

    @CheckForNull
    private String renamePath(String path, ImmutableSortedSet<Rename> renames, boolean hideClasses) {
        for (Rename rename : renames) {
            String result = rename.renameClassName(path, hideClasses);
            if (result == null) continue;
            return result;
        }
        LOG.debug(String.format("No pattern matches '%s', skipping!", path));
        return null;
    }
}

