/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.transformer.processor;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.basepom.inline.transformer.ClassNameUtils;
import org.basepom.inline.transformer.ClassPathResource;
import org.basepom.inline.transformer.ClassPathTag;
import org.basepom.inline.transformer.JarProcessor;
import org.basepom.inline.transformer.TransformerException;
import org.basepom.inline.transformer.asm.ClassTransformer;
import org.basepom.inline.transformer.asm.GetNameClassWriter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassTransformerJarProcessor
implements JarProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ClassTransformerJarProcessor.class);
    private final List<ClassTransformer> classTransformers;

    public ClassTransformerJarProcessor(@Nonnull List<ClassTransformer> classTransformers) {
        this.classTransformers = new ArrayList<ClassTransformer>(classTransformers);
    }

    public ClassTransformerJarProcessor(ClassTransformer ... classTransformers) {
        this(Arrays.asList(classTransformers));
    }

    @Override
    public int getPriority() {
        return 80;
    }

    @Override
    @CheckForNull
    public ClassPathResource scan(@Nonnull ClassPathResource classPathResource, JarProcessor.Chain<ClassPathResource> chain) throws TransformerException, IOException {
        if (classPathResource.containsTags(ClassPathTag.CLASS)) {
            GetNameClassWriter namer;
            ClassReader reader = new ClassReader(classPathResource.getContent());
            GetNameClassWriter cv = namer = new GetNameClassWriter(new ClassVisitor(589824){});
            for (ClassTransformer classTransformer : this.classTransformers) {
                cv = classTransformer.transform(cv);
            }
            reader.accept((ClassVisitor)cv, 8);
            classPathResource = classPathResource.withName(ClassNameUtils.javaNameToPath(namer.getClassName()));
        }
        return chain.next(classPathResource);
    }

    @Override
    @CheckForNull
    public ClassPathResource process(@Nonnull ClassPathResource classPathResource, JarProcessor.Chain<ClassPathResource> chain) throws TransformerException, IOException {
        if (classPathResource.containsTags(ClassPathTag.CLASS)) {
            try {
                GetNameClassWriter namer;
                ClassReader reader = new ClassReader(classPathResource.getContent());
                String oldName = reader.getClassName();
                ClassWriter writer = new ClassWriter(1);
                GetNameClassWriter cv = namer = new GetNameClassWriter((ClassVisitor)writer);
                for (ClassTransformer classProcessor : this.classTransformers) {
                    cv = classProcessor.transform(cv);
                }
                reader.accept((ClassVisitor)cv, 8);
                String newName = namer.getClassName();
                classPathResource = classPathResource.withName(ClassNameUtils.javaNameToPath(newName)).withContent(writer.toByteArray());
                if (!newName.equals(oldName)) {
                    LOG.debug(String.format("Transformed '%s' to '%s' (in %s)", oldName, newName, classPathResource.getClassPathElement()));
                }
            }
            catch (UncheckedIOException e) {
                LOG.warn(String.format("Failed to read class '%s'", classPathResource.getName()), (Throwable)e.getCause());
            }
        }
        return chain.next(classPathResource);
    }
}

