/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.transformer.processor;

import java.io.IOException;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.basepom.inline.transformer.ClassNameUtils;
import org.basepom.inline.transformer.ClassPathResource;
import org.basepom.inline.transformer.ClassPathTag;
import org.basepom.inline.transformer.JarProcessor;
import org.basepom.inline.transformer.TransformerException;
import org.basepom.inline.transformer.processor.AbstractFilterJarProcessor;

public class ModuleInfoFilterProcessor
extends AbstractFilterJarProcessor {
    public static final String MODULE_INFO = "module-info.class";

    @Override
    public int getPriority() {
        return 60;
    }

    @Override
    protected boolean isFiltered(@Nonnull ClassPathResource classPathResource) {
        List<String> elements = ClassNameUtils.pathToElements(classPathResource.getName());
        return !classPathResource.containsTags(ClassPathTag.ROOT_JAR) && MODULE_INFO.equals(elements.get(elements.size() - 1));
    }

    @Override
    @CheckForNull
    public ClassPathResource process(@Nonnull ClassPathResource classPathResource, JarProcessor.Chain<ClassPathResource> chain) throws TransformerException, IOException {
        return super.process(classPathResource, chain);
    }
}

