/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.transformer.processor;

import java.util.List;
import javax.annotation.Nonnull;
import org.basepom.inline.transformer.ClassNameUtils;
import org.basepom.inline.transformer.ClassPathResource;
import org.basepom.inline.transformer.ClassPathTag;
import org.basepom.inline.transformer.processor.AbstractFilterJarProcessor;

public class SignatureFilterProcessor
extends AbstractFilterJarProcessor {
    @Override
    public int getPriority() {
        return 40;
    }

    @Override
    protected boolean isFiltered(@Nonnull ClassPathResource classPathResource) {
        if (!classPathResource.containsTags(ClassPathTag.RESOURCE)) {
            return false;
        }
        List<String> elements = ClassNameUtils.pathToElements(classPathResource.getName());
        if (elements.isEmpty() || !elements.get(0).equals("META-INF")) {
            return false;
        }
        String filename = elements.get(elements.size() - 1);
        return filename.endsWith(".SF") || filename.endsWith(".DSA") || filename.endsWith(".RSA");
    }
}

