/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.transformer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import org.basepom.inline.transformer.ClassPathElement;
import org.basepom.inline.transformer.ClassPathTag;
import org.basepom.inline.transformer.util.ExceptionUtil;

public final class ClassPathResource {
    private static final String CLASS_SUFFIX = ".class";
    private final String prefix;
    private final String name;
    private final long lastModifiedTime;
    private final ClassPathElement classPathElement;
    private final Supplier<InputStream> inputStreamSupplier;
    private final ImmutableSet<ClassPathTag> tags;
    private transient byte[] content;

    public static ClassPathResource fromZipEntry(ClassPathElement classPathElement, ZipFile zipFile, ZipEntry entry, ImmutableSet<ClassPathTag> tags) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(tags);
        builder.add((Object)(entry.isDirectory() ? ClassPathTag.DIRECTORY : ClassPathTag.FILE));
        builder.add((Object)(entry.getName().endsWith(CLASS_SUFFIX) ? ClassPathTag.CLASS : ClassPathTag.RESOURCE));
        return new ClassPathResource(null, entry.getName(), entry.getTime(), classPathElement, ClassPathResource.supplierForZipEntry(zipFile, entry), null, (ImmutableSet<ClassPathTag>)builder.build());
    }

    public static ClassPathResource fromFile(ClassPathElement classPathElement, File file, long timestamp, ImmutableSet<ClassPathTag> tags) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(tags);
        builder.add((Object)(file.isDirectory() ? ClassPathTag.DIRECTORY : ClassPathTag.FILE));
        builder.add((Object)(file.getName().endsWith(CLASS_SUFFIX) ? ClassPathTag.CLASS : ClassPathTag.RESOURCE));
        return new ClassPathResource(null, file.getName(), timestamp, classPathElement, ClassPathResource.supplierForFile(file), null, (ImmutableSet<ClassPathTag>)builder.build());
    }

    public static ClassPathResource forDirectory(String directory, long timestamp) {
        return new ClassPathResource(null, directory, timestamp, null, InputStream::nullInputStream, null, (ImmutableSet<ClassPathTag>)ImmutableSet.of((Object)((Object)ClassPathTag.DIRECTORY), (Object)((Object)ClassPathTag.RESOURCE)));
    }

    public static ClassPathResource forContent(String name, long timestamp, byte[] content) {
        return new ClassPathResource(null, name, timestamp, null, InputStream::nullInputStream, content, (ImmutableSet<ClassPathTag>)ImmutableSet.of((Object)((Object)ClassPathTag.FILE), (Object)((Object)ClassPathTag.RESOURCE)));
    }

    @VisibleForTesting
    public static ClassPathResource forTesting(String path, ClassPathElement classPathElement, ClassPathTag ... tags) {
        return new ClassPathResource(null, path, 0L, classPathElement, InputStream::nullInputStream, null, (ImmutableSet<ClassPathTag>)ImmutableSet.copyOf((Object[])tags));
    }

    public ClassPathResource withPrefix(String prefix, String name) {
        if (Objects.equals(prefix, this.prefix) && name.equals(this.name)) {
            return this;
        }
        return new ClassPathResource(prefix, name, this.lastModifiedTime, this.classPathElement, this.inputStreamSupplier, this.content, this.tags);
    }

    public ClassPathResource withName(String name) {
        if (name.equals(this.name)) {
            return this;
        }
        return new ClassPathResource(this.prefix, name, this.lastModifiedTime, this.classPathElement, this.inputStreamSupplier, this.content, this.tags);
    }

    public ClassPathResource withContent(byte[] content) {
        return new ClassPathResource(this.prefix, this.name, this.lastModifiedTime, this.classPathElement, this.inputStreamSupplier, content, this.tags);
    }

    private ClassPathResource(String prefix, String name, long lastModifiedTime, @Nullable ClassPathElement classPathElement, Supplier<InputStream> inputStreamSupplier, byte[] content, ImmutableSet<ClassPathTag> tags) {
        this.prefix = prefix;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.lastModifiedTime = lastModifiedTime;
        this.classPathElement = classPathElement;
        this.inputStreamSupplier = (Supplier)Preconditions.checkNotNull(inputStreamSupplier, (Object)"inputStreamSupplier is null");
        this.content = content;
        this.tags = (ImmutableSet)Preconditions.checkNotNull(tags, (Object)"tags is null");
    }

    public Optional<ClassPathElement> getClassPathElement() {
        return Optional.ofNullable(this.classPathElement);
    }

    public boolean hasPrefix() {
        return this.prefix != null;
    }

    @Nonnull
    public String getName() {
        if (this.containsTags(ClassPathTag.DIRECTORY)) {
            return this.name.endsWith("/") ? this.name : this.name + "/";
        }
        return this.name;
    }

    @Nonnull
    public String getNameWithPrefix() {
        if (this.prefix == null) {
            return this.name;
        }
        return Joiner.on((char)'/').join((Object)this.prefix, (Object)this.name, new Object[0]);
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Nonnull
    public ImmutableSet<ClassPathTag> getTags() {
        return this.tags;
    }

    public boolean containsTags(ClassPathTag ... tags) {
        for (ClassPathTag tag : tags) {
            if (this.tags.contains((Object)tag)) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public byte[] getContent() {
        if (this.content == null) {
            this.content = ExceptionUtil.wrapIOException(() -> {
                try (InputStream in = this.inputStreamSupplier.get();){
                    byte[] byArray = ByteStreams.toByteArray((InputStream)in);
                    return byArray;
                }
            });
        }
        return this.content;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", ClassPathResource.class.getSimpleName() + "[", "]").add("prefix='" + this.prefix + "'").add("name='" + this.name + "'").add("lastModifiedTime=" + this.lastModifiedTime).add("classPathElement='" + String.valueOf(this.classPathElement) + "'").add("tags=" + String.valueOf(this.tags));
        if (this.content == null) {
            joiner.add("content=<not loaded>");
        } else {
            joiner.add("content length=" + this.content.length);
        }
        return joiner.toString();
    }

    private static Supplier<InputStream> supplierForZipEntry(ZipFile zipFile, ZipEntry zipEntry) {
        return () -> ExceptionUtil.wrapIOException(() -> zipFile.getInputStream(zipEntry));
    }

    private static Supplier<InputStream> supplierForFile(File file) {
        return () -> ExceptionUtil.wrapIOException(() -> new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0])));
    }
}

