/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.transformer;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.basepom.inline.transformer.ClassNameUtils;

public final class Rename
implements Comparable<Rename> {
    private final List<String> sourceElements;
    private final List<String> destinationElements;
    private final boolean hideClasses;

    private Rename(String source, String destination, boolean hideClasses) {
        this.sourceElements = ClassNameUtils.pathToElements(source);
        this.destinationElements = ClassNameUtils.pathToElements(destination);
        this.hideClasses = hideClasses;
    }

    public static Rename forClassName(String source, String destination, boolean hideClasses) {
        Preconditions.checkState((!source.contains("/") ? 1 : 0) != 0, (String)"package string must not contain '/' (%s)", (Object)source);
        Preconditions.checkState((!destination.contains("/") ? 1 : 0) != 0, (String)"package string must not contain '/' (%s)", (Object)destination);
        return new Rename(ClassNameUtils.toPath(source), ClassNameUtils.toPath(destination), hideClasses);
    }

    public static Rename forResourcePath(String source, String destination) {
        return new Rename(source, destination, false);
    }

    @CheckForNull
    public String renamePath(@Nonnull String path) {
        List<String> pathElements = ClassNameUtils.pathToElements(path);
        int index = this.matchPrefix(pathElements, this.sourceElements);
        if (index < 0) {
            return null;
        }
        return Joiner.on((char)'/').join(Iterables.concat(this.destinationElements, pathElements.subList(index, pathElements.size())));
    }

    @CheckForNull
    public String renameClassName(@Nonnull String className) {
        return this.renameClassName(className, true);
    }

    @CheckForNull
    public String renameClassName(@Nonnull String className, boolean hideClasses) {
        List<String> pathElements;
        boolean needPathConversion = className.indexOf(47) < 0;
        List<String> list = pathElements = needPathConversion ? ClassNameUtils.pathToElements(ClassNameUtils.toPath(className)) : ClassNameUtils.pathToElements(className);
        if (this.sourceElements.size() >= pathElements.size()) {
            return null;
        }
        int index = this.matchPrefix(pathElements, this.sourceElements);
        if (index < 0 || index == pathElements.size()) {
            return null;
        }
        String name = pathElements.get(pathElements.size() - 1);
        String result = Joiner.on((char)'/').join(Iterables.concat(this.destinationElements, pathElements.subList(index, pathElements.size() - 1), (Iterable)ImmutableList.of((Object)(this.hideClasses && hideClasses ? "$" + name : name))));
        return needPathConversion ? ClassNameUtils.toPackage(result) : result;
    }

    private int matchPrefix(List<String> pathElements, List<String> elements) {
        if (elements.size() > pathElements.size()) {
            return -1;
        }
        for (int i = 0; i < elements.size(); ++i) {
            if (pathElements.get(i).equals(elements.get(i))) continue;
            return -1;
        }
        return elements.size();
    }

    public String toString() {
        return new StringJoiner(", ", Rename.class.getSimpleName() + "[", "]").add("sourceElements=" + String.valueOf(this.sourceElements)).add("destinationElements=" + String.valueOf(this.destinationElements)).add("hideClasses=" + this.hideClasses).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rename rename = (Rename)o;
        return this.hideClasses == rename.hideClasses && Objects.equals(this.sourceElements, rename.sourceElements) && Objects.equals(this.destinationElements, rename.destinationElements);
    }

    public int hashCode() {
        return Objects.hash(this.sourceElements, this.destinationElements, this.hideClasses);
    }

    @Override
    public int compareTo(Rename other) {
        return ComparisonChain.start().compare(this.sourceElements.size(), other.sourceElements.size()).compare((Comparable)((Object)ClassNameUtils.elementsToPath(this.sourceElements)), (Comparable)((Object)ClassNameUtils.elementsToPath(other.sourceElements))).result();
    }
}

