/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.transformer.processor;

import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.basepom.inline.transformer.ClassPathResource;
import org.basepom.inline.transformer.JarProcessor;
import org.basepom.inline.transformer.TransformerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractFilterJarProcessor
implements JarProcessor {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    AbstractFilterJarProcessor() {
    }

    protected abstract boolean isFiltered(@Nonnull ClassPathResource var1);

    protected boolean isVerbose() {
        return true;
    }

    @Override
    @CheckForNull
    public ClassPathResource preScan(@Nonnull ClassPathResource classPathResource, JarProcessor.Chain<ClassPathResource> chain) throws TransformerException, IOException {
        if (this.isFiltered(classPathResource)) {
            if (this.isVerbose()) {
                this.log.debug(String.format("pre-scan discarded '%s'", classPathResource.getName()));
            }
            return null;
        }
        return chain.next(classPathResource);
    }

    @Override
    @CheckForNull
    public ClassPathResource scan(@Nonnull ClassPathResource classPathResource, JarProcessor.Chain<ClassPathResource> chain) throws TransformerException, IOException {
        if (this.isFiltered(classPathResource)) {
            if (this.isVerbose()) {
                this.log.debug(String.format("scan discarded '%s'", classPathResource.getName()));
            }
            return null;
        }
        return chain.next(classPathResource);
    }

    @Override
    @CheckForNull
    public ClassPathResource process(@Nonnull ClassPathResource classPathResource, JarProcessor.Chain<ClassPathResource> chain) throws TransformerException, IOException {
        if (this.isFiltered(classPathResource)) {
            if (this.isVerbose()) {
                this.log.debug(String.format("process discarded %s", classPathResource.getName()));
            }
            return null;
        }
        return chain.next(classPathResource);
    }
}

