/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.dependencymanagement;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.basepom.mojo.dependencymanagement.DependencyManagementAnalyzer;
import org.basepom.mojo.dependencymanagement.RequireManagement;

@Mojo(name="analyze", requiresDependencyCollection=ResolutionScope.TEST, threadSafe=true)
public class DependencyManagementMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    public MavenProject project;
    @Parameter
    public RequireManagement requireManagement = new RequireManagement();
    @Parameter(defaultValue="false")
    public boolean fail;
    @Parameter(defaultValue="false")
    public boolean skip;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        boolean success = new DependencyManagementAnalyzer(this.project, this.requireManagement, this.fail ? arg_0 -> ((Log)this.getLog()).error(arg_0) : arg_0 -> ((Log)this.getLog()).warn(arg_0)).analyze();
        if (success) {
            this.getLog().info((CharSequence)"No dependency management issues found");
        } else if (this.fail) {
            throw new MojoExecutionException("Dependency management issues found");
        }
    }
}

