/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.dependencymanagement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.basepom.mojo.dependencymanagement.RequireManagement;
import org.basepom.mojo.dependencymanagement.RequireManagementConfig;
import org.basepom.mojo.dependencymanagement.RequireManagementOverride;
import org.codehaus.plexus.util.SelectorUtils;

public class DependencyManagementAnalyzer {
    private final MavenProject project;
    private final RequireManagement requireManagement;
    private final Consumer<String> violationLogger;
    private boolean dependencyVersionMismatchError = false;
    private boolean unmanagedDependencyError = false;
    private boolean unmanagedPluginError = false;
    private boolean pluginVersionMismatchError = false;
    private boolean dependencyExclusionsError = false;
    private boolean dependencyVersionDisallowedError = false;
    private final List<String> errorMessages = new ArrayList<String>();

    public DependencyManagementAnalyzer(MavenProject project, RequireManagement requireManagement, Consumer<String> violationLogger) {
        this.project = project;
        this.requireManagement = requireManagement;
        this.violationLogger = violationLogger;
    }

    public boolean analyze() {
        boolean success = this.checkDependencyManagement();
        success &= this.checkPluginManagement();
        if (!this.errorMessages.isEmpty()) {
            this.errorMessages.forEach(message -> {
                this.logViolation("------------------------------------------------------------------------");
                this.logViolation((String)message);
            });
        }
        return success;
    }

    private boolean checkDependencyManagement() {
        Map<String, Dependency> managedDependencies = this.getManagedDependenciesAsMap();
        Map<String, Dependency> originalDependencies = this.getOriginalDependenciesAsMap();
        boolean success = true;
        for (Dependency projectDependency : this.project.getDependencies()) {
            String dependencyKey = projectDependency.getManagementKey();
            RequireManagementConfig config = this.getEffectiveRequireManagementConfig(dependencyKey);
            Dependency managedDependency = managedDependencies.get(dependencyKey);
            Dependency originalDependency = originalDependencies.get(dependencyKey);
            if (managedDependency != null) {
                String managedVersion;
                String projectVersion = projectDependency.getVersion();
                if (!projectVersion.equals(managedVersion = managedDependency.getVersion())) {
                    String errorFormat = "Version mismatch for %s, managed version %s does not match version %s declared in module's pom";
                    String additionalMessage = "If you intended to use the version specified in dependency management, please remove the version from this module's dependency declaration.";
                    this.logViolation(String.format(errorFormat, dependencyKey, managedVersion, projectVersion));
                    this.logViolation(additionalMessage);
                    this.dependencyVersionMismatchError = true;
                    success = false;
                    continue;
                }
                if (originalDependency == null) continue;
                if (!config.allowVersions() && originalDependency.getVersion() != null) {
                    this.logViolation(String.format("Version tag must be removed for managed dependency %s", dependencyKey));
                    this.dependencyVersionDisallowedError = true;
                    success = false;
                }
                if (config.allowExclusions() || originalDependency.getExclusions().isEmpty()) continue;
                this.logViolation(String.format("Exclusions must be removed for managed dependency %s", dependencyKey));
                this.dependencyExclusionsError = true;
                success = false;
                continue;
            }
            if (!config.requireDependencyManagement()) continue;
            this.logViolation(String.format("Dependency %s is not managed", dependencyKey));
            this.unmanagedDependencyError = true;
            success = false;
        }
        if (this.dependencyVersionMismatchError && this.requireManagement.dependencyVersionMismatchMessage() != null) {
            this.errorMessages.add("Found versions mismatches in managed dependencies:");
            this.errorMessages.add(this.requireManagement.dependencyVersionMismatchMessage());
        }
        if (this.dependencyVersionDisallowedError && this.requireManagement.dependencyVersionDisallowedMessage() != null) {
            this.errorMessages.add("Found version in managed dependencies:");
            this.errorMessages.add(this.requireManagement.dependencyVersionDisallowedMessage());
        }
        if (this.dependencyExclusionsError && this.requireManagement.dependencyExclusionsMessage() != null) {
            this.errorMessages.add("Found exclusions in managed dependencies:");
            this.errorMessages.add(this.requireManagement.dependencyExclusionsMessage());
        }
        if (this.unmanagedDependencyError && this.requireManagement.unmanagedDependencyMessage() != null) {
            this.errorMessages.add("Found unmanaged dependencies:");
            this.errorMessages.add(this.requireManagement.unmanagedDependencyMessage());
        }
        return success;
    }

    private boolean checkPluginManagement() {
        Map<String, Plugin> managedPlugins = this.getManagedPluginsAsMap();
        boolean success = true;
        for (Plugin projectPlugin : this.project.getBuildPlugins()) {
            Plugin managedPlugin = managedPlugins.get(projectPlugin.getKey());
            RequireManagementConfig config = this.getEffectiveRequireManagementConfig(projectPlugin.getKey());
            if (managedPlugin != null) {
                String managedVersion;
                String projectVersion = projectPlugin.getVersion();
                if (projectVersion.equals(managedVersion = managedPlugin.getVersion())) continue;
                String errorFormat = "Version mismatch for plugin %s, managed version %s does not match version %s declared in module's pom";
                String additionalMessage = "If you intended to use the version specified in dependency management, please remove the version from this module's plugin dependency declaration.";
                this.logViolation(String.format(errorFormat, projectPlugin.getKey(), managedVersion, projectVersion));
                this.logViolation(additionalMessage);
                this.pluginVersionMismatchError = true;
                success = false;
                continue;
            }
            if (!config.requirePluginManagement()) continue;
            this.logViolation(String.format("Plugin %s is not managed", projectPlugin.getKey()));
            this.unmanagedPluginError = true;
            success = false;
        }
        if (this.pluginVersionMismatchError && this.requireManagement.pluginVersionMismatchMessage() != null) {
            this.errorMessages.add("Found version mismatches in plugins:");
            this.errorMessages.add(this.requireManagement.pluginVersionMismatchMessage());
        }
        if (this.unmanagedPluginError && this.requireManagement.unmanagedPluginMessage() != null) {
            this.errorMessages.add("Found unmanaged plugins:");
            this.errorMessages.add(this.requireManagement.unmanagedPluginMessage());
        }
        return success;
    }

    private Map<String, Plugin> getManagedPluginsAsMap() {
        if (this.project.getPluginManagement() == null) {
            return Collections.emptyMap();
        }
        return this.project.getPluginManagement().getPluginsAsMap();
    }

    private Map<String, Dependency> getManagedDependenciesAsMap() {
        if (this.project.getDependencyManagement() == null || this.project.getDependencyManagement().getDependencies() == null) {
            return Collections.emptyMap();
        }
        return DependencyManagementAnalyzer.asMap(this.project.getDependencyManagement().getDependencies());
    }

    private Map<String, Dependency> getOriginalDependenciesAsMap() {
        if (this.project.getOriginalModel() == null || this.project.getOriginalModel().getDependencies() == null) {
            return Collections.emptyMap();
        }
        return DependencyManagementAnalyzer.asMap(this.project.getOriginalModel().getDependencies());
    }

    private RequireManagementConfig getEffectiveRequireManagementConfig(String key) {
        if (key.indexOf(58) != key.lastIndexOf(58)) {
            key = key.substring(0, key.indexOf(58, key.indexOf(58) + 1));
        }
        for (RequireManagementOverride override : this.requireManagement.getOverrides()) {
            for (String pattern : override.getPatterns()) {
                if (!SelectorUtils.match((String)pattern, (String)key)) continue;
                return override.toRequireManagementConfig(this.requireManagement);
            }
        }
        return this.requireManagement;
    }

    private static Map<String, Dependency> asMap(List<Dependency> dependencies) {
        HashMap<String, Dependency> dependencyMap = new HashMap<String, Dependency>();
        for (Dependency dependency : dependencies) {
            dependencyMap.put(dependency.getManagementKey(), dependency);
        }
        return dependencyMap;
    }

    private void logViolation(String message) {
        this.violationLogger.accept(message);
    }
}

