/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.dvc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.basepom.mojo.dvc.Context;
import org.basepom.mojo.dvc.PluginLog;
import org.basepom.mojo.dvc.QualifiedName;
import org.basepom.mojo.dvc.ScopeLimitingFilter;
import org.basepom.mojo.dvc.StrategyCache;
import org.basepom.mojo.dvc.dependency.DependencyMap;
import org.basepom.mojo.dvc.dependency.DependencyMapBuilder;
import org.basepom.mojo.dvc.dependency.DependencyTreeResolver;
import org.basepom.mojo.dvc.model.ResolverDefinition;
import org.basepom.mojo.dvc.model.VersionCheckExcludes;
import org.basepom.mojo.dvc.strategy.StrategyProvider;
import org.basepom.mojo.dvc.version.VersionResolutionCollection;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.resolution.VersionRangeRequest;

public abstract class AbstractDependencyVersionsMojo
extends AbstractMojo
implements Context {
    private static final ImmutableSet<String> VALID_SCOPES = ImmutableSet.of((Object)"compile+runtime", (Object)"compile", (Object)"runtime", (Object)"test");
    protected final PluginLog LOG = new PluginLog(this.getClass());
    @Parameter(defaultValue="${project}", readonly=true)
    public MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    public MavenSession mavenSession;
    @Parameter(defaultValue="${reactorProjects}", readonly=true, required=true)
    public List<MavenProject> reactorProjects;
    @Component
    public ProjectBuilder mavenProjectBuilder;
    @Component
    public ProjectDependenciesResolver projectDependenciesResolver;
    @Component
    public RepositorySystem repositorySystem;
    @Component
    public StrategyProvider strategyProvider;
    @Parameter(alias="exceptions")
    public VersionCheckExcludes[] exclusions = new VersionCheckExcludes[0];
    @Parameter(defaultValue="false", property="dvc.skip")
    public boolean skip = false;
    @Parameter(defaultValue="false", property="dvc.include-pom-projects")
    public boolean includePomProjects = false;
    @Parameter(defaultValue="false", property="dvc.quiet")
    public boolean quiet = false;
    @Parameter(defaultValue="test", property="scope")
    public String scope = "test";
    @Parameter(defaultValue="false", property="dvc.deep-scan")
    public boolean deepScan = false;
    @Parameter(defaultValue="false", property="dvc.direct-only")
    public boolean directOnly = false;
    @Parameter(defaultValue="false", property="dvc.managed-only")
    public boolean managedOnly = false;
    @Parameter(defaultValue="true", property="dvc.fast-resolution")
    public boolean fastResolution = true;
    @Parameter(defaultValue="false", property="dvc.unresolved-system-artifacts-fail-build")
    protected boolean unresolvedSystemArtifactsFailBuild = false;
    @Parameter
    public ResolverDefinition[] resolvers = new ResolverDefinition[0];
    @Parameter(defaultValue="default", property="dvc.default-strategy")
    public String defaultStrategy = "default";
    protected StrategyCache strategyCache;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        block14: {
            block13: {
                for (VersionCheckExcludes exclusion : this.exclusions) {
                    Preconditions.checkState((boolean)exclusion.isValid(), (String)"Invalid exclusion specification: '%s'", (Object)exclusion);
                }
                Preconditions.checkState((!Strings.nullToEmpty((String)this.scope).trim().isEmpty() && VALID_SCOPES.contains((Object)this.scope) ? 1 : 0) != 0, (String)"Scope '%s' is invalid", (Object)this.scope);
                if (!this.skip) break block13;
                this.LOG.report(this.quiet, "Skipping plugin execution", new Object[0]);
                this.LOG.debug("Ended %s mojo run!", this.getClass().getSimpleName());
                return;
            }
            if (this.includePomProjects || !"pom".equals(this.project.getPackaging())) break block14;
            this.LOG.report(this.quiet, "Ignoring POM project", new Object[0]);
            this.LOG.debug("Ended %s mojo run!", this.getClass().getSimpleName());
            return;
        }
        try {
            this.LOG.debug("Starting %s mojo run!", this.getClass().getSimpleName());
            this.strategyCache = new StrategyCache(this.strategyProvider, this.resolvers, this.defaultStrategy);
            ScopeLimitingFilter scopeFilter = this.createScopeFilter();
            DependencyMap rootDependencyMap = new DependencyMapBuilder(this).mapProject(this.project, scopeFilter);
            try (DependencyTreeResolver dependencyTreeResolver = new DependencyTreeResolver(this, rootDependencyMap);){
                ImmutableSetMultimap<QualifiedName, VersionResolutionCollection> resolutionMap = dependencyTreeResolver.computeResolutionMap(this.project, scopeFilter);
                this.doExecute(resolutionMap, rootDependencyMap);
            }
        }
        catch (MojoExecutionException | MojoFailureException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new MojoExecutionException("While running mojo: ", e2);
                }
            }
            catch (Throwable throwable) {
                this.LOG.debug("Ended %s mojo run!", this.getClass().getSimpleName());
                throw throwable;
            }
        }
        this.LOG.debug("Ended %s mojo run!", this.getClass().getSimpleName());
        return;
    }

    protected abstract void doExecute(ImmutableSetMultimap<QualifiedName, VersionResolutionCollection> var1, DependencyMap var2) throws Exception;

    protected ScopeLimitingFilter createScopeFilter() {
        return ScopeLimitingFilter.computeDependencyScope(this.scope);
    }

    @Override
    public boolean useFastResolution() {
        return this.fastResolution;
    }

    @Override
    public boolean useDeepScan() {
        return this.deepScan;
    }

    @Override
    public StrategyCache getStrategyCache() {
        return this.strategyCache;
    }

    @Override
    public ProjectBuilder getProjectBuilder() {
        return this.mavenProjectBuilder;
    }

    @Override
    public ProjectDependenciesResolver getProjectDependenciesResolver() {
        return this.projectDependenciesResolver;
    }

    @Override
    public MavenProject getRootProject() {
        return this.project;
    }

    @Override
    public List<MavenProject> getReactorProjects() {
        return ImmutableList.copyOf(this.reactorProjects);
    }

    @Override
    public RepositorySystemSession getRepositorySystemSession() {
        return this.mavenSession.getRepositorySession();
    }

    @Override
    public RepositorySystem getRepositorySystem() {
        return this.repositorySystem;
    }

    @Override
    public ProjectBuildingRequest createProjectBuildingRequest() {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.mavenSession.getProjectBuildingRequest());
        buildingRequest.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
        return buildingRequest;
    }

    @Override
    public VersionRangeRequest createVersionRangeRequest(Artifact artifact) {
        Preconditions.checkNotNull((Object)artifact, (Object)"artifact is null");
        return new VersionRangeRequest(artifact, this.project.getRemoteProjectRepositories(), "");
    }

    @Override
    public List<VersionCheckExcludes> getExclusions() {
        return Arrays.asList(this.exclusions);
    }

    @Override
    public boolean isUnresolvedSystemArtifactsFailBuild() {
        return this.unresolvedSystemArtifactsFailBuild;
    }
}

