/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.dvc.dependency;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.basepom.mojo.dvc.CheckExclusionsFilter;
import org.basepom.mojo.dvc.Context;
import org.basepom.mojo.dvc.PluginLog;
import org.basepom.mojo.dvc.QualifiedName;
import org.basepom.mojo.dvc.ScopeLimitingFilter;
import org.basepom.mojo.dvc.dependency.DependencyMap;
import org.basepom.mojo.dvc.dependency.DependencyMapBuilder;
import org.basepom.mojo.dvc.strategy.Strategy;
import org.basepom.mojo.dvc.version.VersionResolution;
import org.basepom.mojo.dvc.version.VersionResolutionCollection;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.util.filter.AndDependencyFilter;

public final class DependencyTreeResolver
implements AutoCloseable {
    private static final PluginLog LOG = new PluginLog(DependencyTreeResolver.class);
    private static final int DEPENDENCY_RESOLUTION_NUM_THREADS = Runtime.getRuntime().availableProcessors() * 5;
    private final Context context;
    private final DependencyMap rootDependencyMap;
    private final ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(DEPENDENCY_RESOLUTION_NUM_THREADS, new ThreadFactoryBuilder().setNameFormat("dependency-version-check-worker-%s").setDaemon(true).build()));

    public DependencyTreeResolver(Context context, DependencyMap rootDependencyMap) {
        this.context = (Context)Preconditions.checkNotNull((Object)context, (Object)"context is null");
        this.rootDependencyMap = (DependencyMap)Preconditions.checkNotNull((Object)rootDependencyMap, (Object)"rootDependencyMap is null");
    }

    @Override
    public void close() {
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.executorService, (Duration)Duration.ofSeconds(2L));
    }

    public ImmutableSetMultimap<QualifiedName, VersionResolutionCollection> computeResolutionMap(MavenProject project, ScopeLimitingFilter scopeFilter) throws MojoExecutionException, AbstractArtifactResolutionException, VersionRangeResolutionException {
        ImmutableList dependencies;
        Preconditions.checkNotNull((Object)project, (Object)"project is null");
        Preconditions.checkNotNull((Object)scopeFilter, (Object)"scope is null");
        ImmutableSetMultimap.Builder collector = ImmutableSetMultimap.builder();
        ImmutableList.Builder futureBuilder = ImmutableList.builder();
        boolean useParallelDependencyResolution = this.context.useFastResolution();
        LOG.debug("Using parallel dependency resolution: %s", useParallelDependencyResolution);
        if (this.context.useDeepScan()) {
            LOG.debug("Running deep scan", new Object[0]);
            dependencies = ImmutableList.copyOf((Collection)((Collection)this.rootDependencyMap.getAllDependencies().values().stream().map(DependencyNode::getDependency).collect(ImmutableList.toImmutableList())));
        } else {
            ArtifactTypeRegistry stereotypes = this.context.getRepositorySystemSession().getArtifactTypeRegistry();
            dependencies = ImmutableList.copyOf((Collection)((Collection)project.getDependencies().stream().map(d -> RepositoryUtils.toDependency((Dependency)d, (ArtifactTypeRegistry)stereotypes)).collect(ImmutableList.toImmutableList())));
        }
        for (org.eclipse.aether.graph.Dependency dependency : dependencies) {
            if (useParallelDependencyResolution) {
                futureBuilder.add((Object)this.executorService.submit(() -> {
                    this.resolveProjectDependency(dependency, scopeFilter, (ImmutableSetMultimap.Builder<QualifiedName, VersionResolution>)collector);
                    return null;
                }));
                continue;
            }
            this.resolveProjectDependency(dependency, scopeFilter, (ImmutableSetMultimap.Builder<QualifiedName, VersionResolution>)collector);
        }
        if (useParallelDependencyResolution) {
            ImmutableList futures = futureBuilder.build();
            Throwable failed = null;
            boolean interrupted = false;
            for (ListenableFuture future : futures) {
                try {
                    if (interrupted || failed != null) {
                        future.cancel(true);
                    }
                    future.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    interrupted = true;
                }
                catch (ExecutionException e) {
                    if (failed != null) continue;
                    failed = e.getCause();
                }
            }
            if (failed != null) {
                throw new MojoExecutionException("While resolving dependencies:", failed);
            }
        }
        return VersionResolutionCollection.toResolutionMap((SetMultimap<QualifiedName, VersionResolution>)collector.build());
    }

    private void resolveProjectDependency(org.eclipse.aether.graph.Dependency dependency, ScopeLimitingFilter visibleScopes, ImmutableSetMultimap.Builder<QualifiedName, VersionResolution> collector) throws MojoExecutionException, AbstractArtifactResolutionException, VersionRangeResolutionException {
        DependencyNode projectDependencyNode;
        QualifiedName dependencyName = QualifiedName.fromDependency(dependency);
        if (this.rootDependencyMap.getDirectDependencies().containsKey((Object)dependencyName)) {
            projectDependencyNode = (DependencyNode)this.rootDependencyMap.getDirectDependencies().get((Object)dependencyName);
            Preconditions.checkState((boolean)visibleScopes.accept(projectDependencyNode, (List<DependencyNode>)ImmutableList.of()), (String)"Dependency %s maps to %s, but scope filter would exclude it. This should never happen!", (Object)dependency, (Object)projectDependencyNode);
            this.computeVersionResolutionForDirectDependency(collector, dependency, projectDependencyNode);
        }
        if ((projectDependencyNode = (DependencyNode)this.rootDependencyMap.getAllDependencies().get((Object)dependencyName)) == null) {
            return;
        }
        Preconditions.checkState((boolean)visibleScopes.accept(projectDependencyNode, (List<DependencyNode>)ImmutableList.of()), (String)"Dependency %s maps to %s, but scope filter would exclude it. This should never happen!", (Object)dependency, (Object)projectDependencyNode);
        try {
            ScopeLimitingFilter dependencyScope = ScopeLimitingFilter.computeTransitiveScope(dependency.getScope());
            this.computeVersionResolutionForTransitiveDependencies(collector, dependency, projectDependencyNode, dependencyScope);
        }
        catch (ProjectBuildingException e) {
            if (projectDependencyNode.getChildren().isEmpty()) {
                LOG.debug("Ignoring model building exception for %s, no children were declared", dependency);
            }
            LOG.warn("Could not read POM for %s, ignoring project and its dependencies!", dependency);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeVersionResolutionForDirectDependency(ImmutableSetMultimap.Builder<QualifiedName, VersionResolution> collector, org.eclipse.aether.graph.Dependency requestingDependency, DependencyNode resolvedDependencyNode) throws AbstractArtifactResolutionException, VersionRangeResolutionException, MojoExecutionException {
        QualifiedName requestingDependencyName = QualifiedName.fromDependency(requestingDependency);
        RepositorySystem repoSystem = this.context.getRepositorySystem();
        Artifact artifact = DependencyMapBuilder.convertToPomArtifact(requestingDependency.getArtifact());
        if (artifact.isSnapshot()) {
            artifact = artifact.setVersion(artifact.getBaseVersion());
        }
        VersionRangeRequest request = this.context.createVersionRangeRequest(artifact);
        VersionRangeResult result = repoSystem.resolveVersionRange(this.context.getRepositorySystemSession(), request);
        if (!result.getVersions().contains(resolvedDependencyNode.getVersion())) {
            throw new MojoExecutionException(String.format("Cannot determine the recommended version of dependency '%s'; its version specification is '%s', and the resolved version is '%s'.", requestingDependency, requestingDependency.getArtifact().getBaseVersion(), resolvedDependencyNode.getVersion()));
        }
        ComparableVersion expectedVersion = DependencyTreeResolver.getVersion(resolvedDependencyNode);
        boolean managedDependency = (resolvedDependencyNode.getManagedBits() & 1) != 0;
        VersionResolution resolution = VersionResolution.forDirectDependency(QualifiedName.fromProject(this.context.getRootProject()), expectedVersion, managedDependency);
        if (this.isIncluded(resolvedDependencyNode, expectedVersion, expectedVersion)) {
            Strategy strategy = this.context.getStrategyCache().forQualifiedName(requestingDependencyName);
            Preconditions.checkState((strategy != null ? 1 : 0) != 0, (String)"Strategy for %s is null, this should never happen (could not find default strategy?", (Object)requestingDependencyName);
            if (!strategy.isCompatible(expectedVersion, expectedVersion)) {
                resolution.conflict();
            }
        } else {
            LOG.debug("VersionResolution %s is excluded by configuration.", resolution);
        }
        ImmutableSetMultimap.Builder<QualifiedName, VersionResolution> builder = collector;
        synchronized (builder) {
            collector.put((Object)requestingDependencyName, (Object)resolution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeVersionResolutionForTransitiveDependencies(ImmutableSetMultimap.Builder<QualifiedName, VersionResolution> collector, org.eclipse.aether.graph.Dependency requestingDependency, DependencyNode dependencyNodeForDependency, DependencyFilter scopeFilter) throws AbstractArtifactResolutionException, ProjectBuildingException, MojoExecutionException {
        AndDependencyFilter filter = new AndDependencyFilter(new DependencyFilter[]{scopeFilter, new CheckExclusionsFilter(requestingDependency.getExclusions())});
        DependencyMap dependencyMap = new DependencyMapBuilder(this.context).mapDependency(dependencyNodeForDependency, (DependencyFilter)filter);
        ImmutableCollection transitiveDependencies = dependencyMap.getAllDependencies().values();
        QualifiedName requestingDependencyName = QualifiedName.fromDependency(requestingDependency);
        ImmutableSet filteredDependencies = (ImmutableSet)transitiveDependencies.stream().filter(d -> scopeFilter.accept(d, (List)ImmutableList.of())).filter(d -> !d.getDependency().isOptional()).collect(ImmutableSet.toImmutableSet());
        for (DependencyNode dependencyNode : filteredDependencies) {
            QualifiedName dependencyName = QualifiedName.fromDependencyNode(dependencyNode);
            DependencyNode projectDependencyNode = (DependencyNode)this.rootDependencyMap.getAllDependencies().get((Object)dependencyName);
            if (projectDependencyNode == null) continue;
            ComparableVersion resolvedVersion = DependencyTreeResolver.getVersion(projectDependencyNode);
            ComparableVersion expectedVersion = DependencyTreeResolver.getVersion(dependencyNode);
            boolean managedDependency = (projectDependencyNode.getManagedBits() & 1) != 0;
            VersionResolution resolution = VersionResolution.forTransitiveDependency(requestingDependencyName, expectedVersion, managedDependency);
            if (this.isIncluded(dependencyNode, expectedVersion, resolvedVersion)) {
                Strategy strategy = this.context.getStrategyCache().forQualifiedName(dependencyName);
                Preconditions.checkState((strategy != null ? 1 : 0) != 0, (String)"Strategy for %s is null, this should never happen (could not find default strategy?", (Object)dependencyName);
                if (!strategy.isCompatible(expectedVersion, resolvedVersion)) {
                    resolution.conflict();
                }
            }
            ImmutableSetMultimap.Builder<QualifiedName, VersionResolution> builder = collector;
            synchronized (builder) {
                collector.put((Object)dependencyName, (Object)resolution);
            }
        }
    }

    private boolean isIncluded(DependencyNode dependencyNodeForDependency, ComparableVersion expectedVersion, ComparableVersion resolvedVersion) {
        return this.context.getExclusions().stream().noneMatch(exclusion -> exclusion.matches(dependencyNodeForDependency, expectedVersion, resolvedVersion));
    }

    private static ComparableVersion getVersion(DependencyNode dependencyNode) throws OverConstrainedVersionException {
        Preconditions.checkNotNull((Object)dependencyNode, (Object)"dependencyNode is null");
        Preconditions.checkState((dependencyNode.getVersion() != null ? 1 : 0) != 0, (String)"DependencyNode %s has a null version selected. Please report a bug!", (Object)dependencyNode);
        return new ComparableVersion(dependencyNode.getVersion().toString());
    }
}

