/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.dvc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.Exclusion;

public final class CheckExclusionsFilter
implements DependencyFilter {
    private final List<Exclusion> exclusions;

    public CheckExclusionsFilter(Collection<Exclusion> exclusions) {
        this.exclusions = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(exclusions, (Object)"exclusions is null")));
    }

    public boolean accept(DependencyNode node, List<DependencyNode> parents) {
        Preconditions.checkNotNull((Object)node, (Object)"node is null");
        Iterator<Exclusion> iterator = this.exclusions.iterator();
        if (iterator.hasNext()) {
            Exclusion exclusion = iterator.next();
            if ("*".equals(exclusion.getArtifactId()) && "*".equals(exclusion.getGroupId())) {
                return false;
            }
            return !Objects.equals(exclusion.getArtifactId(), node.getArtifact().getArtifactId()) || !Objects.equals(exclusion.getGroupId(), node.getArtifact().getGroupId());
        }
        return true;
    }
}

