/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.dvc;

import com.google.common.base.Preconditions;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PluginLog {
    private final Logger logger;

    public PluginLog(Class<?> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"clazz is null");
        this.logger = LoggerFactory.getLogger(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(String fmt, Object ... args) {
        Preconditions.checkNotNull((Object)fmt, (Object)"fmt is null");
        Logger logger = this.logger;
        synchronized (logger) {
            this.logger.debug(String.format(fmt, args));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(Throwable t, String fmt, Object ... args) {
        Preconditions.checkNotNull((Object)fmt, (Object)"fmt is null");
        Preconditions.checkNotNull((Object)t, (Object)"t is null");
        Logger logger = this.logger;
        synchronized (logger) {
            this.logger.debug(String.format(fmt, args), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void info(String fmt, Object ... args) {
        Preconditions.checkNotNull((Object)fmt, (Object)"fmt is null");
        Logger logger = this.logger;
        synchronized (logger) {
            this.logger.info(String.format(fmt, args));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void info(Throwable t, String fmt, Object ... args) {
        Preconditions.checkNotNull((Object)fmt, (Object)"fmt is null");
        Preconditions.checkNotNull((Object)t, (Object)"t is null");
        Logger logger = this.logger;
        synchronized (logger) {
            this.logger.info(String.format(fmt, args), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String fmt, Object ... args) {
        Preconditions.checkNotNull((Object)fmt, (Object)"fmt is null");
        MessageBuilder mb = MessageUtils.buffer();
        Logger logger = this.logger;
        synchronized (logger) {
            this.logger.warn(mb.warning((Object)String.format(fmt, args)).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(Throwable t, String fmt, Object ... args) {
        Preconditions.checkNotNull((Object)fmt, (Object)"fmt is null");
        Preconditions.checkNotNull((Object)t, (Object)"t is null");
        MessageBuilder mb = MessageUtils.buffer();
        Logger logger = this.logger;
        synchronized (logger) {
            this.logger.warn(mb.warning((Object)String.format(fmt, args)).toString(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(String fmt, Object ... args) {
        Preconditions.checkNotNull((Object)fmt, (Object)"fmt is null");
        MessageBuilder mb = MessageUtils.buffer();
        Logger logger = this.logger;
        synchronized (logger) {
            this.logger.error(mb.failure((Object)String.format(fmt, args)).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(Throwable t, String fmt, Object ... args) {
        Preconditions.checkNotNull((Object)fmt, (Object)"fmt is null");
        Preconditions.checkNotNull((Object)t, (Object)"t is null");
        MessageBuilder mb = MessageUtils.buffer();
        Logger logger = this.logger;
        synchronized (logger) {
            this.logger.error(mb.failure((Object)String.format(fmt, args)).toString(), t);
        }
    }

    public void report(boolean quiet, String fmt, Object ... args) {
        if (quiet) {
            this.debug(fmt, args);
        } else {
            this.info(fmt, args);
        }
    }
}

