/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.dvc.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import org.basepom.mojo.dvc.QualifiedNameMatcher;

public final class ResolverDefinition {
    private String strategy = "";
    private ImmutableList<QualifiedNameMatcher> includes = ImmutableList.of();

    public void setStrategy(String strategy) {
        this.strategy = (String)Preconditions.checkNotNull((Object)strategy, (Object)"strategyName is null");
    }

    public void setIncludes(String[] includes) {
        Preconditions.checkNotNull((Object)includes, (Object)"includes is null");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String include : includes) {
            builder.add((Object)new QualifiedNameMatcher(include));
        }
        this.includes = builder.build();
    }

    public String getStrategy() {
        return this.strategy;
    }

    public ImmutableList<QualifiedNameMatcher> getIncludes() {
        return this.includes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolverDefinition that = (ResolverDefinition)o;
        return this.strategy.equals(that.strategy) && this.includes.equals(that.includes);
    }

    public int hashCode() {
        return Objects.hash(this.strategy, this.includes);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("strategy", (Object)this.strategy).add("includes", this.includes).toString();
    }
}

