/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.dvc.strategy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.basepom.mojo.dvc.strategy.Strategy;
import org.basepom.mojo.dvc.strategy.StrategyProvider;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=StrategyProvider.class)
public class DefaultStrategyProvider
implements StrategyProvider {
    @Requirement(role=Strategy.class)
    protected List<Strategy> resolverDefinitions = ImmutableList.of();

    @Override
    public ImmutableMap<String, Strategy> getStrategies() {
        return (ImmutableMap)this.resolverDefinitions.stream().collect(ImmutableMap.toImmutableMap(r -> r.getName().toLowerCase(Locale.ENGLISH), Function.identity()));
    }

    @Override
    public Strategy forName(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        ImmutableMap<String, Strategy> strategies = this.getStrategies();
        return (Strategy)strategies.get(name.toLowerCase(Locale.ENGLISH));
    }
}

